/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot;

import java.util.Arrays;

public enum PlotStyle {
    BAR,
    STACKED_BAR,
    LINE,
    AREA,
    STACKED_AREA,
    PIE,
    HISTOGRAM,
    OHLC,
    SCATTER,
    STEP,
    ERROR_BAR,
    TREEMAP;


    public static PlotStyle plotStyle(String style) {
        if (style == null) {
            throw new IllegalArgumentException("PlotStyle can not be null!");
        }
        try {
            return PlotStyle.valueOf(style.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("PlotStyle " + style + " is not defined");
        }
    }

    public static String[] plotStyleNames() {
        return (String[])Arrays.stream(PlotStyle.values()).map(Enum::name).toArray(String[]::new);
    }
}

