/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot;

import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.SeriesInternal;
import io.deephaven.plot.errors.PlotExceptionCause;
import io.deephaven.plot.errors.PlotIllegalArgumentException;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.errors.PlotUnsupportedOperationException;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.SwappableTable;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class SeriesCollection
implements Serializable,
PlotExceptionCause {
    private static final long serialVersionUID = -8561681018661975444L;
    private final PlotInfo plotInfo;
    private final AtomicInteger seriesCounter = new AtomicInteger(-1);
    private final Map<Comparable, SeriesDescription> seriesDescriptions = new LinkedHashMap<Comparable, SeriesDescription>();
    private final Map<Integer, SeriesInternal> index = new HashMap<Integer, SeriesInternal>();

    public SeriesCollection(PlotInfo plotInfo) {
        this.plotInfo = plotInfo;
    }

    @Override
    public PlotInfo getPlotInfo() {
        return this.plotInfo;
    }

    public synchronized SeriesCollection copy(AxesImpl axes) {
        ArgumentValidations.assertNotNull(axes, "axes", this.plotInfo);
        SeriesCollection result = new SeriesCollection(axes.getPlotInfo());
        result.seriesCounter.set(this.seriesCounter.get());
        for (SeriesDescription seriesDescriptions : this.seriesDescriptions.values()) {
            SeriesInternal s = seriesDescriptions.series.copy(axes);
            result.add(seriesDescriptions.type, seriesDescriptions.isMultiSeries, s);
        }
        return result;
    }

    public synchronized Map<Comparable, SeriesDescription> getSeriesDescriptions() {
        return Collections.unmodifiableMap(new LinkedHashMap<Comparable, SeriesDescription>(this.seriesDescriptions));
    }

    int nextId() {
        return this.seriesCounter.incrementAndGet();
    }

    public synchronized SeriesInternal series(int id) {
        return this.index.get(id);
    }

    public synchronized SeriesInternal series(Comparable name) {
        SeriesDescription seriesDescription = this.seriesDescriptions.get(name);
        if (seriesDescription == null) {
            throw new PlotIllegalArgumentException("Series " + name + " not found", this);
        }
        return seriesDescription.series;
    }

    public synchronized Set<SwappableTable> getSwappableTables() {
        HashSet<SwappableTable> swappableTables = new HashSet<SwappableTable>();
        this.index.values().forEach(series -> swappableTables.addAll(series.getSwappableTables()));
        return swappableTables;
    }

    synchronized SeriesInternal lastSeries() {
        if (this.seriesDescriptions.isEmpty()) {
            return null;
        }
        SeriesDescription last = null;
        Iterator<SeriesDescription> iterator = this.seriesDescriptions.values().iterator();
        while (iterator.hasNext()) {
            SeriesDescription seriesDescription;
            last = seriesDescription = iterator.next();
        }
        return last.getSeries();
    }

    public synchronized void add(SeriesType type, boolean isMultiSeries, SeriesInternal series) {
        if (this.seriesDescriptions.containsKey(series.name())) {
            throw new PlotUnsupportedOperationException("Series with the same name already exists in the collection.  name=" + series.name(), this);
        }
        this.seriesDescriptions.put(series.name(), new SeriesDescription(type, isMultiSeries, series));
        this.index.put(series.id(), series);
    }

    public synchronized void remove(Comparable ... names) {
        for (Comparable name : names) {
            SeriesDescription v = this.seriesDescriptions.get(name);
            if (v == null) continue;
            this.seriesDescriptions.remove(name);
            this.index.remove(v.series.id());
        }
    }

    public static class SeriesDescription
    implements Serializable {
        private static final long serialVersionUID = 1791578353902414235L;
        private final SeriesType type;
        private final boolean isMultiSeries;
        private final SeriesInternal series;

        private SeriesDescription(SeriesType type, boolean isMultiSeries, SeriesInternal series) {
            this.type = type;
            this.isMultiSeries = isMultiSeries;
            this.series = series;
        }

        public SeriesType getType() {
            return this.type;
        }

        public boolean isMultiSeries() {
            return this.isMultiSeries;
        }

        public SeriesInternal getSeries() {
            return this.series;
        }
    }

    public static enum SeriesType {
        CATEGORY,
        XY,
        UNARY_FUNCTION,
        BINARY_FUNCTION,
        INTERVAL,
        OHLC;

    }
}

