/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.axisformatters;

import io.deephaven.plot.axisformatters.AxisFormat;
import io.deephaven.time.DateTime;
import io.deephaven.time.TimeZone;
import java.io.Serializable;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.time.format.DateTimeFormatter;

public class NanosAxisFormat
implements AxisFormat,
Serializable {
    private static final long serialVersionUID = -2096650974534906333L;
    private TimeZone tz;
    private String pattern;
    private NanosFormat instance = null;

    public NanosAxisFormat(TimeZone tz) {
        this.tz = tz;
    }

    public NanosAxisFormat() {
        this(TimeZone.TZ_DEFAULT);
    }

    @Override
    public void setPattern(String pattern) {
        if (pattern != null) {
            DateTimeFormatter.ofPattern(pattern);
        }
        this.pattern = pattern;
        if (this.instance != null) {
            this.instance.updateFormatter(pattern);
        }
    }

    @Override
    public NumberFormat getNumberFormatter() {
        if (this.instance == null) {
            this.instance = new NanosFormat();
        }
        return this.instance;
    }

    public class NanosFormat
    extends NumberFormat {
        private static final long serialVersionUID = 6037426284760469353L;
        private DateTimeFormatter formatter;

        private NanosFormat() {
            this.updateFormatter(NanosAxisFormat.this.pattern);
        }

        public void updateTimeZone(TimeZone tz) {
            NanosAxisFormat.this.tz = tz;
            if (this.formatter != null) {
                this.formatter = this.formatter.withZone(tz.getTimeZone().toTimeZone().toZoneId());
            }
        }

        private void updateFormatter(String format) {
            format = format == null ? "yyyy-MM-dd" : format;
            this.formatter = DateTimeFormatter.ofPattern(format).withZone(NanosAxisFormat.this.tz.getTimeZone().toTimeZone().toZoneId());
        }

        @Override
        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            return this.format((long)number, toAppendTo, pos);
        }

        @Override
        public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(this.formatter.format(new DateTime(number).getInstant()));
        }

        @Override
        public Number parse(String source, ParsePosition parsePosition) {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

