/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.axistransformations;

import io.deephaven.base.verify.Require;
import io.deephaven.plot.axistransformations.AxisTransform;
import io.deephaven.time.DateTime;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.time.calendar.BusinessCalendar;
import io.deephaven.time.calendar.BusinessPeriod;
import io.deephaven.time.calendar.BusinessSchedule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class AxisTransformBusinessCalendar
implements AxisTransform,
Serializable {
    private static final long serialVersionUID = -8648623559661981847L;
    private final BusinessCalendar busCal;
    private final List<Nugget> nuggets = new ArrayList<Nugget>();

    public AxisTransformBusinessCalendar(BusinessCalendar busCal) {
        Require.neqNull((Object)busCal, (String)"BusinessCalendar");
        this.busCal = busCal;
    }

    public BusinessCalendar getBusinessCalendar() {
        return this.busCal;
    }

    private Nugget getNuggetByTime(double timeNanos) {
        Nugget n2;
        BusinessSchedule d;
        Nugget nMax;
        if (Double.isInfinite(timeNanos) || Double.isNaN(timeNanos)) {
            throw new IllegalStateException("Invalid input: " + timeNanos);
        }
        Nugget nMin = this.nuggets.size() == 0 ? null : this.nuggets.get(0);
        Nugget nugget = nMax = this.nuggets.size() == 0 ? null : this.nuggets.get(this.nuggets.size() - 1);
        if (nMin == null) {
            DateTime t = new DateTime((long)timeNanos);
            nMax = nMin = new Nugget(this.busCal.getBusinessSchedule(this.busCal.previousBusinessDay(t)), 0L);
            this.nuggets.add(nMin);
        }
        while (timeNanos < (double)nMin.businessDay.getSOBD().getNanos()) {
            d = this.busCal.getBusinessSchedule(this.busCal.previousBusinessDay(nMin.businessDay.getSOBD()));
            n2 = new Nugget(d, nMin.cumulativeBusinessTimeNanosAtStartOfDay - d.getLOBD());
            this.nuggets.add(0, n2);
            nMin = n2;
        }
        while (timeNanos > (double)nMax.businessDay.getEOBD().getNanos()) {
            d = this.busCal.getBusinessSchedule(this.busCal.nextBusinessDay(nMax.businessDay.getEOBD()));
            n2 = new Nugget(d, nMax.cumulativeBusinessTimeNanosAtStartOfDay + nMax.businessDay.getLOBD());
            this.nuggets.add(n2);
            nMax = n2;
        }
        return this.findNugget(n -> timeNanos <= (double)n.businessDay.getEOBD().getNanos());
    }

    private Nugget getNuggetByValue(double value) {
        Nugget n2;
        BusinessSchedule d;
        Nugget nMax;
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new IllegalStateException("Invalid input: " + value);
        }
        Nugget nMin = this.nuggets.size() == 0 ? null : this.nuggets.get(0);
        Nugget nugget = nMax = this.nuggets.size() == 0 ? null : this.nuggets.get(this.nuggets.size() - 1);
        if (nMin == null) {
            return null;
        }
        while (value < (double)nMin.cumulativeBusinessTimeNanosAtStartOfDay) {
            d = this.busCal.getBusinessSchedule(this.busCal.previousBusinessDay(nMin.businessDay.getSOBD()));
            n2 = new Nugget(d, nMin.cumulativeBusinessTimeNanosAtStartOfDay - d.getLOBD());
            this.nuggets.add(0, n2);
            nMin = n2;
        }
        if (nMax == null) {
            return null;
        }
        while (value > (double)(nMax.cumulativeBusinessTimeNanosAtStartOfDay + nMax.businessDay.getLOBD())) {
            d = this.busCal.getBusinessSchedule(this.busCal.nextBusinessDay(nMax.businessDay.getEOBD()));
            n2 = new Nugget(d, nMax.cumulativeBusinessTimeNanosAtStartOfDay + nMax.businessDay.getLOBD());
            this.nuggets.add(n2);
            nMax = n2;
        }
        return this.findNugget(n -> value < (double)(n.cumulativeBusinessTimeNanosAtStartOfDay + n.businessDay.getLOBD()));
    }

    private Nugget findNugget(Predicate<Nugget> lessThanEqual) {
        int iMin = 0;
        int iMax = this.nuggets.size() - 1;
        while (iMax - iMin > 1) {
            int iMid = iMin + (iMax - iMin) / 2;
            Nugget nMid = this.nuggets.get(iMid);
            if (lessThanEqual.test(nMid)) {
                iMax = iMid;
                continue;
            }
            iMin = iMid;
        }
        int iMatch = lessThanEqual.test(this.nuggets.get(iMin)) ? iMin : (lessThanEqual.test(this.nuggets.get(iMax)) ? iMax : iMin);
        return this.nuggets.get(iMatch);
    }

    @Override
    public boolean isVisible(double timeNanos) {
        return !Double.isInfinite(timeNanos) && !Double.isNaN(timeNanos) && this.busCal.isBusinessTime(DateTimeUtils.nanosToTime((long)((long)timeNanos)));
    }

    @Override
    public double inverseTransform(double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            return Double.NaN;
        }
        Nugget n = this.getNuggetByValue(value);
        if (n == null) {
            return Double.NaN;
        }
        double busDayNanos = value - (double)n.cumulativeBusinessTimeNanosAtStartOfDay;
        double timeNanos = n.businessDay.getSOBD().getNanos();
        for (BusinessPeriod period : n.businessDay.getBusinessPeriods()) {
            double start = period.getStartTime().getNanos();
            double end = period.getEndTime().getNanos();
            double length = end - start;
            if (!(busDayNanos > 0.0) || !(length > 0.0)) continue;
            if (busDayNanos > length) {
                timeNanos = end;
                busDayNanos -= length;
                continue;
            }
            timeNanos = start + busDayNanos;
            busDayNanos = 0.0;
        }
        return timeNanos;
    }

    @Override
    public double transform(double timeNanos) {
        if (Double.isInfinite(timeNanos) || Double.isNaN(timeNanos)) {
            return Double.NaN;
        }
        Nugget n = this.getNuggetByTime(timeNanos);
        double value = n.cumulativeBusinessTimeNanosAtStartOfDay;
        for (BusinessPeriod period : n.businessDay.getBusinessPeriods()) {
            double start = period.getStartTime().getNanos();
            double end = period.getEndTime().getNanos();
            if (!(timeNanos > start)) continue;
            if (timeNanos < end) {
                value += timeNanos - start;
                continue;
            }
            value += end - start;
        }
        return value;
    }

    private static class Nugget {
        private final BusinessSchedule businessDay;
        private final long cumulativeBusinessTimeNanosAtStartOfDay;

        private Nugget(BusinessSchedule day, long cumulativeBusinessTimeNanosAtStartOfDay) {
            this.businessDay = day;
            this.cumulativeBusinessTimeNanosAtStartOfDay = cumulativeBusinessTimeNanosAtStartOfDay;
        }
    }
}

