/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.axistransformations;

import io.deephaven.base.verify.Require;
import io.deephaven.plot.axistransformations.AxisTransform;
import java.io.Serializable;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;

public class AxisTransformLambda
implements AxisTransform,
Serializable {
    private static final long serialVersionUID = 303405833375630361L;
    private final DoubleUnaryOperator dta;
    private final DoubleUnaryOperator atd;
    private final DoublePredicate isVisible;

    public AxisTransformLambda(DoubleUnaryOperator dataToAxis, DoubleUnaryOperator axisToData, DoublePredicate isVisible) {
        Require.neqNull((Object)dataToAxis, (String)"dataToAxis");
        Require.neqNull((Object)axisToData, (String)"axisToData");
        Require.neqNull((Object)isVisible, (String)"isVisible");
        this.dta = dataToAxis;
        this.atd = axisToData;
        this.isVisible = isVisible;
    }

    public AxisTransformLambda(DoubleUnaryOperator dataToAxis, DoubleUnaryOperator axisToData) {
        this(dataToAxis, axisToData, (DoublePredicate & Serializable)v -> true);
    }

    public AxisTransformLambda() {
        this((DoubleUnaryOperator & Serializable)v -> v, (DoubleUnaryOperator & Serializable)v -> v, (DoublePredicate & Serializable)v -> true);
    }

    @Override
    public double transform(double dataValue) {
        return this.dta.applyAsDouble(dataValue);
    }

    @Override
    public double inverseTransform(double axisValue) {
        return this.atd.applyAsDouble(axisValue);
    }

    @Override
    public boolean isVisible(double dataValue) {
        return this.isVisible.test(dataValue);
    }
}

