/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.axistransformations;

import io.deephaven.plot.axistransformations.AxisTransform;
import io.deephaven.plot.axistransformations.AxisTransformBusinessCalendar;
import io.deephaven.time.calendar.BusinessCalendar;
import io.deephaven.time.calendar.Calendars;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public enum AxisTransforms implements AxisTransform,
Serializable
{
    LOG((DoubleUnaryOperator & Serializable)x -> x <= 0.0 ? Double.NaN : Math.log(x), Math::exp, (DoublePredicate & Serializable)x -> x > 0.0),
    SQRT((DoubleUnaryOperator & Serializable)x -> x < 0.0 ? Double.NaN : Math.sqrt(x), (DoubleUnaryOperator & Serializable)x -> x * x, (DoublePredicate & Serializable)x -> x >= 0.0);

    private final DoubleUnaryOperator transform;
    private final DoubleUnaryOperator inverseTransform;
    private final DoublePredicate isVisible;
    private static final Logger log;

    private AxisTransforms(DoubleUnaryOperator dataToAxis, DoubleUnaryOperator axisToData, DoublePredicate isVisible) {
        this.transform = dataToAxis;
        this.inverseTransform = axisToData;
        this.isVisible = isVisible;
    }

    @Override
    public double transform(double dataValue) {
        return this.transform.applyAsDouble(dataValue);
    }

    @Override
    public double inverseTransform(double axisValue) {
        return this.inverseTransform.applyAsDouble(axisValue);
    }

    @Override
    public boolean isVisible(double dataValue) {
        return this.isVisible.test(dataValue);
    }

    public static AxisTransform axisTransform(String name) {
        AxisTransformBusinessCalendar at2;
        AxisTransforms at1;
        if (name == null) {
            throw new IllegalArgumentException("AxisTransform can not be null!");
        }
        try {
            at1 = AxisTransforms.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            at1 = null;
        }
        try {
            BusinessCalendar cal = Calendars.calendar((String)name);
            at2 = new AxisTransformBusinessCalendar(cal);
        }
        catch (IllegalArgumentException e) {
            at2 = null;
        }
        if (at1 != null && at2 != null) {
            log.warning("Axis transform is defined in both enum and calendar.  Returning the enum value.  name=" + name);
            return at1;
        }
        if (at1 != null) {
            return at1;
        }
        if (at2 != null) {
            return at2;
        }
        throw new IllegalArgumentException("AxisTransform " + name + " is not defined");
    }

    public static String[] axisTransformNames() {
        LinkedHashSet<String> calendars;
        Set results = Arrays.stream(AxisTransforms.values()).map(Enum::name).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashSet conflicts = new LinkedHashSet(results);
        boolean hasConflicts = conflicts.retainAll(calendars = new LinkedHashSet<String>(Arrays.asList(Calendars.calendarNames())));
        if (hasConflicts) {
            log.warning("AxisTransform enum and calendar names have conflicting values: values=" + conflicts);
        }
        results.addAll(calendars);
        return results.toArray(new String[0]);
    }

    static {
        log = Logger.getLogger(AxisTransforms.class.toString());
    }
}

