/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.colors;

import groovy.lang.Closure;
import io.deephaven.base.verify.Require;
import io.deephaven.gui.color.Color;
import io.deephaven.gui.color.Paint;
import io.deephaven.plot.util.Range;
import io.deephaven.plot.util.functions.SerializableClosure;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class ColorMaps
implements Serializable {
    private static final long serialVersionUID = 3745916287909277642L;

    private ColorMaps() {
    }

    public static Function<Double, Color> heatMap(double min, double max) {
        return ColorMaps.heatMap(min, max, Color.color((String)"blue"), Color.color((String)"red"), Color.color((String)"yellow"));
    }

    public static Function<Double, Color> heatMap(double min, double max, Color startColor, Color endColor) {
        return ColorMaps.heatMap(min, max, startColor, endColor, null);
    }

    public static Function<Double, Color> heatMap(double min, double max, Color startColor, Color endColor, Color nullColor) {
        return (Function<Double, Color> & Serializable)value -> {
            if (value == null || value == Double.NaN) {
                return nullColor;
            }
            if (value <= min) {
                return startColor;
            }
            if (value >= max) {
                return endColor;
            }
            double pert = (value - min) / (max - min);
            int r1 = startColor.javaColor().getRed();
            int g1 = startColor.javaColor().getGreen();
            int b1 = startColor.javaColor().getBlue();
            int r2 = endColor.javaColor().getRed();
            int g2 = endColor.javaColor().getGreen();
            int b2 = endColor.javaColor().getBlue();
            return new Color((int)((double)r1 + pert * (double)(r2 - r1)), (int)((double)g1 + pert * (double)(g2 - g1)), (int)((double)b1 + pert * (double)(b2 - b1)));
        };
    }

    public static <COLOR extends Paint> Function<Double, Paint> rangeMap(Map<Range, COLOR> map) {
        return ColorMaps.rangeMap(map, null);
    }

    public static <COLOR extends Paint> Function<Double, Paint> rangeMap(Map<Range, COLOR> map, Color outOfRangeColor) {
        return ColorMaps.rangeMap(map, (Paint)outOfRangeColor, null);
    }

    public static <COLOR extends Paint> Function<Double, Paint> rangeMap(Map<Range, COLOR> map, Paint outOfRangeColor, Paint nullColor) {
        Require.neqNull(map, (String)"map");
        LinkedHashMap<1, Paint> pm = new LinkedHashMap<1, Paint>();
        for (Map.Entry<Range, COLOR> e : map.entrySet()) {
            final Range range = e.getKey();
            Paint color = (Paint)e.getValue();
            pm.put(new SerializablePredicate<Double>(){
                private static final long serialVersionUID = 613420989214281949L;

                @Override
                public boolean test(Double o) {
                    return range.inRange(o);
                }
            }, color);
        }
        return ColorMaps.predicateMap(pm, outOfRangeColor, nullColor);
    }

    public static <COLOR extends Paint> Function<Double, Paint> predicateMap(Map<SerializablePredicate<Double>, COLOR> map) {
        return ColorMaps.predicateMap(map, null);
    }

    public static <COLOR extends Paint> Function<Double, Paint> predicateMap(Map<SerializablePredicate<Double>, COLOR> map, Color outOfRangeColor) {
        return ColorMaps.predicateMap(map, (Paint)outOfRangeColor, null);
    }

    public static <COLOR extends Paint> Function<Double, Paint> predicateMap(Map<SerializablePredicate<Double>, COLOR> map, Paint outOfRangeColor, Paint nullColor) {
        Require.neqNull(map, (String)"map");
        return (Function<Double, Paint> & Serializable)value -> {
            if (value == null || value == Double.NaN) {
                return nullColor;
            }
            for (Map.Entry e : map.entrySet()) {
                Predicate r = (Predicate)e.getKey();
                Paint c = (Paint)e.getValue();
                if (r == null || !r.test(value)) continue;
                return c;
            }
            return outOfRangeColor;
        };
    }

    public static <COLOR extends Paint> Function<Double, Paint> closureMap(Map<Closure<Boolean>, COLOR> map) {
        return ColorMaps.closureMap(map, null);
    }

    public static <COLOR extends Paint> Function<Double, Paint> closureMap(Map<Closure<Boolean>, COLOR> map, Color outOfRangeColor) {
        return ColorMaps.closureMap(map, (Paint)outOfRangeColor, null);
    }

    public static <COLOR extends Paint> Function<Double, Paint> closureMap(Map<Closure<Boolean>, COLOR> map, Paint outOfRangeColor, Paint nullColor) {
        LinkedHashMap<2, Paint> pm = new LinkedHashMap<2, Paint>();
        for (Map.Entry<Closure<Boolean>, COLOR> e : map.entrySet()) {
            Closure<Boolean> closure = e.getKey();
            Paint color = (Paint)e.getValue();
            final SerializableClosure<Boolean> serializableClosure = new SerializableClosure<Boolean>(closure);
            SerializablePredicate<Double> predicate = new SerializablePredicate<Double>(){
                private static final long serialVersionUID = 613420989214281949L;

                @Override
                public boolean test(Double aDouble) {
                    return (Boolean)serializableClosure.getClosure().call((Object)aDouble);
                }
            };
            pm.put(predicate, color);
        }
        return ColorMaps.predicateMap(pm, outOfRangeColor, nullColor);
    }

    public static interface SerializablePredicate<T>
    extends Predicate<T>,
    Serializable {
    }
}

