/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.composite;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.table.Table;
import io.deephaven.plot.Figure;
import io.deephaven.plot.FigureFactory;
import io.deephaven.plot.FigureImpl;
import io.deephaven.plot.PlotStyle;
import io.deephaven.plot.datasets.data.IndexableData;
import io.deephaven.plot.datasets.data.IndexableDataDouble;
import io.deephaven.plot.datasets.data.IndexableNumericData;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayDouble;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayFloat;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayInt;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayLong;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayNumber;
import io.deephaven.plot.errors.PlotExceptionCause;
import io.deephaven.plot.errors.PlotIllegalArgumentException;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.filters.SelectableDataSet;
import io.deephaven.plot.util.ArgumentValidations;
import java.util.Arrays;
import java.util.stream.IntStream;

public class ScatterPlotMatrix
extends FigureImpl
implements PlotExceptionCause {
    private static final long serialVersionUID = 2502045888378915453L;
    private final FigureImpl figure;
    private final int numCols;

    private ScatterPlotMatrix(FigureImpl figure, int numCols) {
        super(figure);
        this.figure = figure;
        this.numCols = numCols;
    }

    @Override
    public PlotInfo getPlotInfo() {
        return this.figure.getFigure().getPlotInfo();
    }

    private ScatterPlotMatrix(ScatterPlotMatrix spm) {
        this(spm, spm.numCols);
    }

    @Override
    public ScatterPlotMatrix pointSize(int pointSize) {
        return this.pointSize(pointSize == Integer.MIN_VALUE ? null : Integer.valueOf(pointSize));
    }

    @Override
    public ScatterPlotMatrix pointSize(long pointSize) {
        return this.pointSize(pointSize == Long.MIN_VALUE ? null : Long.valueOf(pointSize));
    }

    @Override
    public ScatterPlotMatrix pointSize(double pointSize) {
        FigureImpl result = new FigureImpl(this);
        for (int i = 0; i < this.numCols * this.numCols; ++i) {
            result = result.chart(i).axes(0).series(0).pointSize(pointSize);
        }
        return new ScatterPlotMatrix(result, this.numCols);
    }

    @Override
    public ScatterPlotMatrix pointSize(Number pointSize) {
        FigureImpl result = new FigureImpl(this);
        for (int i = 0; i < this.numCols; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                result = result.chart(i, j).axes(0).series(0).pointSize(pointSize);
            }
        }
        return new ScatterPlotMatrix(result, this.numCols);
    }

    public ScatterPlotMatrix pointSize(int plotIndex, int factor) {
        return this.pointSize(plotIndex, (Number)(factor == Integer.MIN_VALUE ? null : Integer.valueOf(factor)));
    }

    public ScatterPlotMatrix pointSize(int plotIndex, long factor) {
        return this.pointSize(plotIndex, (Number)(factor == Long.MIN_VALUE ? null : Long.valueOf(factor)));
    }

    public ScatterPlotMatrix pointSize(int plotIndex, double factor) {
        if (plotIndex < 0 || plotIndex >= this.numCols * this.numCols) {
            throw new PlotIllegalArgumentException("Plot index out of bounds", this);
        }
        FigureImpl result = new FigureImpl(this).chart(plotIndex).axes(0).series(0).pointSize(factor);
        return new ScatterPlotMatrix(result, this.numCols);
    }

    public ScatterPlotMatrix pointSize(int plotIndex, Number factor) {
        if (plotIndex < 0 || plotIndex >= this.numCols * this.numCols) {
            throw new PlotIllegalArgumentException("Plot index out of bounds", this);
        }
        FigureImpl result = new FigureImpl(this).chart(plotIndex).axes(0).series(0).pointSize(factor);
        return new ScatterPlotMatrix(result, this.numCols);
    }

    public ScatterPlotMatrix pointSize(int row, int col, int factor) {
        return this.pointSize(row, col, factor == Integer.MIN_VALUE ? null : Integer.valueOf(factor));
    }

    public ScatterPlotMatrix pointSize(int row, int col, long factor) {
        return this.pointSize(row, col, factor == Long.MIN_VALUE ? null : Long.valueOf(factor));
    }

    public ScatterPlotMatrix pointSize(int row, int col, double factor) {
        int plotIndex = row * this.numCols + col;
        return this.pointSize(plotIndex, factor);
    }

    public ScatterPlotMatrix pointSize(int row, int col, Number factor) {
        int plotIndex = row * this.numCols + col;
        return this.pointSize(plotIndex, factor);
    }

    @Override
    public ScatterPlotMatrix pointSize(IndexableData<Double> pointSizes) {
        Require.neqNull(pointSizes, (String)"factors");
        Require.eq((int)pointSizes.size(), (String)"number of factors", (int)(this.numCols * this.numCols), (String)"number of plots");
        FigureImpl result = new FigureImpl(this);
        for (int i = 0; i < this.numCols * this.numCols; ++i) {
            result = result.chart(i).axes(0).series(0).pointSize(pointSizes.get(i));
        }
        return new ScatterPlotMatrix(result, this.numCols);
    }

    @Override
    public ScatterPlotMatrix pointSize(int ... pointSizes) {
        return this.pointSize((IndexableData)new IndexableDataDouble(pointSizes, true, this.getPlotInfo()));
    }

    @Override
    public ScatterPlotMatrix pointSize(long ... pointSizes) {
        return this.pointSize((IndexableData)new IndexableDataDouble(pointSizes, true, this.getPlotInfo()));
    }

    @Override
    public ScatterPlotMatrix pointSize(double ... pointSizes) {
        return this.pointSize((IndexableData)new IndexableDataDouble(pointSizes, true, this.getPlotInfo()));
    }

    @Override
    public <T extends Number> ScatterPlotMatrix pointSize(T[] pointSizes) {
        return this.pointSize((IndexableData)new IndexableDataDouble(pointSizes, true, this.getPlotInfo()));
    }

    public static <T extends Number> ScatterPlotMatrix scatterPlotMatrix(T[] ... variables) {
        Require.neqNull(variables, (String)"variables");
        String[] variableNames = (String[])IntStream.range(0, variables.length).mapToObj(i -> "x" + i).toArray(String[]::new);
        return ScatterPlotMatrix.scatterPlotMatrix((String[])variableNames, variables);
    }

    public static <T extends Number> ScatterPlotMatrix scatterPlotMatrix(String[] variableNames, T[] ... variables) {
        IndexableNumericData[] data = (IndexableNumericData[])Arrays.stream(variables).map(x -> new IndexableNumericDataArrayNumber(x, null)).toArray(IndexableNumericData[]::new);
        return ScatterPlotMatrix.scatterPlotMatrix(variableNames, data);
    }

    public static ScatterPlotMatrix scatterPlotMatrix(int[] ... variables) {
        Require.neqNull((Object)variables, (String)"variables");
        String[] variableNames = (String[])IntStream.range(0, variables.length).mapToObj(i -> "x" + i).toArray(String[]::new);
        return ScatterPlotMatrix.scatterPlotMatrix(variableNames, variables);
    }

    public static ScatterPlotMatrix scatterPlotMatrix(String[] variableNames, int[] ... variables) {
        Require.neqNull((Object)variables, (String)"variables");
        IndexableNumericData[] data = (IndexableNumericData[])Arrays.stream(variables).map(x -> new IndexableNumericDataArrayInt((int[])x, null)).toArray(IndexableNumericData[]::new);
        return ScatterPlotMatrix.scatterPlotMatrix(variableNames, data);
    }

    public static ScatterPlotMatrix scatterPlotMatrix(long[] ... variables) {
        Require.neqNull((Object)variables, (String)"variables");
        String[] variableNames = (String[])IntStream.range(0, variables.length).mapToObj(i -> "x" + i).toArray(String[]::new);
        return ScatterPlotMatrix.scatterPlotMatrix(variableNames, variables);
    }

    public static ScatterPlotMatrix scatterPlotMatrix(String[] variableNames, long[] ... variables) {
        IndexableNumericData[] data = (IndexableNumericData[])Arrays.stream(variables).map(x -> new IndexableNumericDataArrayLong((long[])x, null)).toArray(IndexableNumericData[]::new);
        return ScatterPlotMatrix.scatterPlotMatrix(variableNames, data);
    }

    public static ScatterPlotMatrix scatterPlotMatrix(float[] ... variables) {
        Require.neqNull((Object)variables, (String)"variables");
        String[] variableNames = (String[])IntStream.range(0, variables.length).mapToObj(i -> "x" + i).toArray(String[]::new);
        return ScatterPlotMatrix.scatterPlotMatrix(variableNames, variables);
    }

    public static ScatterPlotMatrix scatterPlotMatrix(String[] variableNames, float[] ... variables) {
        IndexableNumericData[] data = (IndexableNumericData[])Arrays.stream(variables).map(x -> new IndexableNumericDataArrayFloat((float[])x, null)).toArray(IndexableNumericData[]::new);
        return ScatterPlotMatrix.scatterPlotMatrix(variableNames, data);
    }

    public static ScatterPlotMatrix scatterPlotMatrix(double[] ... variables) {
        Require.neqNull((Object)variables, (String)"variables");
        String[] variableNames = (String[])IntStream.range(0, variables.length).mapToObj(i -> "x" + i).toArray(String[]::new);
        return ScatterPlotMatrix.scatterPlotMatrix(variableNames, variables);
    }

    public static ScatterPlotMatrix scatterPlotMatrix(String[] variableNames, double[] ... variables) {
        IndexableNumericData[] data = (IndexableNumericData[])Arrays.stream(variables).map(x -> new IndexableNumericDataArrayDouble((double[])x, null)).toArray(IndexableNumericData[]::new);
        return ScatterPlotMatrix.scatterPlotMatrix(variableNames, data);
    }

    private static ScatterPlotMatrix scatterPlotMatrix(String[] variableNames, IndexableNumericData[] columns) {
        Require.neqNull((Object)variableNames, (String)"variableNames");
        Require.neqNull((Object)columns, (String)"columns");
        Figure fig = FigureFactory.figure(columns.length, columns.length);
        Require.eqTrue((boolean)(fig instanceof FigureImpl), (String)"fig instanceof FigureImpl");
        ArgumentValidations.assertSameSize(columns, variableNames, ((FigureImpl)fig).getFigure().getPlotInfo());
        int subPlotNum = 0;
        for (int i = 0; i < columns.length; ++i) {
            for (int j = 0; j < columns.length; ++j) {
                fig = fig.newChart(subPlotNum).legendVisible(false);
                if (i == 0) {
                    fig = fig.chartTitle(variableNames[j]);
                }
                fig = fig.newAxes().plotStyle(PlotStyle.SCATTER);
                if (j == 0) {
                    fig = fig.yLabel(variableNames[i]);
                }
                fig = fig.plot((Comparable)((Object)("" + subPlotNum)), columns[i], columns[j], false, false);
                ++subPlotNum;
            }
        }
        return new ScatterPlotMatrix((FigureImpl)fig, columns.length);
    }

    public static ScatterPlotMatrix scatterPlotMatrix(Table t, String ... columns) {
        Require.neqNull((Object)t, (String)"table");
        Require.neqNull((Object)columns, (String)"columns");
        Figure fig = FigureFactory.figure(columns.length, columns.length);
        int subPlotNum = 0;
        for (int i = 0; i < columns.length; ++i) {
            for (int j = 0; j < columns.length; ++j) {
                fig = fig.newChart(subPlotNum).legendVisible(false);
                if (i == 0) {
                    fig = fig.chartTitle(columns[j]);
                }
                fig = fig.newAxes().plotStyle(PlotStyle.SCATTER);
                if (j == 0) {
                    fig = fig.yLabel(columns[i]);
                }
                fig = fig.plot((Comparable)((Object)("" + subPlotNum)), t, columns[i], columns[j]);
                ++subPlotNum;
            }
        }
        return new ScatterPlotMatrix((FigureImpl)fig, columns.length);
    }

    public static ScatterPlotMatrix scatterPlotMatrix(SelectableDataSet sds, String ... columns) {
        Require.neqNull((Object)sds, (String)"sds");
        Require.neqNull((Object)columns, (String)"columns");
        Figure fig = FigureFactory.figure(columns.length, columns.length);
        int subPlotNum = 0;
        for (int i = 0; i < columns.length; ++i) {
            for (int j = 0; j < columns.length; ++j) {
                fig = fig.newChart(subPlotNum).legendVisible(false);
                if (i == 0) {
                    fig = fig.chartTitle(columns[j]);
                }
                fig = fig.newAxes().plotStyle(PlotStyle.SCATTER);
                if (j == 0) {
                    fig = fig.yLabel(columns[i]);
                }
                fig = fig.plot((Comparable)((Object)("" + subPlotNum)), sds, columns[i], columns[j]);
                ++subPlotNum;
            }
        }
        return new ScatterPlotMatrix((FigureImpl)fig, columns.length);
    }
}

