/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.category;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.table.Table;
import io.deephaven.gui.color.Color;
import io.deephaven.gui.color.Paint;
import io.deephaven.gui.shape.NamedShape;
import io.deephaven.gui.shape.Shape;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.ChartImpl;
import io.deephaven.plot.LineStyle;
import io.deephaven.plot.datasets.AbstractDataSeries;
import io.deephaven.plot.datasets.category.CategoryDataSeries;
import io.deephaven.plot.datasets.category.CategoryDataSeriesInternal;
import io.deephaven.plot.datasets.data.AssociativeData;
import io.deephaven.plot.datasets.data.AssociativeDataHashMap;
import io.deephaven.plot.datasets.data.AssociativeDataSwappableTable;
import io.deephaven.plot.datasets.data.AssociativeDataTable;
import io.deephaven.plot.datasets.data.AssociativeDataWithDefault;
import io.deephaven.plot.errors.PlotIllegalArgumentException;
import io.deephaven.plot.errors.PlotIllegalStateException;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.errors.PlotRuntimeException;
import io.deephaven.plot.errors.PlotUnsupportedOperationException;
import io.deephaven.plot.filters.SelectableDataSet;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.PlotUtils;
import io.deephaven.plot.util.tables.ColumnHandlerFactory;
import io.deephaven.plot.util.tables.SwappableTable;
import io.deephaven.plot.util.tables.TableHandle;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Function;

public abstract class AbstractCategoryDataSeries
extends AbstractDataSeries
implements CategoryDataSeriesInternal {
    private static final long serialVersionUID = 6881532832713307316L;
    private final AssociativeDataWithDefault<Comparable, Paint> colors;
    private final AssociativeDataWithDefault<Comparable, String> labels;
    private final AssociativeDataWithDefault<Comparable, Double> sizes;
    private final AssociativeDataWithDefault<Comparable, Shape> shapes;
    private String piePercentLabelFormat = null;
    private int group = 1;

    public AbstractCategoryDataSeries(AxesImpl axes, int id, Comparable name) {
        this(axes, id, name, null);
    }

    public AbstractCategoryDataSeries(AxesImpl axes, int id, Comparable name, AbstractCategoryDataSeries series) {
        super(axes, id, name, series);
        this.colors = new AssociativeDataWithDefault(this.getPlotInfo());
        this.labels = new AssociativeDataWithDefault(this.getPlotInfo());
        this.sizes = new AssociativeDataWithDefault(this.getPlotInfo());
        this.shapes = new AssociativeDataWithDefault(this.getPlotInfo());
        if (series != null) {
            this.colors.set(series.colors);
            this.labels.set(series.labels);
            this.sizes.set(series.sizes);
            this.shapes.set(series.shapes);
            this.group = series.group;
            this.piePercentLabelFormat = series.piePercentLabelFormat;
        }
    }

    protected AbstractCategoryDataSeries(AbstractCategoryDataSeries series, AxesImpl axes) {
        super(series, axes);
        this.colors = new AssociativeDataWithDefault(series.getPlotInfo());
        this.labels = new AssociativeDataWithDefault(series.getPlotInfo());
        this.sizes = new AssociativeDataWithDefault(series.getPlotInfo());
        this.shapes = new AssociativeDataWithDefault(series.getPlotInfo());
        this.colors.set(series.colors);
        this.labels.set(series.labels);
        this.sizes.set(series.sizes);
        this.shapes.set(series.shapes);
        this.group = series.group;
        this.piePercentLabelFormat = series.piePercentLabelFormat;
    }

    protected void colorsSetSpecific(AssociativeData<Comparable, Paint> data) {
        this.colors.setSpecific(data);
    }

    protected void labelsSetSpecific(AssociativeData<Comparable, String> data) {
        this.labels.setSpecific(data);
    }

    protected void sizesSetSpecific(AssociativeData<Comparable, Double> data) {
        this.sizes.setSpecific(data);
    }

    protected void shapesSetSpecific(AssociativeData<Comparable, Shape> data) {
        this.shapes.setSpecific(data);
    }

    @Override
    public Paint getColor(Comparable category) {
        return this.colors.get(category);
    }

    @Override
    public Double getPointSize(Comparable category) {
        return PlotUtils.numberToDouble(this.sizes.get(category));
    }

    @Override
    public Paint getSeriesColor() {
        return this.colors.getDefault();
    }

    @Override
    public String getLabel(Comparable category) {
        return this.labels.get(category);
    }

    @Override
    public Shape getPointShape(Comparable category) {
        return this.shapes.get(category);
    }

    @Override
    public int getGroup() {
        return this.group;
    }

    @Override
    public String getPiePercentLabelFormat() {
        return this.piePercentLabelFormat;
    }

    @Override
    public AbstractCategoryDataSeries group(int group) {
        this.group = group;
        return this;
    }

    @Override
    public AbstractCategoryDataSeries linesVisible(Boolean visible) {
        this.setLinesVisible(visible);
        return this;
    }

    @Override
    public AbstractCategoryDataSeries pointsVisible(Boolean visible) {
        this.setPointsVisible(visible);
        return this;
    }

    @Override
    public AbstractCategoryDataSeries gradientVisible(boolean gradientVisible) {
        this.setGradientVisible(gradientVisible);
        return this;
    }

    @Override
    public AbstractCategoryDataSeries seriesColor(Paint color) {
        this.lineColor(color);
        this.pointColor(color);
        return this;
    }

    @Override
    public AbstractCategoryDataSeries seriesColor(int color) {
        this.lineColor(color);
        this.pointColor(color);
        return this;
    }

    @Override
    public AbstractCategoryDataSeries seriesColor(String color) {
        this.lineColor(color);
        this.pointColor(color);
        return this;
    }

    @Override
    public AbstractCategoryDataSeries lineColor(Paint color) {
        this.setLineColor(color);
        return this;
    }

    @Override
    public AbstractCategoryDataSeries lineColor(int color) {
        this.setLineColor(color);
        return this;
    }

    @Override
    public AbstractCategoryDataSeries lineColor(String color) {
        this.setLineColor(color);
        return this;
    }

    @Override
    public AbstractCategoryDataSeries errorBarColor(Paint errorBarColor) {
        this.setErrorBarColor(errorBarColor);
        return this;
    }

    @Override
    public AbstractCategoryDataSeries errorBarColor(int errorBarColor) {
        this.setErrorBarColor(errorBarColor);
        return this;
    }

    @Override
    public AbstractCategoryDataSeries errorBarColor(String errorBarColor) {
        this.setErrorBarColor(errorBarColor);
        return this;
    }

    @Override
    public AbstractCategoryDataSeries lineStyle(LineStyle lineStyle) {
        this.setLineStyle(lineStyle);
        return this;
    }

    @Override
    public AbstractCategoryDataSeries pointSize(int pointSize) {
        return this.pointSize(pointSize == Integer.MIN_VALUE ? null : Integer.valueOf(pointSize));
    }

    @Override
    public AbstractCategoryDataSeries pointSize(long pointSize) {
        return this.pointSize(pointSize == Long.MIN_VALUE ? null : Long.valueOf(pointSize));
    }

    @Override
    public AbstractCategoryDataSeries pointSize(double pointSize) {
        this.sizes.setDefault(pointSize == -1.7976931348623157E308 || pointSize == Double.NaN ? null : Double.valueOf(pointSize));
        return this;
    }

    @Override
    public AbstractCategoryDataSeries pointSize(Number pointSize) {
        this.sizes.setDefault(pointSize == null ? null : Double.valueOf(pointSize.doubleValue()));
        return this;
    }

    @Override
    public AbstractCategoryDataSeries pointSize(Comparable category, int pointSize) {
        if (!this.sizes.isModifiable()) {
            this.sizes.setSpecific(new AssociativeDataHashMap(this.getPlotInfo()));
        }
        this.sizes.put(category, Double.valueOf(pointSize));
        return this;
    }

    @Override
    public AbstractCategoryDataSeries pointSize(Comparable category, long pointSize) {
        if (!this.sizes.isModifiable()) {
            this.sizes.setSpecific(new AssociativeDataHashMap(this.getPlotInfo()));
        }
        this.sizes.put(category, Double.valueOf(pointSize));
        return this;
    }

    @Override
    public AbstractCategoryDataSeries pointSize(Comparable category, double pointSize) {
        if (!this.sizes.isModifiable()) {
            this.sizes.setSpecific(new AssociativeDataHashMap(this.getPlotInfo()));
        }
        this.sizes.put(category, pointSize);
        return this;
    }

    @Override
    public AbstractCategoryDataSeries pointSize(Comparable category, Number pointSize) {
        if (!this.sizes.isModifiable()) {
            this.sizes.setSpecific(new AssociativeDataHashMap(this.getPlotInfo()));
        }
        this.sizes.put(category, pointSize == null ? null : Double.valueOf(pointSize.doubleValue()));
        return this;
    }

    @Override
    public <CATEGORY extends Comparable> AbstractCategoryDataSeries pointSize(CATEGORY[] categories, int[] pointSizes) {
        return this.pointSize((Comparable[])categories, PlotUtils.toDouble(pointSizes));
    }

    @Override
    public <CATEGORY extends Comparable> AbstractCategoryDataSeries pointSize(CATEGORY[] categories, long[] pointSizes) {
        return this.pointSize((Comparable[])categories, PlotUtils.toDouble(pointSizes));
    }

    @Override
    public <CATEGORY extends Comparable, NUMBER extends Number> AbstractCategoryDataSeries pointSize(CATEGORY[] categories, NUMBER[] pointSizes) {
        return this.pointSize((Comparable[])categories, PlotUtils.toDouble(pointSizes));
    }

    @Override
    public <CATEGORY extends Comparable> AbstractCategoryDataSeries pointSize(CATEGORY[] categories, double[] pointSizes) {
        ArgumentValidations.assertNotNull(categories, "categories", this.getPlotInfo());
        ArgumentValidations.assertNotNull(pointSizes, "factors", this.getPlotInfo());
        Require.eq((int)categories.length, (String)"categories.length", (int)pointSizes.length, (String)"factors.length");
        if (!this.sizes.isModifiable()) {
            this.sizes.setSpecific(new AssociativeDataHashMap(this.getPlotInfo()));
        }
        for (int i = 0; i < categories.length; ++i) {
            this.sizes.put((Comparable)categories[i], pointSizes[i]);
        }
        return this;
    }

    @Override
    public <CATEGORY extends Comparable, NUMBER extends Number> AbstractCategoryDataSeries pointSize(Map<CATEGORY, NUMBER> pointSizes) {
        if (!this.sizes.isModifiable()) {
            this.sizes.setSpecific(new AssociativeDataHashMap(this.getPlotInfo()));
        }
        for (Map.Entry<CATEGORY, NUMBER> entry : pointSizes.entrySet()) {
            Comparable k = (Comparable)entry.getKey();
            Number v = (Number)entry.getValue();
            this.sizes.put(k, v == null ? null : Double.valueOf(v.doubleValue()));
        }
        return this;
    }

    @Override
    public AbstractCategoryDataSeries pointSize(Table t, String category, String pointSize) {
        ArgumentValidations.assertNotNull(t, "table", this.getPlotInfo());
        ArgumentValidations.assertNotNull(category, "keyColumn", this.getPlotInfo());
        ArgumentValidations.assertNotNull(pointSize, "valueColumn", this.getPlotInfo());
        TableHandle tableHandle = new TableHandle(t, category, pointSize);
        this.addTableHandle(tableHandle);
        ArgumentValidations.assertInstance(t, category, Comparable.class, "key column is not a supported type (Comparable): keyColumn=" + category, this.getPlotInfo());
        this.sizes.setSpecific((AssociativeData<Comparable, Double>)new AssociativeDataTable<Comparable, Double, Number>(tableHandle, category, pointSize, Comparable.class, Number.class, this.getPlotInfo()){

            @Override
            public Double convert(Number v) {
                return PlotUtils.numberToDouble(v);
            }
        });
        return this;
    }

    @Override
    public AbstractCategoryDataSeries pointSize(SelectableDataSet sds, String category, String pointSize) {
        ArgumentValidations.assertNotNull(sds, "sds", this.getPlotInfo());
        ArgumentValidations.assertNotNull(category, "keyColumn", this.getPlotInfo());
        ArgumentValidations.assertNotNull(pointSize, "valueColumn", this.getPlotInfo());
        Function tableTransform = (Function<Table, Table> & Serializable)table -> (Table)table.lastBy(new String[]{category});
        SwappableTable t = sds.getSwappableTable(this.name(), this.chart(), tableTransform, pointSize);
        this.addSwappableTable(t);
        ArgumentValidations.assertInstance(t.getTableDefinition(), category, Comparable.class, "key column is not a supported type (Comparable): keyColumn=" + category, this.getPlotInfo());
        this.sizes.setSpecific((AssociativeData<Comparable, Double>)new AssociativeDataSwappableTable<Comparable, Double, Number>(t, category, pointSize, Comparable.class, Number.class, this.getPlotInfo()){

            @Override
            public Double convert(Number v) {
                return PlotUtils.numberToDouble(v);
            }
        });
        return this;
    }

    @Override
    public AbstractCategoryDataSeries pointColor(Paint pointColor) {
        this.colors.setDefault(pointColor);
        return this;
    }

    @Override
    public AbstractCategoryDataSeries pointColor(int pointColor) {
        return this.pointColor(PlotUtils.intToColor(this.chart(), pointColor));
    }

    @Override
    public CategoryDataSeriesInternal pointColor(String pointColor) {
        return this.pointColor((Paint)Color.color((String)pointColor));
    }

    @Override
    public AbstractCategoryDataSeries pointColor(Comparable category, Paint color) {
        if (!this.colors.isModifiable()) {
            this.colors.setSpecific(new AssociativeDataHashMap(this.getPlotInfo()));
        }
        this.colors.put(category, color);
        return this;
    }

    @Override
    public AbstractCategoryDataSeries pointColor(Comparable category, int pointColor) {
        return this.pointColor(category, PlotUtils.intToColor(this.chart(), pointColor));
    }

    @Override
    public CategoryDataSeriesInternal pointColor(Comparable category, String pointColor) {
        return this.pointColor(category, (Paint)Color.color((String)pointColor));
    }

    @Override
    public <CATEGORY extends Comparable, COLOR extends Paint> AbstractCategoryDataSeries pointColor(Map<CATEGORY, COLOR> pointColor) {
        if (!this.colors.isModifiable()) {
            this.colors.setSpecific(new AssociativeDataHashMap(this.getPlotInfo()));
        }
        this.colors.putAll(pointColor);
        return this;
    }

    @Override
    public <CATEGORY extends Comparable, COLOR extends Integer> AbstractCategoryDataSeries pointColorInteger(Map<CATEGORY, COLOR> colors) {
        if (!this.colors.isModifiable()) {
            this.colors.setSpecific(new AssociativeDataHashMap(this.getPlotInfo()));
        }
        for (Map.Entry<CATEGORY, COLOR> c : colors.entrySet()) {
            this.colors.put((Comparable)c.getKey(), PlotUtils.intToColor(this.chart(), (Integer)c.getValue()));
        }
        return this;
    }

    @Override
    public AbstractCategoryDataSeries pointColor(Table t, String category, String pointColor) {
        ArgumentValidations.assertNotNull(t, "table", this.getPlotInfo());
        ArgumentValidations.assertNotNull(category, "keyColumn", this.getPlotInfo());
        ArgumentValidations.assertNotNull(pointColor, "valueColumn", this.getPlotInfo());
        ArgumentValidations.assertInstance(t, category, Comparable.class, "key column is not a supported type (Comparable): keyColumn=" + category, this.getPlotInfo());
        TableHandle tableHandle = new TableHandle(t, category, pointColor);
        this.addTableHandle(tableHandle);
        ColumnHandlerFactory.ColumnHandler valueColumnHandler = ColumnHandlerFactory.newNumericHandler(tableHandle, pointColor, this.getPlotInfo());
        if (valueColumnHandler.typeClassification().equals((Object)ColumnHandlerFactory.TypeClassification.INTEGER) && (valueColumnHandler.type() == Integer.TYPE || valueColumnHandler.type() == Integer.class)) {
            this.colors.setSpecific(new AssociativeDataTableComparablePaint(tableHandle, category, pointColor, this.chart(), this.getPlotInfo()));
        } else if (valueColumnHandler.typeClassification().equals((Object)ColumnHandlerFactory.TypeClassification.PAINT)) {
            this.colors.setSpecific(new AssociativeDataTable(tableHandle, category, pointColor, Comparable.class, Paint.class, this.getPlotInfo()));
        } else {
            throw new PlotUnsupportedOperationException("Column can not be converted into a color: column=" + pointColor + "\ttype=" + valueColumnHandler.type(), this);
        }
        return this;
    }

    @Override
    public AbstractCategoryDataSeries pointColor(SelectableDataSet sds, String category, String pointColor) {
        ArgumentValidations.assertNotNull(sds, "sds", this.getPlotInfo());
        ArgumentValidations.assertNotNull(category, "keyColumn", this.getPlotInfo());
        ArgumentValidations.assertNotNull(pointColor, "valueColumn", this.getPlotInfo());
        ArgumentValidations.assertInstance(sds, category, Comparable.class, "key column is not a supported type (Comparable): keyColumn=" + category, this.getPlotInfo());
        Class type = sds.getTableDefinition().getColumn(pointColor).getDataType();
        boolean isInt = type.equals(Integer.TYPE) || type.equals(Integer.class) || type.equals(Short.TYPE) || type.equals(Short.class);
        boolean isPaint = Paint.class.isAssignableFrom(type);
        if (!isInt && !isPaint) {
            throw new PlotUnsupportedOperationException("Column can not be converted into a color: column=" + pointColor + "\ttype=" + type, this);
        }
        Function tableTransform = (Function<Table, Table> & Serializable)table -> (Table)table.lastBy(new String[]{category});
        SwappableTable t = sds.getSwappableTable(this.name(), this.chart(), tableTransform, category, pointColor);
        this.addSwappableTable(t);
        if (isInt) {
            this.colors.setSpecific(new AssociativeDataSwappableTableComparablePaint(t, category, pointColor, this.chart(), this.getPlotInfo()));
        } else if (isPaint) {
            this.colors.setSpecific(new AssociativeDataSwappableTable(t, category, pointColor, Comparable.class, Paint.class, this.getPlotInfo()));
        } else {
            throw new PlotIllegalStateException("Should never reach here", this);
        }
        return this;
    }

    @Override
    public AbstractCategoryDataSeries pointLabel(Object pointLabel) {
        this.labels.setDefault(pointLabel == null ? null : pointLabel.toString());
        return this;
    }

    @Override
    public AbstractCategoryDataSeries pointLabel(Comparable category, Object pointLabel) {
        if (!this.labels.isModifiable()) {
            this.labels.setSpecific(new AssociativeDataHashMap(this.getPlotInfo()));
        }
        this.labels.put(category, pointLabel == null ? null : pointLabel.toString());
        return this;
    }

    @Override
    public <CATEGORY extends Comparable, LABEL> AbstractCategoryDataSeries pointLabel(Map<CATEGORY, LABEL> pointLabels) {
        if (!this.labels.isModifiable()) {
            this.labels.setSpecific(new AssociativeDataHashMap(this.getPlotInfo()));
        }
        for (Map.Entry<CATEGORY, LABEL> l : pointLabels.entrySet()) {
            this.labels.put((Comparable)l.getKey(), l.getValue() == null ? null : l.getValue().toString());
        }
        return this;
    }

    @Override
    public AbstractCategoryDataSeries pointLabel(Table t, String category, String pointLabel) {
        TableHandle tableHandle = new TableHandle(t, category, pointLabel);
        this.addTableHandle(tableHandle);
        ArgumentValidations.assertInstance(t, category, Comparable.class, "key column is not a supported type (Comparable): keyColumn=" + category, this.getPlotInfo());
        this.labels.setSpecific(new AssociativeDataTableLabel(tableHandle, category, pointLabel, this.getPlotInfo()));
        return this;
    }

    @Override
    public AbstractCategoryDataSeries pointLabelFormat(String pointLabelFormat) {
        this.setPointLabelFormat(pointLabelFormat);
        return this;
    }

    @Override
    public AbstractCategoryDataSeries piePercentLabelFormat(String pieLabelFormat) {
        this.setPiePercentLabelFormat(pieLabelFormat);
        return this;
    }

    @Override
    public AbstractCategoryDataSeries xToolTipPattern(String xToolTipPattern) {
        this.setXToolTipPattern(xToolTipPattern);
        return this;
    }

    @Override
    public AbstractCategoryDataSeries yToolTipPattern(String yToolTipPattern) {
        this.setYToolTipPattern(yToolTipPattern);
        return this;
    }

    @Override
    public AbstractCategoryDataSeries pointLabel(SelectableDataSet sds, String category, String pointLabel) {
        ArgumentValidations.assertColumnsInTable(sds, this.getPlotInfo(), category, pointLabel);
        ArgumentValidations.assertInstance(sds, category, Comparable.class, "key column is not a supported type (Comparable): keyColumn=" + category, this.getPlotInfo());
        Function tableTransform = (Function<Table, Table> & Serializable)table -> (Table)table.lastBy(new String[]{category});
        SwappableTable t = sds.getSwappableTable(this.name(), this.chart(), tableTransform, category, pointLabel);
        this.addSwappableTable(t);
        this.labels.setSpecific(new AssociativeDataSwappableTableLabel(t, category, pointLabel, this.getPlotInfo()));
        return this;
    }

    @Override
    public AbstractCategoryDataSeries pointShape(String pointShape) {
        return this.pointShape(NamedShape.getShape(pointShape));
    }

    @Override
    public AbstractCategoryDataSeries pointShape(Shape pointShape) {
        this.shapes.setDefault(pointShape);
        return this;
    }

    @Override
    public CategoryDataSeries pointShape(Comparable category, String pointShape) {
        return this.pointShape(category, NamedShape.getShape(pointShape));
    }

    @Override
    public CategoryDataSeries pointShape(Comparable category, Shape pointShape) {
        if (!this.shapes.isModifiable()) {
            this.shapes.setSpecific(new AssociativeDataHashMap(this.getPlotInfo()));
        }
        this.shapes.put(category, pointShape);
        return this;
    }

    @Override
    public <CATEGORY extends Comparable> CategoryDataSeries pointShape(Map<CATEGORY, String> pointShapes) {
        ArgumentValidations.assertNotNull(pointShapes, "shapes", this.getPlotInfo());
        if (!this.shapes.isModifiable()) {
            this.shapes.setSpecific(new AssociativeDataHashMap(this.getPlotInfo()));
        }
        for (Map.Entry<CATEGORY, String> l : pointShapes.entrySet()) {
            try {
                this.shapes.put((Comparable)l.getKey(), NamedShape.getShape(l.getValue()));
            }
            catch (IllegalArgumentException iae) {
                this.shapes.setSpecific(null);
                throw new PlotIllegalArgumentException("Not a valid shape: `" + l.getValue() + "` for category:" + l.getKey() + "; valid shapes: " + NamedShape.getShapesString(), this);
            }
        }
        return this;
    }

    @Override
    public CategoryDataSeries pointShape(Table t, String category, String pointShape) {
        ArgumentValidations.assertNotNull(t, "t", this.getPlotInfo());
        ArgumentValidations.assertNotNull(category, "keyColumn", this.getPlotInfo());
        ArgumentValidations.assertNotNull(pointShape, "valueColumn", this.getPlotInfo());
        ArgumentValidations.assertInstance(t, category, Comparable.class, "key column is not a supported type (Comparable): keyColumn=" + category, this.getPlotInfo());
        Class columnType = ArgumentValidations.getColumnType(t, pointShape, this.getPlotInfo());
        if (String.class.isAssignableFrom(columnType)) {
            TableHandle tableHandle = new TableHandle(t, category, pointShape);
            this.addTableHandle(tableHandle);
            this.shapes.setSpecific(new AssociativeDataTablePointShapeString(tableHandle, category, pointShape, this.getPlotInfo()));
        } else if (Shape.class.isAssignableFrom(columnType)) {
            TableHandle tableHandle = new TableHandle(t, category, pointShape);
            this.addTableHandle(tableHandle);
            this.shapes.setSpecific(new AssociativeDataTablePointShapeObj(tableHandle, category, pointShape, this.getPlotInfo()));
        } else {
            throw new PlotRuntimeException("column is not a supported type (String or Shape): columnName=" + pointShape, this);
        }
        return this;
    }

    @Override
    public CategoryDataSeries pointShape(SelectableDataSet sds, String category, String pointShape) {
        ArgumentValidations.assertNotNull(sds, "sds", this.getPlotInfo());
        ArgumentValidations.assertNotNull(category, "keyColumn", this.getPlotInfo());
        ArgumentValidations.assertNotNull(pointShape, "valueColumn", this.getPlotInfo());
        ArgumentValidations.assertColumnsInTable(sds, this.getPlotInfo(), category, pointShape);
        ArgumentValidations.assertInstance(sds, category, Comparable.class, "key column is not a supported type (Comparable): keyColumn=" + category, this.getPlotInfo());
        SwappableTable swappableTable = sds.getSwappableTable(this.name(), this.chart(), category, pointShape);
        Class columnType = ArgumentValidations.getColumnType(sds, pointShape, this.getPlotInfo());
        if (String.class.isAssignableFrom(columnType)) {
            this.addSwappableTable(swappableTable);
            this.shapes.setSpecific(new AssociativeDataSwappableTablePointShapeString(swappableTable, category, pointShape, this.getPlotInfo()));
        } else if (Shape.class.isAssignableFrom(columnType)) {
            this.addSwappableTable(swappableTable);
            this.shapes.setSpecific(new AssociativeDataSwappableTablePointShapeObj(swappableTable, category, pointShape, this.getPlotInfo()));
        } else {
            throw new PlotRuntimeException("column is not a supported type (String OR Shape): columnName=" + pointShape, this);
        }
        return this;
    }

    protected void setPiePercentLabelFormat(String format) {
        this.piePercentLabelFormat = format;
    }

    @Override
    public AbstractCategoryDataSeries toolTipPattern(String toolTipPattern) {
        this.xToolTipPattern(toolTipPattern);
        this.yToolTipPattern(toolTipPattern);
        return this;
    }

    private static class AssociativeDataSwappableTableLabel
    extends AssociativeDataSwappableTable<Comparable, String, Object> {
        private static final long serialVersionUID = -7266731699707547063L;

        AssociativeDataSwappableTableLabel(SwappableTable t, String keyColumn, String valueColumn, PlotInfo plotInfo) {
            super(t, keyColumn, valueColumn, Comparable.class, Object.class, plotInfo);
        }

        @Override
        public String convert(Object v) {
            return v == null ? null : v.toString();
        }
    }

    private static class AssociativeDataTableLabel
    extends AssociativeDataTable<Comparable, String, Object> {
        private static final long serialVersionUID = -2209957632708434850L;

        AssociativeDataTableLabel(TableHandle handle, String keyColumn, String valueColumn, PlotInfo plotInfo) {
            super(handle, keyColumn, valueColumn, Comparable.class, Object.class, plotInfo);
        }

        @Override
        public String convert(Object v) {
            return v == null ? null : v.toString();
        }
    }

    private static class AssociativeDataSwappableTableComparablePaint
    extends AssociativeDataSwappableTable<Comparable, Paint, Integer> {
        private static final long serialVersionUID = -644994476705986379L;
        private final ChartImpl chart;

        AssociativeDataSwappableTableComparablePaint(SwappableTable t, String keyColumn, String valueColumn, ChartImpl chart, PlotInfo plotInfo) {
            super(t, keyColumn, valueColumn, Comparable.class, Integer.class, plotInfo);
            this.chart = chart;
        }

        @Override
        public Paint convert(Integer v) {
            return PlotUtils.intToColor(this.chart, v);
        }
    }

    private static class AssociativeDataTableComparablePaint
    extends AssociativeDataTable<Comparable, Paint, Integer> {
        private static final long serialVersionUID = 2872945661540856625L;
        private final ChartImpl chart;

        AssociativeDataTableComparablePaint(TableHandle handle, String keyColumn, String valueColumn, ChartImpl chart, PlotInfo plotInfo) {
            super(handle, keyColumn, valueColumn, Comparable.class, Integer.class, plotInfo);
            this.chart = chart;
        }

        @Override
        public Paint convert(Integer v) {
            return PlotUtils.intToColor(this.chart, v);
        }
    }

    private static class AssociativeDataPaintByYMap<COLOR extends Paint>
    extends AssociativeData<Comparable, Paint>
    implements Serializable {
        private static final long serialVersionUID = 1040533194319869777L;
        private final Map<Double, COLOR> colors;
        private final AbstractCategoryDataSeries dataSeries;

        private AssociativeDataPaintByYMap(Map<Double, COLOR> colors, AbstractCategoryDataSeries dataSeries) {
            super(dataSeries.getPlotInfo());
            this.colors = colors;
            this.dataSeries = dataSeries;
        }

        @Override
        public Paint get(Comparable key) {
            return (Paint)this.colors.get(this.dataSeries.getValue(key).doubleValue());
        }

        @Override
        public boolean isModifiable() {
            return false;
        }

        @Override
        public void put(Comparable comparable, Paint paint) {
            throw new PlotUnsupportedOperationException("AssociativeDataPaintByY can not be modified", this);
        }

        @Override
        public <K extends Comparable, V extends Paint> void putAll(Map<K, V> values) {
            throw new PlotUnsupportedOperationException("AssociativeDataPaintByY can not be modified", this);
        }
    }

    private static class AssociativeDataSwappableTablePointShapeObj
    extends AssociativeDataSwappableTable<Comparable, Shape, Shape> {
        private static final long serialVersionUID = -682972849470492883L;

        AssociativeDataSwappableTablePointShapeObj(SwappableTable t, String keyColumn, String valueColumn, PlotInfo plotInfo) {
            super(t, keyColumn, valueColumn, Comparable.class, Shape.class, plotInfo);
        }

        @Override
        public Shape convert(Shape v) {
            return v;
        }
    }

    private static class AssociativeDataSwappableTablePointShapeString
    extends AssociativeDataSwappableTable<Comparable, Shape, String> {
        private static final long serialVersionUID = 120758160744582475L;

        AssociativeDataSwappableTablePointShapeString(SwappableTable t, String keyColumn, String valueColumn, PlotInfo plotInfo) {
            super(t, keyColumn, valueColumn, Comparable.class, String.class, plotInfo);
        }

        @Override
        public Shape convert(String v) {
            return NamedShape.getShape(v);
        }
    }

    private static class AssociativeDataTablePointShapeObj
    extends AssociativeDataTable<Comparable, Shape, Shape> {
        private static final long serialVersionUID = -2868764888409198544L;

        AssociativeDataTablePointShapeObj(TableHandle handle, String keyColumn, String valueColumn, PlotInfo plotInfo) {
            super(handle, keyColumn, valueColumn, Comparable.class, Shape.class, plotInfo);
        }

        @Override
        public Shape convert(Shape v) {
            return v;
        }
    }

    private static class AssociativeDataTablePointShapeString
    extends AssociativeDataTable<Comparable, Shape, String> {
        private static final long serialVersionUID = -782616004116345049L;

        AssociativeDataTablePointShapeString(TableHandle handle, String keyColumn, String valueColumn, PlotInfo plotInfo) {
            super(handle, keyColumn, valueColumn, Comparable.class, String.class, plotInfo);
        }

        @Override
        public Shape convert(String v) {
            return NamedShape.getShape(v);
        }
    }
}

