/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.category;

import io.deephaven.gui.color.Paint;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.datasets.category.AbstractCategoryDataSeries;
import io.deephaven.plot.datasets.category.CategoryDataSeries;
import io.deephaven.plot.util.ArgumentValidations;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public abstract class AbstractMapBasedCategoryDataSeries
extends AbstractCategoryDataSeries {
    public AbstractMapBasedCategoryDataSeries(AxesImpl axes, int id, Comparable name) {
        super(axes, id, name);
    }

    public AbstractMapBasedCategoryDataSeries(AxesImpl axes, int id, Comparable name, AbstractCategoryDataSeries series) {
        super(axes, id, name, series);
    }

    public AbstractMapBasedCategoryDataSeries(AbstractCategoryDataSeries series, AxesImpl axes) {
        super(series, axes);
    }

    @Override
    public CategoryDataSeries pointShape(Function<Comparable, String> pointShapes) {
        return super.pointShape(this.constructMapFromData(pointShapes));
    }

    @Override
    public <NUMBER extends Number> AbstractCategoryDataSeries pointSize(Function<Comparable, NUMBER> pointSizes) {
        return super.pointSize(this.constructMapFromData(pointSizes));
    }

    @Override
    public <COLOR extends Paint> AbstractCategoryDataSeries pointColor(Function<Comparable, COLOR> pointColor) {
        return super.pointColor(this.constructMapFromData(pointColor));
    }

    @Override
    public <COLOR extends Integer> AbstractCategoryDataSeries pointColorInteger(Function<Comparable, COLOR> colors) {
        return super.pointColorInteger(this.constructMapFromData(colors));
    }

    @Override
    public <LABEL> AbstractCategoryDataSeries pointLabel(Function<Comparable, LABEL> pointLabels) {
        return super.pointLabel(this.constructMapFromData(pointLabels));
    }

    private <T> Map<Double, T> constructMapFromNumericalData(Function<Double, T> function) {
        ArgumentValidations.assertNotNull(function, "function", this.getPlotInfo());
        HashMap<Double, T> map = new HashMap<Double, T>();
        for (Comparable category : this.categories()) {
            double value = this.getValue(category).doubleValue();
            map.put(value, function.apply(value));
        }
        return map;
    }

    private <T> Map<Comparable, T> constructMapFromData(Function<Comparable, T> function) {
        ArgumentValidations.assertNotNull(function, "function", this.getPlotInfo());
        HashMap<Comparable, T> map = new HashMap<Comparable, T>();
        for (Comparable category : this.categories()) {
            map.put(category, function.apply(category));
        }
        return map;
    }
}

