/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.category;

import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.context.QueryScope;
import io.deephaven.engine.table.Table;
import io.deephaven.gui.color.Paint;
import io.deephaven.gui.shape.NamedShape;
import io.deephaven.gui.shape.Shape;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.datasets.category.AbstractCategoryDataSeries;
import io.deephaven.plot.datasets.category.CategoryDataSeries;
import io.deephaven.plot.datasets.data.AssociativeData;
import io.deephaven.plot.datasets.data.AssociativeDataSwappableTable;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.PlotUtils;
import io.deephaven.plot.util.functions.FigureImplFunction;
import io.deephaven.plot.util.tables.SwappableTable;
import java.util.Objects;
import java.util.function.Function;

public abstract class AbstractSwappableTableBasedCategoryDataSeries
extends AbstractCategoryDataSeries {
    public AbstractSwappableTableBasedCategoryDataSeries(AxesImpl axes, int id, Comparable name) {
        super(axes, id, name);
    }

    public AbstractSwappableTableBasedCategoryDataSeries(AxesImpl axes, int id, Comparable name, AbstractCategoryDataSeries series) {
        super(axes, id, name, series);
    }

    public AbstractSwappableTableBasedCategoryDataSeries(AbstractCategoryDataSeries series, AxesImpl axes) {
        super(series, axes);
    }

    @Override
    public CategoryDataSeries pointShape(Function<Comparable, String> pointShapes) {
        String colName = "__POINT_SHAPE" + this.hashCode();
        this.chart().figure().registerPartitionedTableFunction(this.getSwappableTable().getPartitionedTableHandle(), this.constructPartitionedTableFromFunctionOnCategoryCol(pointShapes, String.class, colName));
        this.getSwappableTable().getPartitionedTableHandle().addColumn(colName);
        this.chart().figure().registerFigureFunction(new FigureImplFunction(figImpl -> {
            ((AbstractSwappableTableBasedCategoryDataSeries)figImpl.getFigure().getCharts().getChart(this.chart().row(), this.chart().column()).axes(this.axes().id()).series(this.id())).shapesSetSpecific((AssociativeData<Comparable, Shape>)new AssociativeDataSwappableTable<Comparable, Shape, String>(this.getSwappableTable(), this.getCategoryCol(), colName, Comparable.class, String.class, this.getPlotInfo()){

                @Override
                public Shape convert(String v) {
                    return NamedShape.getShape(v);
                }
            });
            return figImpl;
        }, this));
        return this;
    }

    @Override
    public <NUMBER extends Number> CategoryDataSeries pointSize(Function<Comparable, NUMBER> pointSizes) {
        String colName = "__POINT_SIZE" + this.hashCode();
        this.chart().figure().registerPartitionedTableFunction(this.getSwappableTable().getPartitionedTableHandle(), this.constructPartitionedTableFromFunctionOnCategoryCol(pointSizes, Number.class, colName));
        this.getSwappableTable().getPartitionedTableHandle().addColumn(colName);
        this.chart().figure().registerFigureFunction(new FigureImplFunction(figImpl -> {
            ((AbstractSwappableTableBasedCategoryDataSeries)figImpl.getFigure().getCharts().getChart(this.chart().row(), this.chart().column()).axes(this.axes().id()).series(this.id())).sizesSetSpecific(new AssociativeDataSwappableTable(this.getSwappableTable(), this.getCategoryCol(), colName, Comparable.class, Number.class, this.getPlotInfo()));
            return figImpl;
        }, this));
        return this;
    }

    @Override
    public <COLOR extends Paint> CategoryDataSeries pointColor(Function<Comparable, COLOR> pointColor) {
        String colName = "__POINT_COLOR" + this.hashCode();
        this.chart().figure().registerPartitionedTableFunction(this.getSwappableTable().getPartitionedTableHandle(), this.constructPartitionedTableFromFunctionOnCategoryCol(pointColor, Paint.class, colName));
        this.getSwappableTable().getPartitionedTableHandle().addColumn(colName);
        this.chart().figure().registerFigureFunction(new FigureImplFunction(figImpl -> {
            ((AbstractSwappableTableBasedCategoryDataSeries)figImpl.getFigure().getCharts().getChart(this.chart().row(), this.chart().column()).axes(this.axes().id()).series(this.id())).colorsSetSpecific(new AssociativeDataSwappableTable(this.getSwappableTable(), this.getCategoryCol(), colName, Comparable.class, Paint.class, this.getPlotInfo()));
            return figImpl;
        }, this));
        return this;
    }

    @Override
    public <COLOR extends Integer> CategoryDataSeries pointColorInteger(Function<Comparable, COLOR> colors) {
        String colName = "__POINT_COLOR" + this.hashCode();
        this.chart().figure().registerPartitionedTableFunction(this.getSwappableTable().getPartitionedTableHandle(), this.constructPartitionedTableFromFunctionOnCategoryCol(colors, Integer.class, colName));
        this.getSwappableTable().getPartitionedTableHandle().addColumn(colName);
        this.chart().figure().registerFigureFunction(new FigureImplFunction(figImpl -> {
            ((AbstractSwappableTableBasedCategoryDataSeries)figImpl.getFigure().getCharts().getChart(this.chart().row(), this.chart().column()).axes(this.axes().id()).series(this.id())).colorsSetSpecific((AssociativeData<Comparable, Paint>)new AssociativeDataSwappableTable<Comparable, Paint, Integer>(this.getSwappableTable(), this.getCategoryCol(), colName, Comparable.class, Integer.class, this.getPlotInfo()){

                @Override
                public Paint convert(Integer v) {
                    return PlotUtils.intToColor(AbstractSwappableTableBasedCategoryDataSeries.this.chart(), v);
                }
            });
            return figImpl;
        }, this));
        return this;
    }

    @Override
    public <LABEL> CategoryDataSeries pointLabel(Function<Comparable, LABEL> pointLabels) {
        String colName = "__POINT_LABEL" + this.hashCode();
        this.chart().figure().registerPartitionedTableFunction(this.getSwappableTable().getPartitionedTableHandle(), this.constructPartitionedTableFromFunctionOnCategoryCol(pointLabels, Object.class, colName));
        this.getSwappableTable().getPartitionedTableHandle().addColumn(colName);
        this.chart().figure().registerFigureFunction(new FigureImplFunction(figImpl -> {
            ((AbstractSwappableTableBasedCategoryDataSeries)figImpl.getFigure().getCharts().getChart(this.chart().row(), this.chart().column()).axes(this.axes().id()).series(this.id())).labelsSetSpecific((AssociativeData<Comparable, String>)new AssociativeDataSwappableTable<Comparable, String, Object>(this.getSwappableTable(), this.getCategoryCol(), colName, Comparable.class, Object.class, this.getPlotInfo()){

                @Override
                public String convert(Object o) {
                    return Objects.toString(o);
                }
            });
            return figImpl;
        }, this));
        return this;
    }

    private <S, T> Function<Table, Table> constructPartitionedTableFromFunctionOnCategoryCol(Function<S, T> function, Class resultClass, String columnName) {
        return this.constructPartitionedTableFromFunction(function, resultClass, this.getCategoryCol(), columnName);
    }

    protected <S, T> Function<Table, Table> constructPartitionedTableFromFunction(Function<S, T> function, Class resultClass, String onColumn, String columnName) {
        ArgumentValidations.assertNotNull(function, "function", this.getPlotInfo());
        String queryFunction = columnName + "Function";
        return t -> {
            QueryScope.addParam((String)queryFunction, (Object)function);
            ExecutionContext.getContext().getQueryLibrary().importClass(resultClass);
            return (Table)t.update(new String[]{columnName + " = (" + resultClass.getSimpleName() + ") " + queryFunction + ".apply(" + onColumn + ")"});
        };
    }

    protected abstract SwappableTable getSwappableTable();

    protected abstract String getCategoryCol();

    protected abstract String getNumericCol();
}

