/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.category;

import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.datasets.category.AbstractCategoryDataSeries;
import io.deephaven.plot.datasets.category.AbstractMapBasedCategoryDataSeries;
import io.deephaven.plot.datasets.data.IndexableData;
import io.deephaven.plot.datasets.data.IndexableNumericData;
import io.deephaven.plot.errors.PlotIllegalArgumentException;
import io.deephaven.plot.errors.PlotUnsupportedOperationException;
import io.deephaven.plot.util.NullCategory;
import io.deephaven.plot.util.PlotUtils;
import io.deephaven.tuple.generated.ObjectIntTuple;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class CategoryDataSeriesMap
extends AbstractMapBasedCategoryDataSeries {
    private static final long serialVersionUID = 3326261675883932559L;
    private final Map<Comparable, ObjectIntTuple> data = new LinkedHashMap<Comparable, ObjectIntTuple>();
    private double yMin;
    private double yMax;

    public <T extends Comparable<?>> CategoryDataSeriesMap(AxesImpl axes, int id, Comparable<?> name, IndexableData<T> categories, IndexableNumericData values) {
        this(axes, id, name, categories, values, null);
    }

    public <T extends Comparable<?>> CategoryDataSeriesMap(AxesImpl axes, int id, Comparable<?> name, IndexableData<T> categories, IndexableNumericData values, AbstractCategoryDataSeries series) {
        super(axes, id, name, series);
        if (categories == null || values == null) {
            throw new PlotIllegalArgumentException("Null input array", this);
        }
        if (categories.size() != values.size()) {
            throw new PlotIllegalArgumentException("Categories and Values lengths do not match", this);
        }
        for (int i = 0; i < categories.size(); ++i) {
            Comparable category = (Comparable)categories.get(i);
            Comparable comparable = category = category == null ? NullCategory.INSTANCE : category;
            if (this.data.containsKey(category)) {
                throw new PlotUnsupportedOperationException("Category value repeated multiple times in dataset: series=" + name + "category=" + categories.get(i), this);
            }
            double value = values.get(i);
            this.setValue(category, value, i);
            this.yMin = PlotUtils.minIgnoreNaN(this.yMin, value);
            this.yMax = PlotUtils.maxIgnoreNaN(this.yMax, value);
        }
    }

    private CategoryDataSeriesMap(CategoryDataSeriesMap series, AxesImpl axes) {
        super(series, axes);
        this.data.putAll(series.data);
        this.yMin = series.yMin;
        this.yMax = series.yMax;
    }

    @Override
    public CategoryDataSeriesMap copy(AxesImpl axes) {
        return new CategoryDataSeriesMap(this, axes);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Collection<Comparable> categories() {
        return this.data.keySet();
    }

    @Override
    public Number getValue(Comparable category) {
        ObjectIntTuple catItem = this.data.get(category == null ? NullCategory.INSTANCE : category);
        return catItem == null ? (Number)null : (Number)((Number)catItem.getFirstElement());
    }

    private void setValue(Comparable<?> category, Number value, int index) {
        if (value == null) {
            this.data.remove(category);
        } else {
            this.data.put(category, new ObjectIntTuple((Object)value, index));
        }
    }

    @Override
    public long getCategoryLocation(Comparable category) {
        ObjectIntTuple catItem = this.data.get(category == null ? NullCategory.INSTANCE : category);
        return catItem == null ? -1L : (long)catItem.getSecondElement();
    }
}

