/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.category;

import io.deephaven.engine.table.Table;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.TableSnapshotSeries;
import io.deephaven.plot.datasets.category.AbstractTableBasedCategoryDataSeries;
import io.deephaven.plot.datasets.category.CategoryDataSeriesKernel;
import io.deephaven.plot.datasets.category.CategoryTableDataSeriesInternal;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.TableHandle;
import java.util.Collection;

public class CategoryDataSeriesPartitionedTable
extends AbstractTableBasedCategoryDataSeries
implements CategoryTableDataSeriesInternal,
TableSnapshotSeries {
    private static final long serialVersionUID = 2L;
    private final TableHandle tableHandle;
    private transient boolean isInit = false;
    private final String categoryCol;
    private final String valueCol;
    private transient CategoryDataSeriesKernel kernel;

    public <T extends Comparable> CategoryDataSeriesPartitionedTable(AxesImpl axes, int id, Comparable<?> name, TableHandle tableHandle, String categories, String values) {
        super(axes, id, name);
        ArgumentValidations.assertNotNull(axes, "axes", this.getPlotInfo());
        ArgumentValidations.assertNotNull(tableHandle, "table", this.getPlotInfo());
        ArgumentValidations.assertIsNumericOrTimeOrCharOrComparableInstance(tableHandle.getFinalTableDefinition(), categories, "Invalid data type in category column: column=" + categories, this.getPlotInfo());
        ArgumentValidations.assertIsNumericOrTime(tableHandle.getFinalTableDefinition(), values, "Invalid data type in data column: column=" + values, this.getPlotInfo());
        this.tableHandle = tableHandle;
        this.categoryCol = categories;
        this.valueCol = values;
        this.kernel = new CategoryDataSeriesKernel(this.categoryCol, values, this.getPlotInfo());
    }

    private CategoryDataSeriesPartitionedTable(CategoryDataSeriesPartitionedTable series, AxesImpl axes) {
        super(series, axes);
        this.tableHandle = series.tableHandle;
        this.categoryCol = series.categoryCol;
        this.valueCol = series.valueCol;
        this.kernel = new CategoryDataSeriesKernel(this.categoryCol, this.valueCol, this.getPlotInfo());
    }

    @Override
    public CategoryDataSeriesPartitionedTable copy(AxesImpl axes) {
        return new CategoryDataSeriesPartitionedTable(this, axes);
    }

    @Override
    public int size() {
        return this.kernel.size();
    }

    @Override
    public Collection<Comparable> categories() {
        return this.kernel.categories();
    }

    @Override
    public Number getValue(Comparable category) {
        return this.kernel.getValue(category);
    }

    @Override
    public long getCategoryLocation(Comparable category) {
        return this.kernel.getCategoryKey(category);
    }

    public TableHandle getTableHandle() {
        return this.tableHandle;
    }

    @Override
    public String getCategoryCol() {
        return this.categoryCol;
    }

    @Override
    public String getValueCol() {
        return this.valueCol;
    }

    @Override
    protected Table getTable() {
        return this.tableHandle.getTable();
    }
}

