/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.category;

import io.deephaven.engine.table.Table;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.TableSnapshotSeries;
import io.deephaven.plot.datasets.category.AbstractSwappableTableBasedCategoryDataSeries;
import io.deephaven.plot.datasets.category.CategoryDataSeriesKernel;
import io.deephaven.plot.datasets.category.CategorySwappableTableDataSeriesInternal;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.SwappableTable;
import java.util.Collection;

public class CategoryDataSeriesSwappablePartitionedTable
extends AbstractSwappableTableBasedCategoryDataSeries
implements CategorySwappableTableDataSeriesInternal,
TableSnapshotSeries {
    private static final long serialVersionUID = 2L;
    private transient Table localTable;
    private final SwappableTable swappableTable;
    private final String categoryCol;
    private final String valueCol;
    private transient CategoryDataSeriesKernel kernel;

    public <T extends Comparable> CategoryDataSeriesSwappablePartitionedTable(AxesImpl axes, int id, Comparable<?> name, SwappableTable swappableTable, String categories, String values) {
        super(axes, id, name);
        ArgumentValidations.assertNotNull(axes, "axes", this.getPlotInfo());
        ArgumentValidations.assertNotNull(swappableTable, "swappableTable", this.getPlotInfo());
        ArgumentValidations.assertInstance(swappableTable.getTableDefinition(), categories, Comparable.class, "Invalid data type in category column: column=" + categories, this.getPlotInfo());
        ArgumentValidations.assertIsNumericOrTime(swappableTable.getTableDefinition(), values, "Invalid data type in data column: column=" + values, this.getPlotInfo());
        this.swappableTable = swappableTable;
        this.categoryCol = categories;
        this.valueCol = values;
        this.kernel = new CategoryDataSeriesKernel(this.categoryCol, values, this.getPlotInfo());
    }

    private CategoryDataSeriesSwappablePartitionedTable(CategoryDataSeriesSwappablePartitionedTable series, AxesImpl axes) {
        super(series, axes);
        this.swappableTable = series.swappableTable;
        this.categoryCol = series.categoryCol;
        this.valueCol = series.valueCol;
        this.kernel = new CategoryDataSeriesKernel(this.categoryCol, this.valueCol, this.getPlotInfo());
    }

    @Override
    public CategoryDataSeriesSwappablePartitionedTable copy(AxesImpl axes) {
        return new CategoryDataSeriesSwappablePartitionedTable(this, axes);
    }

    @Override
    public int size() {
        return this.kernel.size();
    }

    @Override
    public Collection<Comparable> categories() {
        return this.kernel.categories();
    }

    @Override
    public Number getValue(Comparable category) {
        return this.kernel.getValue(category);
    }

    @Override
    public long getCategoryLocation(Comparable category) {
        return this.kernel.getCategoryKey(category);
    }

    @Override
    public String getCategoryCol() {
        return this.categoryCol;
    }

    @Override
    public String getNumericCol() {
        return this.valueCol;
    }

    @Override
    public SwappableTable getSwappableTable() {
        return this.swappableTable;
    }
}

