/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.categoryerrorbar;

import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.datasets.category.AbstractCategoryDataSeries;
import io.deephaven.plot.datasets.category.AbstractMapBasedCategoryDataSeries;
import io.deephaven.plot.datasets.categoryerrorbar.CategoryErrorBarDataSeriesInternal;
import io.deephaven.plot.datasets.data.IndexableData;
import io.deephaven.plot.datasets.data.IndexableNumericData;
import io.deephaven.plot.errors.PlotIllegalArgumentException;
import io.deephaven.plot.errors.PlotUnsupportedOperationException;
import io.deephaven.plot.util.NullCategory;
import io.deephaven.plot.util.PlotUtils;
import io.deephaven.tuple.generated.ObjectIntTuple;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class CategoryErrorBarDataSeriesMap
extends AbstractMapBasedCategoryDataSeries
implements CategoryErrorBarDataSeriesInternal {
    private static final long serialVersionUID = 3326261675883932559L;
    private final Map<Comparable, ObjectIntTuple> data = new LinkedHashMap<Comparable, ObjectIntTuple>();
    private final Map<Comparable, Number> dataToYStart = new LinkedHashMap<Comparable, Number>();
    private final Map<Comparable, Number> dataToYEnd = new LinkedHashMap<Comparable, Number>();
    private double yMin = Double.NaN;
    private double yMax = Double.NaN;

    public <T extends Comparable> CategoryErrorBarDataSeriesMap(AxesImpl axes, int id, Comparable name, IndexableData<T> categories, IndexableNumericData y, IndexableNumericData yLow, IndexableNumericData yHigh) {
        this(axes, id, name, categories, y, yLow, yHigh, null);
    }

    public <T extends Comparable> CategoryErrorBarDataSeriesMap(AxesImpl axes, int id, Comparable name, IndexableData<T> categories, IndexableNumericData y, IndexableNumericData yLow, IndexableNumericData yHigh, AbstractCategoryDataSeries series) {
        super(axes, id, name, series);
        if (categories == null || y == null || yLow == null || yHigh == null) {
            throw new PlotIllegalArgumentException("Null input array", this);
        }
        if (categories.size() != y.size() || y.size() != yLow.size() || yLow.size() != yHigh.size()) {
            throw new PlotIllegalArgumentException("Categories and values lengths do not match", this);
        }
        for (int i = 0; i < categories.size(); ++i) {
            Comparable category = (Comparable)categories.get(i);
            Comparable comparable = category = category == null ? NullCategory.INSTANCE : category;
            if (this.data.containsKey(category)) {
                throw new PlotUnsupportedOperationException("Category value repeated multiple times in dataset: series=" + name + "category=" + categories.get(i), this);
            }
            this.setValueIndexed(category, y.get(i), this.data, i);
            this.setValue(category, yLow.get(i), this.dataToYStart);
            this.setValue(category, yHigh.get(i), this.dataToYEnd);
        }
    }

    private CategoryErrorBarDataSeriesMap(CategoryErrorBarDataSeriesMap series, AxesImpl axes) {
        super(series, axes);
        this.data.putAll(series.data);
        this.dataToYStart.putAll(series.dataToYStart);
        this.dataToYEnd.putAll(series.dataToYEnd);
        this.yMin = series.yMin;
        this.yMax = series.yMax;
    }

    @Override
    public CategoryErrorBarDataSeriesMap copy(AxesImpl axes) {
        return new CategoryErrorBarDataSeriesMap(this, axes);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Collection<Comparable> categories() {
        return this.data.keySet();
    }

    @Override
    public Number getValue(Comparable category) {
        ObjectIntTuple catItem = this.data.get(category == null ? NullCategory.INSTANCE : category);
        return catItem == null ? (Number)null : (Number)((Number)catItem.getFirstElement());
    }

    @Override
    public long getCategoryLocation(Comparable category) {
        ObjectIntTuple catItem = this.data.get(category == null ? NullCategory.INSTANCE : category);
        return catItem == null ? -1L : (long)catItem.getSecondElement();
    }

    @Override
    public Number getStartY(Comparable category) {
        return this.dataToYStart.get(category);
    }

    @Override
    public Number getEndY(Comparable category) {
        return this.dataToYEnd.get(category);
    }

    private void setValueIndexed(Comparable category, Number value, Map<Comparable, ObjectIntTuple> data, int index) {
        if (value == null) {
            data.remove(category);
        } else {
            data.put(category, new ObjectIntTuple((Object)value, index));
        }
        this.yMin = PlotUtils.minIgnoreNaN(this.yMin, value == null ? Double.NaN : value.doubleValue());
        this.yMax = PlotUtils.maxIgnoreNaN(this.yMax, value == null ? Double.NaN : value.doubleValue());
    }

    private void setValue(Comparable category, Number value, Map<Comparable, Number> data) {
        if (value == null) {
            data.remove(category);
        } else {
            data.put(category, value);
        }
        this.yMin = PlotUtils.minIgnoreNaN(this.yMin, value == null ? Double.NaN : value.doubleValue());
        this.yMax = PlotUtils.maxIgnoreNaN(this.yMax, value == null ? Double.NaN : value.doubleValue());
    }
}

