/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.data;

import io.deephaven.plot.datasets.data.LiveAssociativeData;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.errors.PlotUnsupportedOperationException;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.SwappableTable;
import java.util.HashMap;
import java.util.Map;

public class AssociativeDataSwappableTable<KEY, VALUE, VALUECOLUMN>
extends LiveAssociativeData<KEY, VALUE, VALUECOLUMN> {
    private static final long serialVersionUID = -8997550925581334311L;
    private final SwappableTable swappableTable;
    private final String keyColumn;
    private final String valueColumn;
    private final Map<KEY, VALUE> data = new HashMap<KEY, VALUE>();

    public AssociativeDataSwappableTable(SwappableTable swappableTable, String keyColumn, String valueColumn, Class<KEY> keyColumnType, Class<VALUECOLUMN> valueColumnType, PlotInfo plotInfo) {
        super(plotInfo);
        this.swappableTable = swappableTable;
        ArgumentValidations.assertNotNull(swappableTable, "swappableTable", this.getPlotInfo());
        ArgumentValidations.assertNotNull(keyColumn, "keyColumn", this.getPlotInfo());
        ArgumentValidations.assertNotNull(valueColumn, "valueColumn", this.getPlotInfo());
        ArgumentValidations.assertColumnsInTable(swappableTable.getTableDefinition(), plotInfo, keyColumn, valueColumn);
        ArgumentValidations.assertInstance(swappableTable.getTableDefinition(), keyColumn, keyColumnType, keyColumn + " is not of type " + keyColumnType, plotInfo);
        ArgumentValidations.assertInstance(swappableTable.getTableDefinition(), valueColumn, valueColumnType, valueColumn + " is not of type " + valueColumnType, plotInfo);
        this.keyColumn = keyColumn;
        this.valueColumn = valueColumn;
    }

    @Override
    public VALUE get(KEY key) {
        return this.data.get(key);
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    @Override
    public void put(KEY key, VALUE value) {
        throw new PlotUnsupportedOperationException("Modifying values is not supported for AssociativeDataSwappableTable", this.getPlotInfo());
    }

    @Override
    public <K extends KEY, V extends VALUE> void putAll(Map<K, V> values) {
        throw new PlotUnsupportedOperationException("Modifying values is not supported for AssociativeDataSwappableTable", this.getPlotInfo());
    }
}

