/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.data;

import io.deephaven.plot.datasets.data.LiveAssociativeData;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.errors.PlotUnsupportedOperationException;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.PlotUtils;
import io.deephaven.plot.util.tables.TableHandle;
import java.util.HashMap;
import java.util.Map;

public class AssociativeDataTable<KEY, VALUE, VALUECOLUMN>
extends LiveAssociativeData<KEY, VALUE, VALUECOLUMN> {
    private static final long serialVersionUID = -1752085070371782144L;
    private final TableHandle tableHandle;
    private final String keyColumn;
    private final String valueColumn;
    private final Map<KEY, VALUE> data = new HashMap<KEY, VALUE>();

    public AssociativeDataTable(TableHandle tableHandle, String keyColumn, String valueColumn, Class<KEY> keyColumnType, Class<VALUECOLUMN> valueColumnType, PlotInfo plotInfo) {
        super(plotInfo);
        ArgumentValidations.assertNotNull(tableHandle, "tableHandle", this.getPlotInfo());
        ArgumentValidations.assertNotNull(keyColumn, "keyColumn", this.getPlotInfo());
        ArgumentValidations.assertNotNull(valueColumn, "valueColumn", this.getPlotInfo());
        ArgumentValidations.assertColumnsInTable(tableHandle, plotInfo, keyColumn, valueColumn);
        ArgumentValidations.assertInstance(tableHandle.getTable(), keyColumn, keyColumnType, keyColumn + " is not of type " + keyColumnType, plotInfo);
        ArgumentValidations.assertInstance(tableHandle.getTable(), valueColumn, valueColumnType, valueColumn + " is not of type " + valueColumnType, plotInfo);
        this.tableHandle = tableHandle;
        tableHandle.setTable(PlotUtils.createCategoryTable(tableHandle.getTable(), new String[]{keyColumn}));
        this.keyColumn = keyColumn;
        this.valueColumn = valueColumn;
    }

    @Override
    public VALUE get(KEY key) {
        return this.data.get(key);
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    @Override
    public void put(KEY key, VALUE value) {
        throw new PlotUnsupportedOperationException("Modifying values is not supported for AssociativeDataTable", this.getPlotInfo());
    }

    @Override
    public <K extends KEY, V extends VALUE> void putAll(Map<K, V> values) {
        throw new PlotUnsupportedOperationException("Modifying values is not supported for AssociativeDataTable", this.getPlotInfo());
    }
}

