/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.data;

import io.deephaven.plot.datasets.data.AssociativeData;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.errors.PlotRuntimeException;
import java.util.Map;

public class AssociativeDataWithDefault<KEY, VALUE>
extends AssociativeData<KEY, VALUE> {
    private static final long serialVersionUID = -1576513511939546265L;
    private VALUE defaultValue;
    private AssociativeData<KEY, VALUE> specificValues;

    public AssociativeDataWithDefault(PlotInfo plotInfo) {
        super(plotInfo);
    }

    public VALUE getDefault() {
        return this.defaultValue;
    }

    public void setDefault(VALUE value) {
        this.defaultValue = value;
    }

    public AssociativeData<KEY, VALUE> getSpecific() {
        return this.specificValues;
    }

    public void setSpecific(AssociativeData<KEY, VALUE> provider) {
        this.specificValues = provider;
    }

    @Override
    public VALUE get(KEY key) {
        if (this.specificValues == null) {
            return this.defaultValue;
        }
        VALUE v = this.specificValues.get(key);
        return v == null ? this.defaultValue : v;
    }

    @Override
    public boolean isModifiable() {
        return this.specificValues != null && this.specificValues.isModifiable();
    }

    @Override
    public void put(KEY key, VALUE value) {
        if (!this.isModifiable()) {
            throw new PlotRuntimeException("AssociativeDataWithDefault is unmodifiable", this.getPlotInfo());
        }
        this.specificValues.put(key, value);
    }

    @Override
    public <K extends KEY, V extends VALUE> void putAll(Map<K, V> values) {
        if (!this.isModifiable()) {
            throw new PlotRuntimeException("AssociativeDataWithDefault is unmodifiable", this.getPlotInfo());
        }
        this.specificValues.putAll(values);
    }

    public void set(AssociativeDataWithDefault<KEY, VALUE> data) {
        this.defaultValue = data.defaultValue;
        this.specificValues = data.specificValues;
    }
}

