/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.data;

import gnu.trove.map.hash.TLongObjectHashMap;
import io.deephaven.plot.datasets.data.IndexableData;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.time.DateTime;

public class IndexableDataDateTime
extends IndexableData<DateTime> {
    private static final long serialVersionUID = 8122162323328323447L;
    private final long[] data;
    private final TLongObjectHashMap<DateTime> dateTimeMap = new TLongObjectHashMap();

    public IndexableDataDateTime(long[] data, PlotInfo plotInfo) {
        super(plotInfo);
        ArgumentValidations.assertNotNull(data, "data", this.getPlotInfo());
        this.data = data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public DateTime get(int index) {
        long dataValue = this.data[index];
        if (dataValue == Long.MIN_VALUE) {
            return null;
        }
        DateTime cachedVal = (DateTime)this.dateTimeMap.get(dataValue);
        if (cachedVal == null) {
            cachedVal = new DateTime(dataValue);
            this.dateTimeMap.put(dataValue, (Object)cachedVal);
        }
        return cachedVal;
    }
}

