/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.data;

import io.deephaven.plot.datasets.data.IndexableData;
import io.deephaven.plot.datasets.data.IndexableNumericData;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayDouble;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayFloat;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayInt;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayLong;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayNumber;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayShort;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;

public class IndexableDataDouble
extends IndexableData<Double> {
    private static final long serialVersionUID = -7776388251959380558L;
    private final IndexableNumericData data;
    private final boolean mapNanToNull;

    public IndexableDataDouble(IndexableNumericData data, boolean mapNanToNull, PlotInfo plotInfo) {
        super(plotInfo);
        ArgumentValidations.assertNotNull(data, "data", this.getPlotInfo());
        this.data = data;
        this.mapNanToNull = mapNanToNull;
    }

    public <T extends Number> IndexableDataDouble(T[] values, boolean mapNanToNull, PlotInfo plotInfo) {
        this(new IndexableNumericDataArrayNumber(values, plotInfo), mapNanToNull, plotInfo);
    }

    public IndexableDataDouble(short[] values, boolean mapNanToNull, PlotInfo plotInfo) {
        this(new IndexableNumericDataArrayShort(values, plotInfo), mapNanToNull, plotInfo);
    }

    public IndexableDataDouble(int[] values, boolean mapNanToNull, PlotInfo plotInfo) {
        this(new IndexableNumericDataArrayInt(values, plotInfo), mapNanToNull, plotInfo);
    }

    public IndexableDataDouble(long[] values, boolean mapNanToNull, PlotInfo plotInfo) {
        this(new IndexableNumericDataArrayLong(values, plotInfo), mapNanToNull, plotInfo);
    }

    public IndexableDataDouble(float[] values, boolean mapNanToNull, PlotInfo plotInfo) {
        this(new IndexableNumericDataArrayFloat(values, plotInfo), mapNanToNull, plotInfo);
    }

    public IndexableDataDouble(double[] values, boolean mapNanToNull, PlotInfo plotInfo) {
        this(new IndexableNumericDataArrayDouble(values, plotInfo), mapNanToNull, plotInfo);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Double get(int index) {
        double v = this.data.get(index);
        return this.mapNanToNull && Double.isNaN(v) ? null : Double.valueOf(v);
    }

    public boolean getMapNanToNull() {
        return this.mapNanToNull;
    }
}

