/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.data;

import io.deephaven.plot.datasets.data.IndexableData;
import io.deephaven.plot.datasets.data.IndexableDataInfinite;
import io.deephaven.plot.errors.PlotInfo;

public class IndexableDataWithDefault<T>
extends IndexableData<T> {
    private static final long serialVersionUID = -2083123815426589347L;
    private T defaultValue;
    private IndexableData<? extends T> specificValues;

    public IndexableDataWithDefault(PlotInfo plotInfo) {
        super(plotInfo);
    }

    @Override
    public int size() {
        return this.specificValues == null ? Integer.MAX_VALUE : this.specificValues.size();
    }

    @Override
    public T get(int index) {
        if (this.specificValues == null) {
            return this.defaultValue;
        }
        T v = this.specificValues.get(index);
        return v == null ? this.defaultValue : v;
    }

    public void setDefault(T v) {
        this.defaultValue = v;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public <TT extends T> void setSpecific(IndexableData<TT> specificValues, boolean infinite) {
        this.specificValues = infinite ? new IndexableDataInfinite<TT>(specificValues) : specificValues;
    }

    public void set(IndexableDataWithDefault<T> data) {
        this.defaultValue = data.defaultValue;
        this.specificValues = data.specificValues;
    }
}

