/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.data;

import io.deephaven.plot.datasets.data.IndexableNumericData;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;
import java.util.Date;

public class IndexableNumericDataArrayDate
extends IndexableNumericData {
    private static final long serialVersionUID = 7132588196200176807L;
    private final Date[] data;

    public IndexableNumericDataArrayDate(Date[] data, PlotInfo plotInfo) {
        super(plotInfo);
        ArgumentValidations.assertNotNull(data, "data", this.getPlotInfo());
        this.data = data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public double get(int index) {
        if (index >= this.data.length) {
            return Double.NaN;
        }
        Date v = this.data[index];
        return v == null ? Double.NaN : (double)(v.getTime() * 1000000L);
    }
}

