/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.data;

import io.deephaven.plot.datasets.data.IndexableNumericData;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.time.DateTime;

public class IndexableNumericDataArrayDateTime
extends IndexableNumericData {
    private static final long serialVersionUID = 2006200987348909028L;
    private final DateTime[] data;

    public IndexableNumericDataArrayDateTime(DateTime[] data, PlotInfo plotInfo) {
        super(plotInfo);
        ArgumentValidations.assertNotNull(data, "data", this.getPlotInfo());
        this.data = data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public double get(int i) {
        if (i >= this.data.length) {
            return Double.NaN;
        }
        double result = Double.NaN;
        DateTime v = this.data[i];
        if (v != null) {
            result = v.getNanos();
        }
        return result;
    }
}

