/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.data;

import io.deephaven.plot.datasets.data.IndexableNumericData;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;

public class IndexableNumericDataArrayNumber<T extends Number>
extends IndexableNumericData {
    private static final long serialVersionUID = -4587124538812025714L;
    private final T[] data;

    public IndexableNumericDataArrayNumber(T[] data, PlotInfo plotInfo) {
        super(plotInfo);
        ArgumentValidations.assertNotNull(data, "data", this.getPlotInfo());
        this.data = data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public double get(int i) {
        if (i >= this.data.length) {
            return Double.NaN;
        }
        T v = this.data[i];
        return v == null ? Double.NaN : ((Number)v).doubleValue();
    }
}

