/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.data;

import io.deephaven.plot.datasets.data.IndexableNumericData;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;
import java.util.List;

public class IndexableNumericDataListNumber<T extends Number>
extends IndexableNumericData {
    private static final long serialVersionUID = -382291808039710173L;
    private final List<T> data;

    public IndexableNumericDataListNumber(List<T> data, PlotInfo plotInfo) {
        super(plotInfo);
        ArgumentValidations.assertNotNull(data, "data", this.getPlotInfo());
        this.data = data;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public double get(int i) {
        if (i >= this.data.size()) {
            return Double.NaN;
        }
        Number v = (Number)this.data.get(i);
        return v == null ? Double.NaN : v.doubleValue();
    }
}

