/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.data;

import io.deephaven.plot.datasets.data.LiveIndexableNumericData;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.SwappableTable;

public class IndexableNumericDataSwappableTable
extends LiveIndexableNumericData {
    private static final long serialVersionUID = -5440770798950942675L;
    private final SwappableTable swappableTable;
    private final String column;

    public IndexableNumericDataSwappableTable(SwappableTable swappableTable, String column, PlotInfo plotInfo) {
        super(plotInfo);
        ArgumentValidations.assertNotNull(swappableTable, "swappableTable", this.getPlotInfo());
        ArgumentValidations.assertNotNull(column, "column", this.getPlotInfo());
        ArgumentValidations.assertColumnsInTable(swappableTable.getTableDefinition(), plotInfo, column);
        ArgumentValidations.assertIsNumericOrTime(swappableTable.getTableDefinition(), column, "Attempting to create a dataseries with a non-numeric column: column=" + column, plotInfo);
        this.swappableTable = swappableTable;
        this.column = column;
    }

    @Override
    public synchronized int size() {
        return 0;
    }

    @Override
    public synchronized double get(int i) {
        return Double.NaN;
    }

    public SwappableTable getSwappableTable() {
        return this.swappableTable;
    }

    public String getColumn() {
        return this.column;
    }
}

