/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.histogram;

import io.deephaven.function.Numeric;
import io.deephaven.plot.datasets.histogram.DiscretizedRange;
import java.io.Serializable;

public class DiscretizedRangeEqual
implements DiscretizedRange,
Serializable {
    private static final long serialVersionUID = 1537977750216956112L;
    private final double min;
    private final double max;
    private final double binWidth;

    public DiscretizedRangeEqual(double min, double max, int nBins) {
        this.min = min;
        this.max = max;
        this.binWidth = (max - min) / (double)nBins;
    }

    @Override
    public double binMin(long index) {
        return this.min + this.binWidth * (double)index;
    }

    @Override
    public double binMax(long index) {
        return this.min + this.binWidth * (double)(index + 1L);
    }

    @Override
    public long index(double value) {
        if (!Numeric.isFinite((double)value) || value < this.min || value > this.max) {
            return Long.MIN_VALUE;
        }
        long index = (long)((value - this.min) / this.binWidth);
        return value == this.max ? index - 1L : index;
    }
}

