/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.histogram;

import io.deephaven.api.agg.Aggregation;
import io.deephaven.base.verify.Require;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.util.TableTools;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.errors.PlotUnsupportedOperationException;
import io.deephaven.plot.util.ArgumentValidations;
import java.util.List;

public class HistogramCalculator {
    private static Table clean(Table t, String histogramColumn, PlotInfo plotInfo, String ... byColumns) {
        ArgumentValidations.assertIsNumeric(t, histogramColumn, "Histogram table", plotInfo);
        String[] view = new String[byColumns == null ? 1 : byColumns.length + 1];
        int i = 0;
        if (ArgumentValidations.isBoxedNumeric(t, histogramColumn, plotInfo)) {
            view[i++] = "X= " + histogramColumn + "==null ? Double.NaN : " + histogramColumn + ".doubleValue()";
        } else if (ArgumentValidations.isPrimitiveNumeric(t, histogramColumn, plotInfo)) {
            view[i++] = "X= isNull(" + histogramColumn + ") ? Double.NaN : (double) " + histogramColumn;
        } else {
            throw new PlotUnsupportedOperationException("Unsupported histogram histogramColumn: histogramColumn=" + histogramColumn + " type=" + ArgumentValidations.getColumnType(t, histogramColumn, plotInfo), plotInfo);
        }
        if (byColumns != null && byColumns.length > 0) {
            System.arraycopy(byColumns, 0, view, i, byColumns.length);
        }
        return (Table)((Table)t.view(view)).where(new String[]{"io.deephaven.function.Numeric.isFinite(X)"});
    }

    private static Table counts(Table data, Table range, String ... byColumns) {
        String[] groupByColumns = new String[byColumns != null ? byColumns.length + 1 : 1];
        groupByColumns[0] = "RangeIndex";
        if (byColumns != null && byColumns.length > 0) {
            System.arraycopy(byColumns, 0, groupByColumns, 1, byColumns.length);
        }
        return (Table)((Table)((Table)((Table)data.join(range).updateView(new String[]{"RangeIndex = Range.index(X)"})).where(new String[]{"!isNull(RangeIndex)"})).aggBy(List.of(Aggregation.AggCount((String)"Count"), Aggregation.AggLast((String[])new String[]{"Range"})), groupByColumns)).updateView(new String[]{"BinMin = Range.binMin(RangeIndex)", "BinMax = Range.binMax(RangeIndex)", "BinMid=0.5*(BinMin+BinMax)"});
    }

    private static Table range(Table t, int nbins) {
        return (Table)((Table)((Table)t.aggBy(List.of(Aggregation.AggMin((String[])new String[]{"RangeMin=X"}), Aggregation.AggMax((String[])new String[]{"RangeMax=X"}), Aggregation.AggCount((String)"NSamples")))).update(new String[]{"Range = new io.deephaven.plot.datasets.histogram.DiscretizedRangeEqual(RangeMin, RangeMax, " + nbins + ")"})).view(new String[]{"Range"});
    }

    private static Table range(double rangeMin, double rangeMax, int nbins) {
        return (Table)TableTools.emptyTable((long)1L).update(new String[]{"Range = new io.deephaven.plot.datasets.histogram.DiscretizedRangeEqual(" + rangeMin + "," + rangeMax + "," + nbins + ")"});
    }

    public static Table calc(Table table, String column, int nbins, PlotInfo plotInfo, String ... byColumns) {
        Require.neqNull((Object)table, (String)"table");
        Require.neqNull((Object)column, (String)"column");
        Table data = HistogramCalculator.clean(table, column, plotInfo, byColumns);
        Table range = HistogramCalculator.range(data, nbins);
        return HistogramCalculator.counts(data, range, byColumns);
    }

    public static Table calc(Table table, String column, int nbins, PlotInfo plotInfo, List<String> byColumns) {
        return HistogramCalculator.calc(table, column, nbins, plotInfo, byColumns != null && !byColumns.isEmpty() ? byColumns.toArray(new String[byColumns.size()]) : null);
    }

    public static Table calc(Table table, String histogramColumn, double rangeMin, double rangeMax, int nbins, PlotInfo plotInfo, String ... byColumns) {
        ArgumentValidations.assertNotNull(table, "table", plotInfo);
        ArgumentValidations.assertNotNull(histogramColumn, "histogramColumn", plotInfo);
        Table data = HistogramCalculator.clean(table, histogramColumn, plotInfo, byColumns);
        Table range = HistogramCalculator.range(rangeMin, rangeMax, nbins);
        return HistogramCalculator.counts(data, range, byColumns);
    }

    public static Table calc(Table table, String histogramColumn, double rangeMin, double rangeMax, int nbins, PlotInfo plotInfo, List<String> byColumns) {
        return HistogramCalculator.calc(table, histogramColumn, rangeMin, rangeMax, nbins, plotInfo, byColumns != null && !byColumns.isEmpty() ? byColumns.toArray(new String[byColumns.size()]) : null);
    }
}

