/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.multiseries;

import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.context.QueryScope;
import io.deephaven.engine.table.PartitionedTable;
import io.deephaven.engine.table.Table;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.datasets.DataSeriesInternal;
import io.deephaven.plot.datasets.multiseries.AbstractMultiSeries;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.TableBackedPartitionedTableHandle;
import java.util.Arrays;
import java.util.Map;

public abstract class AbstractPartitionedTableHandleMultiSeries<SERIES extends DataSeriesInternal>
extends AbstractMultiSeries<SERIES> {
    private static final long serialVersionUID = 1L;
    private final TableBackedPartitionedTableHandle partitionedTableHandle;
    private final String x;
    private final String y;

    AbstractPartitionedTableHandleMultiSeries(AxesImpl axes, int id, Comparable name, TableBackedPartitionedTableHandle partitionedTableHandle, String x, String y, String[] byColumns) {
        super(axes, id, name, byColumns);
        this.partitionedTableHandle = partitionedTableHandle;
        this.x = x;
        this.y = y;
        this.addPartitionedTableHandle(partitionedTableHandle);
        this.applyNamingFunction();
    }

    AbstractPartitionedTableHandleMultiSeries(AbstractPartitionedTableHandleMultiSeries series, AxesImpl axes) {
        super(series, axes);
        this.partitionedTableHandle = series.partitionedTableHandle;
        this.namingFunction = series.namingFunction;
        this.x = series.x;
        this.y = series.y;
        this.addPartitionedTableHandle(this.partitionedTableHandle);
    }

    @Override
    public String getX() {
        return this.x;
    }

    @Override
    public String getY() {
        return this.y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionedTable getPartitionedTable() {
        if (this.partitionedTable == null) {
            Object object = this.partitionedTableLock;
            synchronized (object) {
                if (this.partitionedTable != null) {
                    return this.partitionedTable;
                }
                this.partitionedTable = this.partitionedTableHandle.getPartitionedTable();
            }
        }
        return this.partitionedTable;
    }

    public TableBackedPartitionedTableHandle getPartitionedTableHandle() {
        return this.partitionedTableHandle;
    }

    @Override
    public void applyTransform(String columnName, String update, Class[] classesToImport, Map<String, Object> params, boolean columnTypesPreserved) {
        ArgumentValidations.assertNull(this.partitionedTable, "partitionedTable must be null", this.getPlotInfo());
        Arrays.stream(classesToImport).forEach(aClass -> ExecutionContext.getContext().getQueryLibrary().importClass(aClass));
        params.forEach(QueryScope::addParam);
        this.partitionedTableHandle.addColumn(columnName);
        this.chart().figure().registerTableFunction(this.partitionedTableHandle.getTable(), t -> (Table)t.update(new String[]{update}));
    }
}

