/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.multiseries;

import groovy.lang.Closure;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.BaseTable;
import io.deephaven.gui.color.Paint;
import io.deephaven.gui.shape.Shape;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.LineStyle;
import io.deephaven.plot.datasets.DynamicSeriesNamer;
import io.deephaven.plot.datasets.category.AbstractTableBasedCategoryDataSeries;
import io.deephaven.plot.datasets.category.CategoryTableDataSeriesInternal;
import io.deephaven.plot.datasets.categoryerrorbar.CategoryErrorBarDataSeriesInternal;
import io.deephaven.plot.datasets.categoryerrorbar.CategoryErrorBarDataSeriesKernel;
import io.deephaven.plot.datasets.multiseries.AbstractSwappableMultiSeries;
import io.deephaven.plot.filters.SelectableDataSet;
import io.deephaven.plot.filters.SelectableDataSetSwappableTable;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.PlotUtils;
import io.deephaven.plot.util.functions.ClosureFunction;
import io.deephaven.plot.util.functions.FigureImplFunction;
import io.deephaven.plot.util.tables.SwappableTable;
import io.deephaven.plot.util.tables.TableHandle;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class MultiCatErrorBarSeriesSwappable
extends AbstractSwappableMultiSeries<CategoryErrorBarDataSeriesInternal> {
    private static final long serialVersionUID = 3180012797112976859L;
    private final String categories;
    private final String values;
    private final String yLow;
    private final String yHigh;
    private PlotUtils.HashMapWithDefault<String, String> errorBarColorSeriesNameToStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Integer> errorBarColorSeriesNameTointMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Paint> errorBarColorSeriesNameToPaintMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Boolean> gradientVisibleSeriesNameTobooleanMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Integer> groupSeriesNameTointMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, String> lineColorSeriesNameToStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Integer> lineColorSeriesNameTointMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Paint> lineColorSeriesNameToPaintMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, LineStyle> lineStyleSeriesNameToLineStyleMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Boolean> linesVisibleSeriesNameToBooleanMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, String> piePercentLabelFormatSeriesNameToStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, String> pointColorSeriesNameToStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Integer> pointColorSeriesNameTointMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Paint> pointColorSeriesNameToPaintMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Map> pointColorSeriesNameToMapMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointColorSeriesNameToComparableStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointColorSeriesNameToComparableintMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointColorSeriesNameToComparablePaintMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointColorSeriesNameToTableStringStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointColorSeriesNameToSelectableDataSetStringStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Map> pointColorIntegerSeriesNameToMapMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object> pointLabelSeriesNameToObjectMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Map> pointLabelSeriesNameToMapMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointLabelSeriesNameToComparableObjectMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointLabelSeriesNameToTableStringStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointLabelSeriesNameToSelectableDataSetStringStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, String> pointLabelFormatSeriesNameToStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, String> pointShapeSeriesNameToStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Shape> pointShapeSeriesNameToShapeMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Map> pointShapeSeriesNameToMapMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointShapeSeriesNameToComparableStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointShapeSeriesNameToComparableShapeMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointShapeSeriesNameToTableStringStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointShapeSeriesNameToSelectableDataSetStringStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Number> pointSizeSeriesNameToNumberMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Map> pointSizeSeriesNameToMapMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToCATEGORYArrayNUMBERArrayMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToCATEGORYArraydoubleArrayMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToCATEGORYArrayintArrayMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToCATEGORYArraylongArrayMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToComparableNumberMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToComparabledoubleMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToComparableintMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToComparablelongMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToTableStringStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToSelectableDataSetStringStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Boolean> pointsVisibleSeriesNameToBooleanMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, String> seriesColorSeriesNameToStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Integer> seriesColorSeriesNameTointMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Paint> seriesColorSeriesNameToPaintMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, String> toolTipPatternSeriesNameToStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, String> xToolTipPatternSeriesNameToStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, String> yToolTipPatternSeriesNameToStringMap = new PlotUtils.HashMapWithDefault();

    public MultiCatErrorBarSeriesSwappable(AxesImpl axes, int id, Comparable name, SwappableTable swappableTable, String categories, String values, String yLow, String yHigh, String[] byColumns) {
        super(axes, id, name, swappableTable, categories, values, byColumns);
        ArgumentValidations.assertIsNumericOrTimeOrCharOrComparableInstance(swappableTable.getTableDefinition(), categories, "Invalid data type in category column: column=" + categories, this.getPlotInfo());
        ArgumentValidations.assertIsNumericOrTime(swappableTable.getTableDefinition(), values, "Invalid data type in category column: column=" + values, this.getPlotInfo());
        ArgumentValidations.assertIsNumericOrTime(swappableTable.getTableDefinition(), yLow, "Invalid data type in category column: column=" + yLow, this.getPlotInfo());
        ArgumentValidations.assertIsNumericOrTime(swappableTable.getTableDefinition(), yHigh, "Invalid data type in category column: column=" + yHigh, this.getPlotInfo());
        this.categories = categories;
        this.values = values;
        this.yLow = yLow;
        this.yHigh = yHigh;
    }

    private MultiCatErrorBarSeriesSwappable(MultiCatErrorBarSeriesSwappable series, AxesImpl axes) {
        super(series, axes);
        this.categories = series.categories;
        this.values = series.values;
        this.yLow = series.yLow;
        this.yHigh = series.yHigh;
    }

    @Override
    public CategoryErrorBarDataSeriesInternal createSeries(String seriesName, BaseTable t, DynamicSeriesNamer seriesNamer) {
        seriesName = this.makeSeriesName(seriesName, seriesNamer);
        NonserializableCategoryDataSeriesPartitionedTable series = new NonserializableCategoryDataSeriesPartitionedTable(this.axes(), (Comparable)((Object)seriesName), t, this.categories, this.values, this.yLow, this.yHigh);
        series.addSwappableTable(this.getSwappableTable());
        return series;
    }

    @Override
    public void initializeSeries(CategoryErrorBarDataSeriesInternal series) {
        this.$$initializeSeries$$(series);
    }

    @Override
    public <COLOR extends Paint> MultiCatErrorBarSeriesSwappable pointColor(Closure<COLOR> pointColor, Object ... multiSeriesKey) {
        return this.pointColor((Function)new ClosureFunction(pointColor), multiSeriesKey);
    }

    @Override
    public <COLOR extends Paint> MultiCatErrorBarSeriesSwappable pointColor(Function<Comparable, COLOR> pointColor, Object ... multiSeriesKey) {
        String newColumn = "__POINT_COLOR" + this.hashCode();
        this.applyFunction(pointColor, newColumn, this.getX(), Paint.class);
        this.chart().figure().registerFigureFunction(new FigureImplFunction(f -> f.pointColor(new SelectableDataSetSwappableTable(this.getSwappableTable()), this.getX(), newColumn, multiSeriesKey), this));
        return this;
    }

    @Override
    public <COLOR extends Integer> MultiCatErrorBarSeriesSwappable pointColorInteger(Closure<COLOR> colors, Object ... multiSeriesKey) {
        return this.pointColorInteger((Function)new ClosureFunction(colors), multiSeriesKey);
    }

    @Override
    public <COLOR extends Integer> MultiCatErrorBarSeriesSwappable pointColorInteger(Function<Comparable, COLOR> colors, Object ... multiSeriesKey) {
        String newColumn = "__POINT_COLOR" + this.hashCode();
        this.applyFunction(colors, newColumn, this.getX(), Integer.class);
        this.chart().figure().registerFigureFunction(new FigureImplFunction(f -> f.pointColor(new SelectableDataSetSwappableTable(this.getSwappableTable()), this.getX(), newColumn, multiSeriesKey), this));
        return this;
    }

    @Override
    public <LABEL> MultiCatErrorBarSeriesSwappable pointLabel(Closure<LABEL> pointLabels, Object ... multiSeriesKey) {
        return this.pointLabel((Function)new ClosureFunction(pointLabels), multiSeriesKey);
    }

    @Override
    public <LABEL> MultiCatErrorBarSeriesSwappable pointLabel(Function<Comparable, LABEL> pointLabels, Object ... multiSeriesKey) {
        String newColumn = "__POINT_LABEL" + this.hashCode();
        this.applyFunction(pointLabels, newColumn, this.getX(), Object.class);
        this.chart().figure().registerFigureFunction(new FigureImplFunction(f -> f.pointLabel(new SelectableDataSetSwappableTable(this.getSwappableTable()), this.getX(), newColumn, multiSeriesKey), this));
        return this;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointShape(Closure<String> pointShapes, Object ... multiSeriesKey) {
        return this.pointShape((Function)new ClosureFunction(pointShapes), multiSeriesKey);
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointShape(Function<Comparable, String> pointShapes, Object ... multiSeriesKey) {
        String newColumn = "__POINT_SHAPE" + this.hashCode();
        this.applyFunction(pointShapes, newColumn, this.getX(), String.class);
        this.chart().figure().registerFigureFunction(new FigureImplFunction(f -> f.pointShape(new SelectableDataSetSwappableTable(this.getSwappableTable()), this.getX(), newColumn, multiSeriesKey), this));
        return this;
    }

    @Override
    public <NUMBER extends Number> MultiCatErrorBarSeriesSwappable pointSize(Closure<NUMBER> pointSizes, Object ... multiSeriesKey) {
        return this.pointSize((Function)new ClosureFunction(pointSizes), multiSeriesKey);
    }

    @Override
    public <NUMBER extends Number> MultiCatErrorBarSeriesSwappable pointSize(Function<Comparable, NUMBER> pointSizes, Object ... multiSeriesKey) {
        String newColumn = "__POINT_SIZE" + this.hashCode();
        this.applyFunction(pointSizes, newColumn, this.getX(), Number.class);
        this.chart().figure().registerFigureFunction(new FigureImplFunction(f -> f.pointSize(new SelectableDataSetSwappableTable(this.getSwappableTable()), this.getX(), newColumn, multiSeriesKey), this));
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, String> errorBarColorSeriesNameToStringMap() {
        return this.errorBarColorSeriesNameToStringMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable errorBarColor(String errorBarColor, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.errorBarColorSeriesNameToStringMap.setDefault(errorBarColor);
        } else {
            this.errorBarColorSeriesNameToStringMap.put((String)this.namingFunction.apply(multiSeriesKey), errorBarColor);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Integer> errorBarColorSeriesNameTointMap() {
        return this.errorBarColorSeriesNameTointMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable errorBarColor(int errorBarColor, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.errorBarColorSeriesNameTointMap.setDefault(errorBarColor);
        } else {
            this.errorBarColorSeriesNameTointMap.put((String)this.namingFunction.apply(multiSeriesKey), errorBarColor);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Paint> errorBarColorSeriesNameToPaintMap() {
        return this.errorBarColorSeriesNameToPaintMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable errorBarColor(Paint errorBarColor, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.errorBarColorSeriesNameToPaintMap.setDefault(errorBarColor);
        } else {
            this.errorBarColorSeriesNameToPaintMap.put((String)this.namingFunction.apply(multiSeriesKey), errorBarColor);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Boolean> gradientVisibleSeriesNameTobooleanMap() {
        return this.gradientVisibleSeriesNameTobooleanMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable gradientVisible(boolean gradientVisible, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.gradientVisibleSeriesNameTobooleanMap.setDefault(gradientVisible);
        } else {
            this.gradientVisibleSeriesNameTobooleanMap.put((String)this.namingFunction.apply(multiSeriesKey), gradientVisible);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Integer> groupSeriesNameTointMap() {
        return this.groupSeriesNameTointMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable group(int group, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.groupSeriesNameTointMap.setDefault(group);
        } else {
            this.groupSeriesNameTointMap.put((String)this.namingFunction.apply(multiSeriesKey), group);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, String> lineColorSeriesNameToStringMap() {
        return this.lineColorSeriesNameToStringMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable lineColor(String color, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.lineColorSeriesNameToStringMap.setDefault(color);
        } else {
            this.lineColorSeriesNameToStringMap.put((String)this.namingFunction.apply(multiSeriesKey), color);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Integer> lineColorSeriesNameTointMap() {
        return this.lineColorSeriesNameTointMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable lineColor(int color, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.lineColorSeriesNameTointMap.setDefault(color);
        } else {
            this.lineColorSeriesNameTointMap.put((String)this.namingFunction.apply(multiSeriesKey), color);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Paint> lineColorSeriesNameToPaintMap() {
        return this.lineColorSeriesNameToPaintMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable lineColor(Paint color, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.lineColorSeriesNameToPaintMap.setDefault(color);
        } else {
            this.lineColorSeriesNameToPaintMap.put((String)this.namingFunction.apply(multiSeriesKey), color);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, LineStyle> lineStyleSeriesNameToLineStyleMap() {
        return this.lineStyleSeriesNameToLineStyleMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable lineStyle(LineStyle lineStyle, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.lineStyleSeriesNameToLineStyleMap.setDefault(lineStyle);
        } else {
            this.lineStyleSeriesNameToLineStyleMap.put((String)this.namingFunction.apply(multiSeriesKey), lineStyle);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Boolean> linesVisibleSeriesNameToBooleanMap() {
        return this.linesVisibleSeriesNameToBooleanMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable linesVisible(Boolean visible, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.linesVisibleSeriesNameToBooleanMap.setDefault(visible);
        } else {
            this.linesVisibleSeriesNameToBooleanMap.put((String)this.namingFunction.apply(multiSeriesKey), visible);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, String> piePercentLabelFormatSeriesNameToStringMap() {
        return this.piePercentLabelFormatSeriesNameToStringMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable piePercentLabelFormat(String pieLabelFormat, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.piePercentLabelFormatSeriesNameToStringMap.setDefault(pieLabelFormat);
        } else {
            this.piePercentLabelFormatSeriesNameToStringMap.put((String)this.namingFunction.apply(multiSeriesKey), pieLabelFormat);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, String> pointColorSeriesNameToStringMap() {
        return this.pointColorSeriesNameToStringMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointColor(String pointColor, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorSeriesNameToStringMap.setDefault(pointColor);
        } else {
            this.pointColorSeriesNameToStringMap.put((String)this.namingFunction.apply(multiSeriesKey), pointColor);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Integer> pointColorSeriesNameTointMap() {
        return this.pointColorSeriesNameTointMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointColor(int pointColor, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorSeriesNameTointMap.setDefault(pointColor);
        } else {
            this.pointColorSeriesNameTointMap.put((String)this.namingFunction.apply(multiSeriesKey), pointColor);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Paint> pointColorSeriesNameToPaintMap() {
        return this.pointColorSeriesNameToPaintMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointColor(Paint pointColor, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorSeriesNameToPaintMap.setDefault(pointColor);
        } else {
            this.pointColorSeriesNameToPaintMap.put((String)this.namingFunction.apply(multiSeriesKey), pointColor);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Map> pointColorSeriesNameToMapMap() {
        return this.pointColorSeriesNameToMapMap;
    }

    @Override
    public <CATEGORY extends Comparable, COLOR extends Paint> MultiCatErrorBarSeriesSwappable pointColor(Map<CATEGORY, COLOR> pointColor, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorSeriesNameToMapMap.setDefault(pointColor);
        } else {
            this.pointColorSeriesNameToMapMap.put((String)this.namingFunction.apply(multiSeriesKey), pointColor);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointColorSeriesNameToComparableStringMap() {
        return this.pointColorSeriesNameToComparableStringMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointColor(Comparable category, String pointColor, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorSeriesNameToComparableStringMap.setDefault(new Object[]{category, pointColor});
        } else {
            this.pointColorSeriesNameToComparableStringMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{category, pointColor});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointColorSeriesNameToComparableintMap() {
        return this.pointColorSeriesNameToComparableintMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointColor(Comparable category, int pointColor, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorSeriesNameToComparableintMap.setDefault(new Object[]{category, pointColor});
        } else {
            this.pointColorSeriesNameToComparableintMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{category, pointColor});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointColorSeriesNameToComparablePaintMap() {
        return this.pointColorSeriesNameToComparablePaintMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointColor(Comparable category, Paint pointColor, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorSeriesNameToComparablePaintMap.setDefault(new Object[]{category, pointColor});
        } else {
            this.pointColorSeriesNameToComparablePaintMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{category, pointColor});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointColorSeriesNameToTableStringStringMap() {
        return this.pointColorSeriesNameToTableStringStringMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointColor(Table t, String category, String pointColor, Object ... multiSeriesKey) {
        TableHandle tHandle = new TableHandle(t, category, pointColor);
        this.addTableHandle(tHandle);
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorSeriesNameToTableStringStringMap.setDefault(new Object[]{tHandle, category, pointColor});
        } else {
            this.pointColorSeriesNameToTableStringStringMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{tHandle, category, pointColor});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointColorSeriesNameToSelectableDataSetStringStringMap() {
        return this.pointColorSeriesNameToSelectableDataSetStringStringMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointColor(SelectableDataSet sds, String category, String pointColor, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorSeriesNameToSelectableDataSetStringStringMap.setDefault(new Object[]{sds, category, pointColor});
        } else {
            this.pointColorSeriesNameToSelectableDataSetStringStringMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{sds, category, pointColor});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Map> pointColorIntegerSeriesNameToMapMap() {
        return this.pointColorIntegerSeriesNameToMapMap;
    }

    @Override
    public <CATEGORY extends Comparable, COLOR extends Integer> MultiCatErrorBarSeriesSwappable pointColorInteger(Map<CATEGORY, COLOR> colors, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorIntegerSeriesNameToMapMap.setDefault(colors);
        } else {
            this.pointColorIntegerSeriesNameToMapMap.put((String)this.namingFunction.apply(multiSeriesKey), colors);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object> pointLabelSeriesNameToObjectMap() {
        return this.pointLabelSeriesNameToObjectMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointLabel(Object pointLabel, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointLabelSeriesNameToObjectMap.setDefault(pointLabel);
        } else {
            this.pointLabelSeriesNameToObjectMap.put((String)this.namingFunction.apply(multiSeriesKey), pointLabel);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Map> pointLabelSeriesNameToMapMap() {
        return this.pointLabelSeriesNameToMapMap;
    }

    @Override
    public <CATEGORY extends Comparable, LABEL> MultiCatErrorBarSeriesSwappable pointLabel(Map<CATEGORY, LABEL> pointLabels, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointLabelSeriesNameToMapMap.setDefault(pointLabels);
        } else {
            this.pointLabelSeriesNameToMapMap.put((String)this.namingFunction.apply(multiSeriesKey), pointLabels);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointLabelSeriesNameToComparableObjectMap() {
        return this.pointLabelSeriesNameToComparableObjectMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointLabel(Comparable category, Object pointLabel, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointLabelSeriesNameToComparableObjectMap.setDefault(new Object[]{category, pointLabel});
        } else {
            this.pointLabelSeriesNameToComparableObjectMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{category, pointLabel});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointLabelSeriesNameToTableStringStringMap() {
        return this.pointLabelSeriesNameToTableStringStringMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointLabel(Table t, String category, String pointLabel, Object ... multiSeriesKey) {
        TableHandle tHandle = new TableHandle(t, category, pointLabel);
        this.addTableHandle(tHandle);
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointLabelSeriesNameToTableStringStringMap.setDefault(new Object[]{tHandle, category, pointLabel});
        } else {
            this.pointLabelSeriesNameToTableStringStringMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{tHandle, category, pointLabel});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointLabelSeriesNameToSelectableDataSetStringStringMap() {
        return this.pointLabelSeriesNameToSelectableDataSetStringStringMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointLabel(SelectableDataSet sds, String category, String pointLabel, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointLabelSeriesNameToSelectableDataSetStringStringMap.setDefault(new Object[]{sds, category, pointLabel});
        } else {
            this.pointLabelSeriesNameToSelectableDataSetStringStringMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{sds, category, pointLabel});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, String> pointLabelFormatSeriesNameToStringMap() {
        return this.pointLabelFormatSeriesNameToStringMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointLabelFormat(String pointLabelFormat, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointLabelFormatSeriesNameToStringMap.setDefault(pointLabelFormat);
        } else {
            this.pointLabelFormatSeriesNameToStringMap.put((String)this.namingFunction.apply(multiSeriesKey), pointLabelFormat);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, String> pointShapeSeriesNameToStringMap() {
        return this.pointShapeSeriesNameToStringMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointShape(String pointShape, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointShapeSeriesNameToStringMap.setDefault(pointShape);
        } else {
            this.pointShapeSeriesNameToStringMap.put((String)this.namingFunction.apply(multiSeriesKey), pointShape);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Shape> pointShapeSeriesNameToShapeMap() {
        return this.pointShapeSeriesNameToShapeMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointShape(Shape pointShape, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointShapeSeriesNameToShapeMap.setDefault(pointShape);
        } else {
            this.pointShapeSeriesNameToShapeMap.put((String)this.namingFunction.apply(multiSeriesKey), pointShape);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Map> pointShapeSeriesNameToMapMap() {
        return this.pointShapeSeriesNameToMapMap;
    }

    @Override
    public <CATEGORY extends Comparable> MultiCatErrorBarSeriesSwappable pointShape(Map<CATEGORY, String> pointShapes, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointShapeSeriesNameToMapMap.setDefault(pointShapes);
        } else {
            this.pointShapeSeriesNameToMapMap.put((String)this.namingFunction.apply(multiSeriesKey), pointShapes);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointShapeSeriesNameToComparableStringMap() {
        return this.pointShapeSeriesNameToComparableStringMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointShape(Comparable category, String pointShape, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointShapeSeriesNameToComparableStringMap.setDefault(new Object[]{category, pointShape});
        } else {
            this.pointShapeSeriesNameToComparableStringMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{category, pointShape});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointShapeSeriesNameToComparableShapeMap() {
        return this.pointShapeSeriesNameToComparableShapeMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointShape(Comparable category, Shape pointShape, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointShapeSeriesNameToComparableShapeMap.setDefault(new Object[]{category, pointShape});
        } else {
            this.pointShapeSeriesNameToComparableShapeMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{category, pointShape});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointShapeSeriesNameToTableStringStringMap() {
        return this.pointShapeSeriesNameToTableStringStringMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointShape(Table t, String category, String pointShape, Object ... multiSeriesKey) {
        TableHandle tHandle = new TableHandle(t, category, pointShape);
        this.addTableHandle(tHandle);
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointShapeSeriesNameToTableStringStringMap.setDefault(new Object[]{tHandle, category, pointShape});
        } else {
            this.pointShapeSeriesNameToTableStringStringMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{tHandle, category, pointShape});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointShapeSeriesNameToSelectableDataSetStringStringMap() {
        return this.pointShapeSeriesNameToSelectableDataSetStringStringMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointShape(SelectableDataSet sds, String category, String pointShape, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointShapeSeriesNameToSelectableDataSetStringStringMap.setDefault(new Object[]{sds, category, pointShape});
        } else {
            this.pointShapeSeriesNameToSelectableDataSetStringStringMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{sds, category, pointShape});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Number> pointSizeSeriesNameToNumberMap() {
        return this.pointSizeSeriesNameToNumberMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointSize(Number pointSize, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointSizeSeriesNameToNumberMap.setDefault(pointSize);
        } else {
            this.pointSizeSeriesNameToNumberMap.put((String)this.namingFunction.apply(multiSeriesKey), pointSize);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Map> pointSizeSeriesNameToMapMap() {
        return this.pointSizeSeriesNameToMapMap;
    }

    @Override
    public <CATEGORY extends Comparable, NUMBER extends Number> MultiCatErrorBarSeriesSwappable pointSize(Map<CATEGORY, NUMBER> pointSizes, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointSizeSeriesNameToMapMap.setDefault(pointSizes);
        } else {
            this.pointSizeSeriesNameToMapMap.put((String)this.namingFunction.apply(multiSeriesKey), pointSizes);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToCATEGORYArrayNUMBERArrayMap() {
        return this.pointSizeSeriesNameToCATEGORYArrayNUMBERArrayMap;
    }

    @Override
    public <CATEGORY extends Comparable, NUMBER extends Number> MultiCatErrorBarSeriesSwappable pointSize(CATEGORY[] categories, NUMBER[] pointSizes, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointSizeSeriesNameToCATEGORYArrayNUMBERArrayMap.setDefault(new Object[]{categories, pointSizes});
        } else {
            this.pointSizeSeriesNameToCATEGORYArrayNUMBERArrayMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{categories, pointSizes});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToCATEGORYArraydoubleArrayMap() {
        return this.pointSizeSeriesNameToCATEGORYArraydoubleArrayMap;
    }

    @Override
    public <CATEGORY extends Comparable> MultiCatErrorBarSeriesSwappable pointSize(CATEGORY[] categories, double[] pointSizes, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointSizeSeriesNameToCATEGORYArraydoubleArrayMap.setDefault(new Object[]{categories, pointSizes});
        } else {
            this.pointSizeSeriesNameToCATEGORYArraydoubleArrayMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{categories, pointSizes});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToCATEGORYArrayintArrayMap() {
        return this.pointSizeSeriesNameToCATEGORYArrayintArrayMap;
    }

    @Override
    public <CATEGORY extends Comparable> MultiCatErrorBarSeriesSwappable pointSize(CATEGORY[] categories, int[] pointSizes, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointSizeSeriesNameToCATEGORYArrayintArrayMap.setDefault(new Object[]{categories, pointSizes});
        } else {
            this.pointSizeSeriesNameToCATEGORYArrayintArrayMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{categories, pointSizes});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToCATEGORYArraylongArrayMap() {
        return this.pointSizeSeriesNameToCATEGORYArraylongArrayMap;
    }

    @Override
    public <CATEGORY extends Comparable> MultiCatErrorBarSeriesSwappable pointSize(CATEGORY[] categories, long[] pointSizes, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointSizeSeriesNameToCATEGORYArraylongArrayMap.setDefault(new Object[]{categories, pointSizes});
        } else {
            this.pointSizeSeriesNameToCATEGORYArraylongArrayMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{categories, pointSizes});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToComparableNumberMap() {
        return this.pointSizeSeriesNameToComparableNumberMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointSize(Comparable category, Number pointSize, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointSizeSeriesNameToComparableNumberMap.setDefault(new Object[]{category, pointSize});
        } else {
            this.pointSizeSeriesNameToComparableNumberMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{category, pointSize});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToComparabledoubleMap() {
        return this.pointSizeSeriesNameToComparabledoubleMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointSize(Comparable category, double pointSize, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointSizeSeriesNameToComparabledoubleMap.setDefault(new Object[]{category, pointSize});
        } else {
            this.pointSizeSeriesNameToComparabledoubleMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{category, pointSize});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToComparableintMap() {
        return this.pointSizeSeriesNameToComparableintMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointSize(Comparable category, int pointSize, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointSizeSeriesNameToComparableintMap.setDefault(new Object[]{category, pointSize});
        } else {
            this.pointSizeSeriesNameToComparableintMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{category, pointSize});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToComparablelongMap() {
        return this.pointSizeSeriesNameToComparablelongMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointSize(Comparable category, long pointSize, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointSizeSeriesNameToComparablelongMap.setDefault(new Object[]{category, pointSize});
        } else {
            this.pointSizeSeriesNameToComparablelongMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{category, pointSize});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToTableStringStringMap() {
        return this.pointSizeSeriesNameToTableStringStringMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointSize(Table t, String category, String pointSize, Object ... multiSeriesKey) {
        TableHandle tHandle = new TableHandle(t, category, pointSize);
        this.addTableHandle(tHandle);
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointSizeSeriesNameToTableStringStringMap.setDefault(new Object[]{tHandle, category, pointSize});
        } else {
            this.pointSizeSeriesNameToTableStringStringMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{tHandle, category, pointSize});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToSelectableDataSetStringStringMap() {
        return this.pointSizeSeriesNameToSelectableDataSetStringStringMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointSize(SelectableDataSet sds, String category, String pointSize, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointSizeSeriesNameToSelectableDataSetStringStringMap.setDefault(new Object[]{sds, category, pointSize});
        } else {
            this.pointSizeSeriesNameToSelectableDataSetStringStringMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{sds, category, pointSize});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Boolean> pointsVisibleSeriesNameToBooleanMap() {
        return this.pointsVisibleSeriesNameToBooleanMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable pointsVisible(Boolean visible, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointsVisibleSeriesNameToBooleanMap.setDefault(visible);
        } else {
            this.pointsVisibleSeriesNameToBooleanMap.put((String)this.namingFunction.apply(multiSeriesKey), visible);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, String> seriesColorSeriesNameToStringMap() {
        return this.seriesColorSeriesNameToStringMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable seriesColor(String color, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.seriesColorSeriesNameToStringMap.setDefault(color);
        } else {
            this.seriesColorSeriesNameToStringMap.put((String)this.namingFunction.apply(multiSeriesKey), color);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Integer> seriesColorSeriesNameTointMap() {
        return this.seriesColorSeriesNameTointMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable seriesColor(int color, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.seriesColorSeriesNameTointMap.setDefault(color);
        } else {
            this.seriesColorSeriesNameTointMap.put((String)this.namingFunction.apply(multiSeriesKey), color);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Paint> seriesColorSeriesNameToPaintMap() {
        return this.seriesColorSeriesNameToPaintMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable seriesColor(Paint color, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.seriesColorSeriesNameToPaintMap.setDefault(color);
        } else {
            this.seriesColorSeriesNameToPaintMap.put((String)this.namingFunction.apply(multiSeriesKey), color);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, String> toolTipPatternSeriesNameToStringMap() {
        return this.toolTipPatternSeriesNameToStringMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable toolTipPattern(String toolTipPattern, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.toolTipPatternSeriesNameToStringMap.setDefault(toolTipPattern);
        } else {
            this.toolTipPatternSeriesNameToStringMap.put((String)this.namingFunction.apply(multiSeriesKey), toolTipPattern);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, String> xToolTipPatternSeriesNameToStringMap() {
        return this.xToolTipPatternSeriesNameToStringMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable xToolTipPattern(String xToolTipPattern, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.xToolTipPatternSeriesNameToStringMap.setDefault(xToolTipPattern);
        } else {
            this.xToolTipPatternSeriesNameToStringMap.put((String)this.namingFunction.apply(multiSeriesKey), xToolTipPattern);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, String> yToolTipPatternSeriesNameToStringMap() {
        return this.yToolTipPatternSeriesNameToStringMap;
    }

    @Override
    public MultiCatErrorBarSeriesSwappable yToolTipPattern(String yToolTipPattern, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.yToolTipPatternSeriesNameToStringMap.setDefault(yToolTipPattern);
        } else {
            this.yToolTipPatternSeriesNameToStringMap.put((String)this.namingFunction.apply(multiSeriesKey), yToolTipPattern);
        }
        return this;
    }

    private <CATEGORY extends Comparable, COLOR extends Paint, LABEL, NUMBER extends Number, COLOR0 extends Integer> void $$initializeSeries$$(CategoryErrorBarDataSeriesInternal series) {
        String name = series.name().toString();
        Consumer<Map> consumer0 = series::pointColor;
        this.pointColorSeriesNameToMapMap.runIfKeyExistsCast(consumer0, name);
        Object[] objectArray = this.pointSizeSeriesNameToComparableNumberMap.get(name);
        if (objectArray != null) {
            series.pointSize((Comparable)objectArray[0], (Number)objectArray[1]);
        }
        if ((objectArray = this.pointColorSeriesNameToTableStringStringMap.get(name)) != null) {
            series.pointColor(((TableHandle)objectArray[0]).getTable(), (String)objectArray[1], (String)objectArray[2]);
        }
        Consumer<Boolean> consumer1 = series::pointsVisible;
        this.pointsVisibleSeriesNameToBooleanMap.runIfKeyExistsCast(consumer1, name);
        Consumer<Shape> consumer2 = series::pointShape;
        this.pointShapeSeriesNameToShapeMap.runIfKeyExistsCast(consumer2, name);
        Consumer<Integer> consumer3 = series::lineColor;
        this.lineColorSeriesNameTointMap.runIfKeyExistsCast(consumer3, name);
        objectArray = this.pointShapeSeriesNameToComparableShapeMap.get(name);
        if (objectArray != null) {
            series.pointShape((Comparable)objectArray[0], (Shape)objectArray[1]);
        }
        Consumer<Paint> consumer4 = series::seriesColor;
        this.seriesColorSeriesNameToPaintMap.runIfKeyExistsCast(consumer4, name);
        objectArray = this.pointColorSeriesNameToComparableStringMap.get(name);
        if (objectArray != null) {
            series.pointColor((Comparable)objectArray[0], (String)objectArray[1]);
        }
        if ((objectArray = this.pointColorSeriesNameToComparablePaintMap.get(name)) != null) {
            series.pointColor((Comparable)objectArray[0], (Paint)objectArray[1]);
        }
        Consumer<String> consumer5 = series::yToolTipPattern;
        this.yToolTipPatternSeriesNameToStringMap.runIfKeyExistsCast(consumer5, name);
        Consumer<Integer> consumer6 = series::seriesColor;
        this.seriesColorSeriesNameTointMap.runIfKeyExistsCast(consumer6, name);
        objectArray = this.pointSizeSeriesNameToComparabledoubleMap.get(name);
        if (objectArray != null) {
            series.pointSize((Comparable)objectArray[0], (Double)objectArray[1]);
        }
        Consumer<Object> consumer7 = series::pointLabel;
        this.pointLabelSeriesNameToObjectMap.runIfKeyExistsCast(consumer7, name);
        Consumer<Paint> consumer8 = series::errorBarColor;
        this.errorBarColorSeriesNameToPaintMap.runIfKeyExistsCast(consumer8, name);
        objectArray = this.pointSizeSeriesNameToComparablelongMap.get(name);
        if (objectArray != null) {
            series.pointSize((Comparable)objectArray[0], (Long)objectArray[1]);
        }
        Consumer<String> consumer9 = series::seriesColor;
        this.seriesColorSeriesNameToStringMap.runIfKeyExistsCast(consumer9, name);
        objectArray = this.pointShapeSeriesNameToComparableStringMap.get(name);
        if (objectArray != null) {
            series.pointShape((Comparable)objectArray[0], (String)objectArray[1]);
        }
        if ((objectArray = this.pointLabelSeriesNameToTableStringStringMap.get(name)) != null) {
            series.pointLabel(((TableHandle)objectArray[0]).getTable(), (String)objectArray[1], (String)objectArray[2]);
        }
        Consumer<Map> consumer10 = series::pointShape;
        this.pointShapeSeriesNameToMapMap.runIfKeyExistsCast(consumer10, name);
        Consumer<Boolean> consumer11 = series::gradientVisible;
        this.gradientVisibleSeriesNameTobooleanMap.runIfKeyExistsCast(consumer11, name);
        Consumer<Paint> consumer12 = series::pointColor;
        this.pointColorSeriesNameToPaintMap.runIfKeyExistsCast(consumer12, name);
        objectArray = this.pointShapeSeriesNameToTableStringStringMap.get(name);
        if (objectArray != null) {
            series.pointShape(((TableHandle)objectArray[0]).getTable(), (String)objectArray[1], (String)objectArray[2]);
        }
        Consumer<String> consumer13 = series::piePercentLabelFormat;
        this.piePercentLabelFormatSeriesNameToStringMap.runIfKeyExistsCast(consumer13, name);
        objectArray = this.pointLabelSeriesNameToSelectableDataSetStringStringMap.get(name);
        if (objectArray != null) {
            series.pointLabel((SelectableDataSet)objectArray[0], (String)objectArray[1], (String)objectArray[2]);
        }
        Consumer<String> consumer14 = series::errorBarColor;
        this.errorBarColorSeriesNameToStringMap.runIfKeyExistsCast(consumer14, name);
        objectArray = this.pointColorSeriesNameToSelectableDataSetStringStringMap.get(name);
        if (objectArray != null) {
            series.pointColor((SelectableDataSet)objectArray[0], (String)objectArray[1], (String)objectArray[2]);
        }
        Consumer<String> consumer15 = series::xToolTipPattern;
        this.xToolTipPatternSeriesNameToStringMap.runIfKeyExistsCast(consumer15, name);
        Consumer<Integer> consumer16 = series::errorBarColor;
        this.errorBarColorSeriesNameTointMap.runIfKeyExistsCast(consumer16, name);
        objectArray = this.pointLabelSeriesNameToComparableObjectMap.get(name);
        if (objectArray != null) {
            series.pointLabel((Comparable)objectArray[0], objectArray[1]);
        }
        Consumer<String> consumer17 = series::toolTipPattern;
        this.toolTipPatternSeriesNameToStringMap.runIfKeyExistsCast(consumer17, name);
        Consumer<String> consumer18 = series::pointLabelFormat;
        this.pointLabelFormatSeriesNameToStringMap.runIfKeyExistsCast(consumer18, name);
        objectArray = this.pointShapeSeriesNameToSelectableDataSetStringStringMap.get(name);
        if (objectArray != null) {
            series.pointShape((SelectableDataSet)objectArray[0], (String)objectArray[1], (String)objectArray[2]);
        }
        Consumer<String> consumer19 = series::pointColor;
        this.pointColorSeriesNameToStringMap.runIfKeyExistsCast(consumer19, name);
        Consumer<Boolean> consumer20 = series::linesVisible;
        this.linesVisibleSeriesNameToBooleanMap.runIfKeyExistsCast(consumer20, name);
        Consumer<String> consumer21 = series::lineColor;
        this.lineColorSeriesNameToStringMap.runIfKeyExistsCast(consumer21, name);
        objectArray = this.pointSizeSeriesNameToCATEGORYArraydoubleArrayMap.get(name);
        if (objectArray != null) {
            series.pointSize((Comparable[])objectArray[0], (double[])objectArray[1]);
        }
        if ((objectArray = this.pointSizeSeriesNameToTableStringStringMap.get(name)) != null) {
            series.pointSize(((TableHandle)objectArray[0]).getTable(), (String)objectArray[1], (String)objectArray[2]);
        }
        Consumer<Map> consumer22 = series::pointLabel;
        this.pointLabelSeriesNameToMapMap.runIfKeyExistsCast(consumer22, name);
        Consumer<Paint> consumer23 = series::lineColor;
        this.lineColorSeriesNameToPaintMap.runIfKeyExistsCast(consumer23, name);
        objectArray = this.pointSizeSeriesNameToComparableintMap.get(name);
        if (objectArray != null) {
            series.pointSize((Comparable)objectArray[0], (Integer)objectArray[1]);
        }
        if ((objectArray = this.pointSizeSeriesNameToCATEGORYArraylongArrayMap.get(name)) != null) {
            series.pointSize((Comparable[])objectArray[0], (long[])objectArray[1]);
        }
        Consumer<Integer> consumer24 = series::group;
        this.groupSeriesNameTointMap.runIfKeyExistsCast(consumer24, name);
        Consumer<LineStyle> consumer25 = series::lineStyle;
        this.lineStyleSeriesNameToLineStyleMap.runIfKeyExistsCast(consumer25, name);
        Consumer<Map> consumer26 = series::pointSize;
        this.pointSizeSeriesNameToMapMap.runIfKeyExistsCast(consumer26, name);
        objectArray = this.pointSizeSeriesNameToCATEGORYArrayintArrayMap.get(name);
        if (objectArray != null) {
            series.pointSize((Comparable[])objectArray[0], (int[])objectArray[1]);
        }
        Consumer<Map> consumer27 = series::pointColorInteger;
        this.pointColorIntegerSeriesNameToMapMap.runIfKeyExistsCast(consumer27, name);
        Consumer<Number> consumer28 = series::pointSize;
        this.pointSizeSeriesNameToNumberMap.runIfKeyExistsCast(consumer28, name);
        objectArray = this.pointSizeSeriesNameToCATEGORYArrayNUMBERArrayMap.get(name);
        if (objectArray != null) {
            series.pointSize((Comparable[])objectArray[0], (Number[])objectArray[1]);
        }
        Consumer<Integer> consumer29 = series::pointColor;
        this.pointColorSeriesNameTointMap.runIfKeyExistsCast(consumer29, name);
        objectArray = this.pointColorSeriesNameToComparableintMap.get(name);
        if (objectArray != null) {
            series.pointColor((Comparable)objectArray[0], (Integer)objectArray[1]);
        }
        Consumer<String> consumer30 = series::pointShape;
        this.pointShapeSeriesNameToStringMap.runIfKeyExistsCast(consumer30, name);
        objectArray = this.pointSizeSeriesNameToSelectableDataSetStringStringMap.get(name);
        if (objectArray != null) {
            series.pointSize((SelectableDataSet)objectArray[0], (String)objectArray[1], (String)objectArray[2]);
        }
    }

    @Override
    public MultiCatErrorBarSeriesSwappable copy(AxesImpl axes) {
        MultiCatErrorBarSeriesSwappable __s__ = new MultiCatErrorBarSeriesSwappable(this, axes);
        __s__.pointColorSeriesNameToMapMap = this.pointColorSeriesNameToMapMap.copy();
        __s__.pointSizeSeriesNameToComparableNumberMap = this.pointSizeSeriesNameToComparableNumberMap.copy();
        __s__.pointColorSeriesNameToTableStringStringMap = this.pointColorSeriesNameToTableStringStringMap.copy();
        __s__.pointsVisibleSeriesNameToBooleanMap = this.pointsVisibleSeriesNameToBooleanMap.copy();
        __s__.pointShapeSeriesNameToShapeMap = this.pointShapeSeriesNameToShapeMap.copy();
        __s__.lineColorSeriesNameTointMap = this.lineColorSeriesNameTointMap.copy();
        __s__.pointShapeSeriesNameToComparableShapeMap = this.pointShapeSeriesNameToComparableShapeMap.copy();
        __s__.seriesColorSeriesNameToPaintMap = this.seriesColorSeriesNameToPaintMap.copy();
        __s__.pointColorSeriesNameToComparableStringMap = this.pointColorSeriesNameToComparableStringMap.copy();
        __s__.pointColorSeriesNameToComparablePaintMap = this.pointColorSeriesNameToComparablePaintMap.copy();
        __s__.yToolTipPatternSeriesNameToStringMap = this.yToolTipPatternSeriesNameToStringMap.copy();
        __s__.seriesColorSeriesNameTointMap = this.seriesColorSeriesNameTointMap.copy();
        __s__.pointSizeSeriesNameToComparabledoubleMap = this.pointSizeSeriesNameToComparabledoubleMap.copy();
        __s__.pointLabelSeriesNameToObjectMap = this.pointLabelSeriesNameToObjectMap.copy();
        __s__.errorBarColorSeriesNameToPaintMap = this.errorBarColorSeriesNameToPaintMap.copy();
        __s__.pointSizeSeriesNameToComparablelongMap = this.pointSizeSeriesNameToComparablelongMap.copy();
        __s__.seriesColorSeriesNameToStringMap = this.seriesColorSeriesNameToStringMap.copy();
        __s__.pointShapeSeriesNameToComparableStringMap = this.pointShapeSeriesNameToComparableStringMap.copy();
        __s__.pointLabelSeriesNameToTableStringStringMap = this.pointLabelSeriesNameToTableStringStringMap.copy();
        __s__.pointShapeSeriesNameToMapMap = this.pointShapeSeriesNameToMapMap.copy();
        __s__.gradientVisibleSeriesNameTobooleanMap = this.gradientVisibleSeriesNameTobooleanMap.copy();
        __s__.pointColorSeriesNameToPaintMap = this.pointColorSeriesNameToPaintMap.copy();
        __s__.pointShapeSeriesNameToTableStringStringMap = this.pointShapeSeriesNameToTableStringStringMap.copy();
        __s__.piePercentLabelFormatSeriesNameToStringMap = this.piePercentLabelFormatSeriesNameToStringMap.copy();
        __s__.pointLabelSeriesNameToSelectableDataSetStringStringMap = this.pointLabelSeriesNameToSelectableDataSetStringStringMap.copy();
        __s__.errorBarColorSeriesNameToStringMap = this.errorBarColorSeriesNameToStringMap.copy();
        __s__.pointColorSeriesNameToSelectableDataSetStringStringMap = this.pointColorSeriesNameToSelectableDataSetStringStringMap.copy();
        __s__.xToolTipPatternSeriesNameToStringMap = this.xToolTipPatternSeriesNameToStringMap.copy();
        __s__.errorBarColorSeriesNameTointMap = this.errorBarColorSeriesNameTointMap.copy();
        __s__.pointLabelSeriesNameToComparableObjectMap = this.pointLabelSeriesNameToComparableObjectMap.copy();
        __s__.toolTipPatternSeriesNameToStringMap = this.toolTipPatternSeriesNameToStringMap.copy();
        __s__.pointLabelFormatSeriesNameToStringMap = this.pointLabelFormatSeriesNameToStringMap.copy();
        __s__.pointShapeSeriesNameToSelectableDataSetStringStringMap = this.pointShapeSeriesNameToSelectableDataSetStringStringMap.copy();
        __s__.pointColorSeriesNameToStringMap = this.pointColorSeriesNameToStringMap.copy();
        __s__.linesVisibleSeriesNameToBooleanMap = this.linesVisibleSeriesNameToBooleanMap.copy();
        __s__.lineColorSeriesNameToStringMap = this.lineColorSeriesNameToStringMap.copy();
        __s__.pointSizeSeriesNameToCATEGORYArraydoubleArrayMap = this.pointSizeSeriesNameToCATEGORYArraydoubleArrayMap.copy();
        __s__.pointSizeSeriesNameToTableStringStringMap = this.pointSizeSeriesNameToTableStringStringMap.copy();
        __s__.pointLabelSeriesNameToMapMap = this.pointLabelSeriesNameToMapMap.copy();
        __s__.lineColorSeriesNameToPaintMap = this.lineColorSeriesNameToPaintMap.copy();
        __s__.pointSizeSeriesNameToComparableintMap = this.pointSizeSeriesNameToComparableintMap.copy();
        __s__.pointSizeSeriesNameToCATEGORYArraylongArrayMap = this.pointSizeSeriesNameToCATEGORYArraylongArrayMap.copy();
        __s__.groupSeriesNameTointMap = this.groupSeriesNameTointMap.copy();
        __s__.lineStyleSeriesNameToLineStyleMap = this.lineStyleSeriesNameToLineStyleMap.copy();
        __s__.pointSizeSeriesNameToMapMap = this.pointSizeSeriesNameToMapMap.copy();
        __s__.pointSizeSeriesNameToCATEGORYArrayintArrayMap = this.pointSizeSeriesNameToCATEGORYArrayintArrayMap.copy();
        __s__.pointColorIntegerSeriesNameToMapMap = this.pointColorIntegerSeriesNameToMapMap.copy();
        __s__.pointSizeSeriesNameToNumberMap = this.pointSizeSeriesNameToNumberMap.copy();
        __s__.pointSizeSeriesNameToCATEGORYArrayNUMBERArrayMap = this.pointSizeSeriesNameToCATEGORYArrayNUMBERArrayMap.copy();
        __s__.pointColorSeriesNameTointMap = this.pointColorSeriesNameTointMap.copy();
        __s__.pointColorSeriesNameToComparableintMap = this.pointColorSeriesNameToComparableintMap.copy();
        __s__.pointShapeSeriesNameToStringMap = this.pointShapeSeriesNameToStringMap.copy();
        __s__.pointSizeSeriesNameToSelectableDataSetStringStringMap = this.pointSizeSeriesNameToSelectableDataSetStringStringMap.copy();
        return __s__;
    }

    private static class NonserializableCategoryDataSeriesPartitionedTable
    extends AbstractTableBasedCategoryDataSeries
    implements CategoryErrorBarDataSeriesInternal,
    CategoryTableDataSeriesInternal {
        private final Table table;
        private final String categoryCol;
        private final String values;
        private final String yLow;
        private final String yHigh;
        private final CategoryErrorBarDataSeriesKernel kernel;

        <T extends Comparable> NonserializableCategoryDataSeriesPartitionedTable(AxesImpl axes, Comparable name, BaseTable table, String categoryCol, String values, String yLow, String yHigh) {
            super(axes, -1, name);
            ArgumentValidations.assertNotNull(axes, "axes", this.getPlotInfo());
            ArgumentValidations.assertNotNull(table, "table", this.getPlotInfo());
            ArgumentValidations.assertIsNumericOrTimeOrCharOrComparableInstance((Table)table, categoryCol, "Invalid data type in category column: column=" + categoryCol, this.getPlotInfo());
            ArgumentValidations.assertIsNumericOrTime((Table)table, values, "Invalid data type in data column: column=" + values, this.getPlotInfo());
            ArgumentValidations.assertIsNumericOrTime((Table)table, yLow, "Invalid data type in data column: column=" + yLow, this.getPlotInfo());
            ArgumentValidations.assertIsNumericOrTime((Table)table, yHigh, "Invalid data type in data column: column=" + yHigh, this.getPlotInfo());
            this.table = table;
            this.categoryCol = categoryCol;
            this.values = values;
            this.yLow = yLow;
            this.yHigh = yHigh;
            this.kernel = new CategoryErrorBarDataSeriesKernel(categoryCol, values, yLow, yHigh, this.getPlotInfo());
        }

        @Override
        public NonserializableCategoryDataSeriesPartitionedTable copy(AxesImpl axes) {
            throw new UnsupportedOperationException("Copy constructors are not supported on NonserializableCategoryDataSeriesPartitionedTable");
        }

        @Override
        public int size() {
            return this.kernel.size();
        }

        @Override
        public Collection<Comparable> categories() {
            return this.kernel.categories();
        }

        @Override
        public Number getValue(Comparable category) {
            return this.kernel.getValue(category);
        }

        @Override
        public long getCategoryLocation(Comparable category) {
            return this.kernel.getCategoryKey(category);
        }

        @Override
        public Number getStartY(Comparable category) {
            return this.kernel.getStartY(category);
        }

        @Override
        public Number getEndY(Comparable category) {
            return this.kernel.getEndY(category);
        }

        @Override
        protected Table getTable() {
            return this.table;
        }

        @Override
        protected String getCategoryCol() {
            return this.categoryCol;
        }

        @Override
        protected String getValueCol() {
            return this.values;
        }

        private void writeObject(ObjectOutputStream stream) {
            throw new UnsupportedOperationException("This can not be serialized!");
        }
    }
}

