/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.multiseries;

import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.BaseTable;
import io.deephaven.gui.color.Paint;
import io.deephaven.gui.shape.Shape;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.LineStyle;
import io.deephaven.plot.datasets.DynamicSeriesNamer;
import io.deephaven.plot.datasets.data.IndexableData;
import io.deephaven.plot.datasets.multiseries.AbstractPartitionedTableHandleMultiSeries;
import io.deephaven.plot.datasets.ohlc.OHLCDataSeriesInternal;
import io.deephaven.plot.datasets.ohlc.OHLCDataSeriesTableArray;
import io.deephaven.plot.filters.SelectableDataSet;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.PlotUtils;
import io.deephaven.plot.util.tables.TableBackedPartitionedTableHandle;
import io.deephaven.plot.util.tables.TableHandle;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Consumer;

public class MultiOHLCSeries
extends AbstractPartitionedTableHandleMultiSeries<OHLCDataSeriesInternal> {
    private static final long serialVersionUID = 4796788793334213344L;
    private final String timeCol;
    private final String openCol;
    private final String highCol;
    private final String lowCol;
    private final String closeCol;
    private PlotUtils.HashMapWithDefault<String, String> errorBarColorSeriesNameToStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Integer> errorBarColorSeriesNameTointMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Paint> errorBarColorSeriesNameToPaintMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Boolean> gradientVisibleSeriesNameTobooleanMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, String> lineColorSeriesNameToStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Integer> lineColorSeriesNameTointMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Paint> lineColorSeriesNameToPaintMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, LineStyle> lineStyleSeriesNameToLineStyleMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Boolean> linesVisibleSeriesNameToBooleanMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, int[]> pointColorSeriesNameTointArrayMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Paint[]> pointColorSeriesNameToPaintArrayMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Integer[]> pointColorSeriesNameToIntegerArrayMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, String[]> pointColorSeriesNameToStringArrayMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, String> pointColorSeriesNameToStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Integer> pointColorSeriesNameTointMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Paint> pointColorSeriesNameToPaintMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, IndexableData> pointColorSeriesNameToIndexableDataMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointColorSeriesNameToTableStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointColorSeriesNameToSelectableDataSetStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, IndexableData> pointColorIntegerSeriesNameToIndexableDataMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointLabelSeriesNameToObjectArrayMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object> pointLabelSeriesNameToObjectMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, IndexableData> pointLabelSeriesNameToIndexableDataMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointLabelSeriesNameToTableStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointLabelSeriesNameToSelectableDataSetStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, String> pointLabelFormatSeriesNameToStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Shape[]> pointShapeSeriesNameToShapeArrayMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, String[]> pointShapeSeriesNameToStringArrayMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, String> pointShapeSeriesNameToStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Shape> pointShapeSeriesNameToShapeMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, IndexableData> pointShapeSeriesNameToIndexableDataMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointShapeSeriesNameToTableStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointShapeSeriesNameToSelectableDataSetStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object> pointSizeSeriesNameToTArrayMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, double[]> pointSizeSeriesNameTodoubleArrayMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, int[]> pointSizeSeriesNameTointArrayMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, long[]> pointSizeSeriesNameTolongArrayMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Number> pointSizeSeriesNameToNumberMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, IndexableData> pointSizeSeriesNameToIndexableDataMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToTableStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToSelectableDataSetStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Boolean> pointsVisibleSeriesNameToBooleanMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, String> seriesColorSeriesNameToStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Integer> seriesColorSeriesNameTointMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, Paint> seriesColorSeriesNameToPaintMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, String> toolTipPatternSeriesNameToStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, String> xToolTipPatternSeriesNameToStringMap = new PlotUtils.HashMapWithDefault();
    private PlotUtils.HashMapWithDefault<String, String> yToolTipPatternSeriesNameToStringMap = new PlotUtils.HashMapWithDefault();

    public MultiOHLCSeries(AxesImpl axes, int id, Comparable name, TableBackedPartitionedTableHandle partitionedTableHandle, String timeCol, String openCol, String highCol, String lowCol, String closeCol, String[] byColumns) {
        super(axes, id, name, partitionedTableHandle, timeCol, null, byColumns);
        this.timeCol = timeCol;
        this.openCol = openCol;
        this.highCol = highCol;
        this.lowCol = lowCol;
        this.closeCol = closeCol;
        ArgumentValidations.assertIsTime(partitionedTableHandle.getTableDefinition(), timeCol, this.getPlotInfo());
        ArgumentValidations.assertIsNumeric(partitionedTableHandle.getTableDefinition(), openCol, this.getPlotInfo());
        ArgumentValidations.assertIsNumeric(partitionedTableHandle.getTableDefinition(), highCol, this.getPlotInfo());
        ArgumentValidations.assertIsNumeric(partitionedTableHandle.getTableDefinition(), lowCol, this.getPlotInfo());
        ArgumentValidations.assertIsNumeric(partitionedTableHandle.getTableDefinition(), closeCol, this.getPlotInfo());
    }

    private MultiOHLCSeries(MultiOHLCSeries series, AxesImpl axes) {
        super(series, axes);
        this.timeCol = series.timeCol;
        this.openCol = series.openCol;
        this.highCol = series.highCol;
        this.lowCol = series.lowCol;
        this.closeCol = series.closeCol;
    }

    @Override
    public OHLCDataSeriesInternal createSeries(String seriesName, BaseTable t, DynamicSeriesNamer seriesNamer) {
        seriesName = this.makeSeriesName(seriesName, seriesNamer);
        TableHandle tableHandle = new TableHandle((Table)t, this.timeCol, this.openCol, this.highCol, this.lowCol, this.closeCol);
        this.addTableHandle(tableHandle);
        return new OHLCDataSeriesTableArray(this.axes(), -1, (Comparable)((Object)seriesName), tableHandle, this.timeCol, this.openCol, this.highCol, this.lowCol, this.closeCol);
    }

    @Override
    public void initializeSeries(OHLCDataSeriesInternal series) {
        this.$$initializeSeries$$(series);
    }

    public PlotUtils.HashMapWithDefault<String, String> errorBarColorSeriesNameToStringMap() {
        return this.errorBarColorSeriesNameToStringMap;
    }

    @Override
    public MultiOHLCSeries errorBarColor(String errorBarColor, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.errorBarColorSeriesNameToStringMap.setDefault(errorBarColor);
        } else {
            this.errorBarColorSeriesNameToStringMap.put((String)this.namingFunction.apply(multiSeriesKey), errorBarColor);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Integer> errorBarColorSeriesNameTointMap() {
        return this.errorBarColorSeriesNameTointMap;
    }

    @Override
    public MultiOHLCSeries errorBarColor(int errorBarColor, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.errorBarColorSeriesNameTointMap.setDefault(errorBarColor);
        } else {
            this.errorBarColorSeriesNameTointMap.put((String)this.namingFunction.apply(multiSeriesKey), errorBarColor);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Paint> errorBarColorSeriesNameToPaintMap() {
        return this.errorBarColorSeriesNameToPaintMap;
    }

    @Override
    public MultiOHLCSeries errorBarColor(Paint errorBarColor, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.errorBarColorSeriesNameToPaintMap.setDefault(errorBarColor);
        } else {
            this.errorBarColorSeriesNameToPaintMap.put((String)this.namingFunction.apply(multiSeriesKey), errorBarColor);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Boolean> gradientVisibleSeriesNameTobooleanMap() {
        return this.gradientVisibleSeriesNameTobooleanMap;
    }

    @Override
    public MultiOHLCSeries gradientVisible(boolean gradientVisible, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.gradientVisibleSeriesNameTobooleanMap.setDefault(gradientVisible);
        } else {
            this.gradientVisibleSeriesNameTobooleanMap.put((String)this.namingFunction.apply(multiSeriesKey), gradientVisible);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, String> lineColorSeriesNameToStringMap() {
        return this.lineColorSeriesNameToStringMap;
    }

    @Override
    public MultiOHLCSeries lineColor(String color, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.lineColorSeriesNameToStringMap.setDefault(color);
        } else {
            this.lineColorSeriesNameToStringMap.put((String)this.namingFunction.apply(multiSeriesKey), color);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Integer> lineColorSeriesNameTointMap() {
        return this.lineColorSeriesNameTointMap;
    }

    @Override
    public MultiOHLCSeries lineColor(int color, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.lineColorSeriesNameTointMap.setDefault(color);
        } else {
            this.lineColorSeriesNameTointMap.put((String)this.namingFunction.apply(multiSeriesKey), color);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Paint> lineColorSeriesNameToPaintMap() {
        return this.lineColorSeriesNameToPaintMap;
    }

    @Override
    public MultiOHLCSeries lineColor(Paint color, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.lineColorSeriesNameToPaintMap.setDefault(color);
        } else {
            this.lineColorSeriesNameToPaintMap.put((String)this.namingFunction.apply(multiSeriesKey), color);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, LineStyle> lineStyleSeriesNameToLineStyleMap() {
        return this.lineStyleSeriesNameToLineStyleMap;
    }

    @Override
    public MultiOHLCSeries lineStyle(LineStyle lineStyle, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.lineStyleSeriesNameToLineStyleMap.setDefault(lineStyle);
        } else {
            this.lineStyleSeriesNameToLineStyleMap.put((String)this.namingFunction.apply(multiSeriesKey), lineStyle);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Boolean> linesVisibleSeriesNameToBooleanMap() {
        return this.linesVisibleSeriesNameToBooleanMap;
    }

    @Override
    public MultiOHLCSeries linesVisible(Boolean visible, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.linesVisibleSeriesNameToBooleanMap.setDefault(visible);
        } else {
            this.linesVisibleSeriesNameToBooleanMap.put((String)this.namingFunction.apply(multiSeriesKey), visible);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, int[]> pointColorSeriesNameTointArrayMap() {
        return this.pointColorSeriesNameTointArrayMap;
    }

    @Override
    public MultiOHLCSeries pointColor(int[] pointColors, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorSeriesNameTointArrayMap.setDefault(pointColors);
        } else {
            this.pointColorSeriesNameTointArrayMap.put((String)this.namingFunction.apply(multiSeriesKey), pointColors);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Paint[]> pointColorSeriesNameToPaintArrayMap() {
        return this.pointColorSeriesNameToPaintArrayMap;
    }

    @Override
    public MultiOHLCSeries pointColor(Paint[] pointColor, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorSeriesNameToPaintArrayMap.setDefault(pointColor);
        } else {
            this.pointColorSeriesNameToPaintArrayMap.put((String)this.namingFunction.apply(multiSeriesKey), pointColor);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Integer[]> pointColorSeriesNameToIntegerArrayMap() {
        return this.pointColorSeriesNameToIntegerArrayMap;
    }

    @Override
    public MultiOHLCSeries pointColor(Integer[] pointColors, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorSeriesNameToIntegerArrayMap.setDefault(pointColors);
        } else {
            this.pointColorSeriesNameToIntegerArrayMap.put((String)this.namingFunction.apply(multiSeriesKey), pointColors);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, String[]> pointColorSeriesNameToStringArrayMap() {
        return this.pointColorSeriesNameToStringArrayMap;
    }

    @Override
    public MultiOHLCSeries pointColor(String[] pointColors, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorSeriesNameToStringArrayMap.setDefault(pointColors);
        } else {
            this.pointColorSeriesNameToStringArrayMap.put((String)this.namingFunction.apply(multiSeriesKey), pointColors);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, String> pointColorSeriesNameToStringMap() {
        return this.pointColorSeriesNameToStringMap;
    }

    @Override
    public MultiOHLCSeries pointColor(String pointColor, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorSeriesNameToStringMap.setDefault(pointColor);
        } else {
            this.pointColorSeriesNameToStringMap.put((String)this.namingFunction.apply(multiSeriesKey), pointColor);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Integer> pointColorSeriesNameTointMap() {
        return this.pointColorSeriesNameTointMap;
    }

    @Override
    public MultiOHLCSeries pointColor(int pointColor, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorSeriesNameTointMap.setDefault(pointColor);
        } else {
            this.pointColorSeriesNameTointMap.put((String)this.namingFunction.apply(multiSeriesKey), pointColor);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Paint> pointColorSeriesNameToPaintMap() {
        return this.pointColorSeriesNameToPaintMap;
    }

    @Override
    public MultiOHLCSeries pointColor(Paint pointColor, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorSeriesNameToPaintMap.setDefault(pointColor);
        } else {
            this.pointColorSeriesNameToPaintMap.put((String)this.namingFunction.apply(multiSeriesKey), pointColor);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, IndexableData> pointColorSeriesNameToIndexableDataMap() {
        return this.pointColorSeriesNameToIndexableDataMap;
    }

    @Override
    public <T extends Paint> MultiOHLCSeries pointColor(IndexableData<T> pointColor, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorSeriesNameToIndexableDataMap.setDefault(pointColor);
        } else {
            this.pointColorSeriesNameToIndexableDataMap.put((String)this.namingFunction.apply(multiSeriesKey), pointColor);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointColorSeriesNameToTableStringMap() {
        return this.pointColorSeriesNameToTableStringMap;
    }

    @Override
    public MultiOHLCSeries pointColor(Table t, String pointColors, Object ... multiSeriesKey) {
        TableHandle tHandle = new TableHandle(t, pointColors);
        this.addTableHandle(tHandle);
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorSeriesNameToTableStringMap.setDefault(new Object[]{tHandle, pointColors});
        } else {
            this.pointColorSeriesNameToTableStringMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{tHandle, pointColors});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointColorSeriesNameToSelectableDataSetStringMap() {
        return this.pointColorSeriesNameToSelectableDataSetStringMap;
    }

    @Override
    public MultiOHLCSeries pointColor(SelectableDataSet sds, String pointColors, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorSeriesNameToSelectableDataSetStringMap.setDefault(new Object[]{sds, pointColors});
        } else {
            this.pointColorSeriesNameToSelectableDataSetStringMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{sds, pointColors});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, IndexableData> pointColorIntegerSeriesNameToIndexableDataMap() {
        return this.pointColorIntegerSeriesNameToIndexableDataMap;
    }

    @Override
    public MultiOHLCSeries pointColorInteger(IndexableData<Integer> colors, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointColorIntegerSeriesNameToIndexableDataMap.setDefault(colors);
        } else {
            this.pointColorIntegerSeriesNameToIndexableDataMap.put((String)this.namingFunction.apply(multiSeriesKey), colors);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointLabelSeriesNameToObjectArrayMap() {
        return this.pointLabelSeriesNameToObjectArrayMap;
    }

    @Override
    public MultiOHLCSeries pointLabel(Object[] pointLabels, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointLabelSeriesNameToObjectArrayMap.setDefault(new Object[]{pointLabels});
        } else {
            this.pointLabelSeriesNameToObjectArrayMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{pointLabels});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object> pointLabelSeriesNameToObjectMap() {
        return this.pointLabelSeriesNameToObjectMap;
    }

    @Override
    public MultiOHLCSeries pointLabel(Object pointLabel, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointLabelSeriesNameToObjectMap.setDefault(pointLabel);
        } else {
            this.pointLabelSeriesNameToObjectMap.put((String)this.namingFunction.apply(multiSeriesKey), pointLabel);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, IndexableData> pointLabelSeriesNameToIndexableDataMap() {
        return this.pointLabelSeriesNameToIndexableDataMap;
    }

    @Override
    public MultiOHLCSeries pointLabel(IndexableData<?> pointLabels, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointLabelSeriesNameToIndexableDataMap.setDefault(pointLabels);
        } else {
            this.pointLabelSeriesNameToIndexableDataMap.put((String)this.namingFunction.apply(multiSeriesKey), pointLabels);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointLabelSeriesNameToTableStringMap() {
        return this.pointLabelSeriesNameToTableStringMap;
    }

    @Override
    public MultiOHLCSeries pointLabel(Table t, String pointLabel, Object ... multiSeriesKey) {
        TableHandle tHandle = new TableHandle(t, pointLabel);
        this.addTableHandle(tHandle);
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointLabelSeriesNameToTableStringMap.setDefault(new Object[]{tHandle, pointLabel});
        } else {
            this.pointLabelSeriesNameToTableStringMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{tHandle, pointLabel});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointLabelSeriesNameToSelectableDataSetStringMap() {
        return this.pointLabelSeriesNameToSelectableDataSetStringMap;
    }

    @Override
    public MultiOHLCSeries pointLabel(SelectableDataSet sds, String pointLabel, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointLabelSeriesNameToSelectableDataSetStringMap.setDefault(new Object[]{sds, pointLabel});
        } else {
            this.pointLabelSeriesNameToSelectableDataSetStringMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{sds, pointLabel});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, String> pointLabelFormatSeriesNameToStringMap() {
        return this.pointLabelFormatSeriesNameToStringMap;
    }

    @Override
    public MultiOHLCSeries pointLabelFormat(String pointLabelFormat, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointLabelFormatSeriesNameToStringMap.setDefault(pointLabelFormat);
        } else {
            this.pointLabelFormatSeriesNameToStringMap.put((String)this.namingFunction.apply(multiSeriesKey), pointLabelFormat);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Shape[]> pointShapeSeriesNameToShapeArrayMap() {
        return this.pointShapeSeriesNameToShapeArrayMap;
    }

    @Override
    public MultiOHLCSeries pointShape(Shape[] pointShapes, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointShapeSeriesNameToShapeArrayMap.setDefault(pointShapes);
        } else {
            this.pointShapeSeriesNameToShapeArrayMap.put((String)this.namingFunction.apply(multiSeriesKey), pointShapes);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, String[]> pointShapeSeriesNameToStringArrayMap() {
        return this.pointShapeSeriesNameToStringArrayMap;
    }

    @Override
    public MultiOHLCSeries pointShape(String[] pointShapes, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointShapeSeriesNameToStringArrayMap.setDefault(pointShapes);
        } else {
            this.pointShapeSeriesNameToStringArrayMap.put((String)this.namingFunction.apply(multiSeriesKey), pointShapes);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, String> pointShapeSeriesNameToStringMap() {
        return this.pointShapeSeriesNameToStringMap;
    }

    @Override
    public MultiOHLCSeries pointShape(String pointShape, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointShapeSeriesNameToStringMap.setDefault(pointShape);
        } else {
            this.pointShapeSeriesNameToStringMap.put((String)this.namingFunction.apply(multiSeriesKey), pointShape);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Shape> pointShapeSeriesNameToShapeMap() {
        return this.pointShapeSeriesNameToShapeMap;
    }

    @Override
    public MultiOHLCSeries pointShape(Shape pointShape, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointShapeSeriesNameToShapeMap.setDefault(pointShape);
        } else {
            this.pointShapeSeriesNameToShapeMap.put((String)this.namingFunction.apply(multiSeriesKey), pointShape);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, IndexableData> pointShapeSeriesNameToIndexableDataMap() {
        return this.pointShapeSeriesNameToIndexableDataMap;
    }

    @Override
    public MultiOHLCSeries pointShape(IndexableData<String> pointShapes, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointShapeSeriesNameToIndexableDataMap.setDefault(pointShapes);
        } else {
            this.pointShapeSeriesNameToIndexableDataMap.put((String)this.namingFunction.apply(multiSeriesKey), pointShapes);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointShapeSeriesNameToTableStringMap() {
        return this.pointShapeSeriesNameToTableStringMap;
    }

    @Override
    public MultiOHLCSeries pointShape(Table t, String pointShape, Object ... multiSeriesKey) {
        TableHandle tHandle = new TableHandle(t, pointShape);
        this.addTableHandle(tHandle);
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointShapeSeriesNameToTableStringMap.setDefault(new Object[]{tHandle, pointShape});
        } else {
            this.pointShapeSeriesNameToTableStringMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{tHandle, pointShape});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointShapeSeriesNameToSelectableDataSetStringMap() {
        return this.pointShapeSeriesNameToSelectableDataSetStringMap;
    }

    @Override
    public MultiOHLCSeries pointShape(SelectableDataSet sds, String pointShape, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointShapeSeriesNameToSelectableDataSetStringMap.setDefault(new Object[]{sds, pointShape});
        } else {
            this.pointShapeSeriesNameToSelectableDataSetStringMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{sds, pointShape});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object> pointSizeSeriesNameToTArrayMap() {
        return this.pointSizeSeriesNameToTArrayMap;
    }

    @Override
    public <T extends Number> MultiOHLCSeries pointSize(T[] pointSizes, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointSizeSeriesNameToTArrayMap.setDefault(pointSizes);
        } else {
            this.pointSizeSeriesNameToTArrayMap.put((String)this.namingFunction.apply(multiSeriesKey), pointSizes);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, double[]> pointSizeSeriesNameTodoubleArrayMap() {
        return this.pointSizeSeriesNameTodoubleArrayMap;
    }

    @Override
    public MultiOHLCSeries pointSize(double[] pointSizes, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointSizeSeriesNameTodoubleArrayMap.setDefault(pointSizes);
        } else {
            this.pointSizeSeriesNameTodoubleArrayMap.put((String)this.namingFunction.apply(multiSeriesKey), pointSizes);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, int[]> pointSizeSeriesNameTointArrayMap() {
        return this.pointSizeSeriesNameTointArrayMap;
    }

    @Override
    public MultiOHLCSeries pointSize(int[] pointSizes, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointSizeSeriesNameTointArrayMap.setDefault(pointSizes);
        } else {
            this.pointSizeSeriesNameTointArrayMap.put((String)this.namingFunction.apply(multiSeriesKey), pointSizes);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, long[]> pointSizeSeriesNameTolongArrayMap() {
        return this.pointSizeSeriesNameTolongArrayMap;
    }

    @Override
    public MultiOHLCSeries pointSize(long[] pointSizes, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointSizeSeriesNameTolongArrayMap.setDefault(pointSizes);
        } else {
            this.pointSizeSeriesNameTolongArrayMap.put((String)this.namingFunction.apply(multiSeriesKey), pointSizes);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Number> pointSizeSeriesNameToNumberMap() {
        return this.pointSizeSeriesNameToNumberMap;
    }

    @Override
    public MultiOHLCSeries pointSize(Number pointSize, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointSizeSeriesNameToNumberMap.setDefault(pointSize);
        } else {
            this.pointSizeSeriesNameToNumberMap.put((String)this.namingFunction.apply(multiSeriesKey), pointSize);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, IndexableData> pointSizeSeriesNameToIndexableDataMap() {
        return this.pointSizeSeriesNameToIndexableDataMap;
    }

    @Override
    public MultiOHLCSeries pointSize(IndexableData<Double> pointSizes, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointSizeSeriesNameToIndexableDataMap.setDefault(pointSizes);
        } else {
            this.pointSizeSeriesNameToIndexableDataMap.put((String)this.namingFunction.apply(multiSeriesKey), pointSizes);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToTableStringMap() {
        return this.pointSizeSeriesNameToTableStringMap;
    }

    @Override
    public MultiOHLCSeries pointSize(Table t, String pointSizes, Object ... multiSeriesKey) {
        TableHandle tHandle = new TableHandle(t, pointSizes);
        this.addTableHandle(tHandle);
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointSizeSeriesNameToTableStringMap.setDefault(new Object[]{tHandle, pointSizes});
        } else {
            this.pointSizeSeriesNameToTableStringMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{tHandle, pointSizes});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Object[]> pointSizeSeriesNameToSelectableDataSetStringMap() {
        return this.pointSizeSeriesNameToSelectableDataSetStringMap;
    }

    @Override
    public MultiOHLCSeries pointSize(SelectableDataSet sds, String pointSize, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointSizeSeriesNameToSelectableDataSetStringMap.setDefault(new Object[]{sds, pointSize});
        } else {
            this.pointSizeSeriesNameToSelectableDataSetStringMap.put((String)this.namingFunction.apply(multiSeriesKey), new Object[]{sds, pointSize});
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Boolean> pointsVisibleSeriesNameToBooleanMap() {
        return this.pointsVisibleSeriesNameToBooleanMap;
    }

    @Override
    public MultiOHLCSeries pointsVisible(Boolean visible, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.pointsVisibleSeriesNameToBooleanMap.setDefault(visible);
        } else {
            this.pointsVisibleSeriesNameToBooleanMap.put((String)this.namingFunction.apply(multiSeriesKey), visible);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, String> seriesColorSeriesNameToStringMap() {
        return this.seriesColorSeriesNameToStringMap;
    }

    @Override
    public MultiOHLCSeries seriesColor(String color, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.seriesColorSeriesNameToStringMap.setDefault(color);
        } else {
            this.seriesColorSeriesNameToStringMap.put((String)this.namingFunction.apply(multiSeriesKey), color);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Integer> seriesColorSeriesNameTointMap() {
        return this.seriesColorSeriesNameTointMap;
    }

    @Override
    public MultiOHLCSeries seriesColor(int color, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.seriesColorSeriesNameTointMap.setDefault(color);
        } else {
            this.seriesColorSeriesNameTointMap.put((String)this.namingFunction.apply(multiSeriesKey), color);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, Paint> seriesColorSeriesNameToPaintMap() {
        return this.seriesColorSeriesNameToPaintMap;
    }

    @Override
    public MultiOHLCSeries seriesColor(Paint color, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.seriesColorSeriesNameToPaintMap.setDefault(color);
        } else {
            this.seriesColorSeriesNameToPaintMap.put((String)this.namingFunction.apply(multiSeriesKey), color);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, String> toolTipPatternSeriesNameToStringMap() {
        return this.toolTipPatternSeriesNameToStringMap;
    }

    @Override
    public MultiOHLCSeries toolTipPattern(String toolTipPattern, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.toolTipPatternSeriesNameToStringMap.setDefault(toolTipPattern);
        } else {
            this.toolTipPatternSeriesNameToStringMap.put((String)this.namingFunction.apply(multiSeriesKey), toolTipPattern);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, String> xToolTipPatternSeriesNameToStringMap() {
        return this.xToolTipPatternSeriesNameToStringMap;
    }

    @Override
    public MultiOHLCSeries xToolTipPattern(String xToolTipPattern, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.xToolTipPatternSeriesNameToStringMap.setDefault(xToolTipPattern);
        } else {
            this.xToolTipPatternSeriesNameToStringMap.put((String)this.namingFunction.apply(multiSeriesKey), xToolTipPattern);
        }
        return this;
    }

    public PlotUtils.HashMapWithDefault<String, String> yToolTipPatternSeriesNameToStringMap() {
        return this.yToolTipPatternSeriesNameToStringMap;
    }

    @Override
    public MultiOHLCSeries yToolTipPattern(String yToolTipPattern, Object ... multiSeriesKey) {
        if (multiSeriesKey == null || multiSeriesKey.length == 0) {
            this.yToolTipPatternSeriesNameToStringMap.setDefault(yToolTipPattern);
        } else {
            this.yToolTipPatternSeriesNameToStringMap.put((String)this.namingFunction.apply(multiSeriesKey), yToolTipPattern);
        }
        return this;
    }

    private <T extends Paint, T0 extends Number> void $$initializeSeries$$(OHLCDataSeriesInternal series) {
        String name = series.name().toString();
        Consumer<Object[]> consumer0 = series::pointLabel;
        this.pointLabelSeriesNameToObjectArrayMap.runIfKeyExistsCast(consumer0, name);
        Consumer<String> consumer1 = series::pointLabelFormat;
        this.pointLabelFormatSeriesNameToStringMap.runIfKeyExistsCast(consumer1, name);
        Consumer<IndexableData> consumer2 = series::pointShape;
        this.pointShapeSeriesNameToIndexableDataMap.runIfKeyExistsCast(consumer2, name);
        Consumer<String[]> consumer3 = series::pointShape;
        this.pointShapeSeriesNameToStringArrayMap.runIfKeyExistsCast(consumer3, name);
        Object[] objectArray = this.pointColorSeriesNameToTableStringMap.get(name);
        if (objectArray != null) {
            series.pointColor(((TableHandle)objectArray[0]).getTable(), (String)objectArray[1]);
        }
        if ((objectArray = this.pointSizeSeriesNameToSelectableDataSetStringMap.get(name)) != null) {
            series.pointSize((SelectableDataSet)objectArray[0], (String)objectArray[1]);
        }
        Consumer<Boolean> consumer4 = series::pointsVisible;
        this.pointsVisibleSeriesNameToBooleanMap.runIfKeyExistsCast(consumer4, name);
        Consumer<IndexableData> consumer5 = series::pointColor;
        this.pointColorSeriesNameToIndexableDataMap.runIfKeyExistsCast(consumer5, name);
        objectArray = this.pointShapeSeriesNameToSelectableDataSetStringMap.get(name);
        if (objectArray != null) {
            series.pointShape((SelectableDataSet)objectArray[0], (String)objectArray[1]);
        }
        if ((objectArray = this.pointLabelSeriesNameToTableStringMap.get(name)) != null) {
            series.pointLabel(((TableHandle)objectArray[0]).getTable(), (String)objectArray[1]);
        }
        Consumer<String> consumer6 = series::pointColor;
        this.pointColorSeriesNameToStringMap.runIfKeyExistsCast(consumer6, name);
        Consumer<Shape> consumer7 = series::pointShape;
        this.pointShapeSeriesNameToShapeMap.runIfKeyExistsCast(consumer7, name);
        Consumer<Integer> consumer8 = series::lineColor;
        this.lineColorSeriesNameTointMap.runIfKeyExistsCast(consumer8, name);
        Consumer<Boolean> consumer9 = series::linesVisible;
        this.linesVisibleSeriesNameToBooleanMap.runIfKeyExistsCast(consumer9, name);
        objectArray = this.pointLabelSeriesNameToSelectableDataSetStringMap.get(name);
        if (objectArray != null) {
            series.pointLabel((SelectableDataSet)objectArray[0], (String)objectArray[1]);
        }
        Consumer<String> consumer10 = series::lineColor;
        this.lineColorSeriesNameToStringMap.runIfKeyExistsCast(consumer10, name);
        Consumer<Paint> consumer11 = series::seriesColor;
        this.seriesColorSeriesNameToPaintMap.runIfKeyExistsCast(consumer11, name);
        Consumer<long[]> consumer12 = series::pointSize;
        this.pointSizeSeriesNameTolongArrayMap.runIfKeyExistsCast(consumer12, name);
        Consumer<Shape[]> consumer13 = series::pointShape;
        this.pointShapeSeriesNameToShapeArrayMap.runIfKeyExistsCast(consumer13, name);
        Consumer<String> consumer14 = series::yToolTipPattern;
        this.yToolTipPatternSeriesNameToStringMap.runIfKeyExistsCast(consumer14, name);
        Consumer<Integer> consumer15 = series::seriesColor;
        this.seriesColorSeriesNameTointMap.runIfKeyExistsCast(consumer15, name);
        Consumer<int[]> consumer16 = series::pointColor;
        this.pointColorSeriesNameTointArrayMap.runIfKeyExistsCast(consumer16, name);
        Consumer<Object> consumer17 = series::pointLabel;
        this.pointLabelSeriesNameToObjectMap.runIfKeyExistsCast(consumer17, name);
        Consumer<Paint> consumer18 = series::errorBarColor;
        this.errorBarColorSeriesNameToPaintMap.runIfKeyExistsCast(consumer18, name);
        objectArray = this.pointColorSeriesNameToSelectableDataSetStringMap.get(name);
        if (objectArray != null) {
            series.pointColor((SelectableDataSet)objectArray[0], (String)objectArray[1]);
        }
        Consumer<Paint> consumer19 = series::lineColor;
        this.lineColorSeriesNameToPaintMap.runIfKeyExistsCast(consumer19, name);
        Consumer<String> consumer20 = series::seriesColor;
        this.seriesColorSeriesNameToStringMap.runIfKeyExistsCast(consumer20, name);
        Consumer<Integer[]> consumer21 = series::pointColor;
        this.pointColorSeriesNameToIntegerArrayMap.runIfKeyExistsCast(consumer21, name);
        Consumer<LineStyle> consumer22 = series::lineStyle;
        this.lineStyleSeriesNameToLineStyleMap.runIfKeyExistsCast(consumer22, name);
        Consumer<double[]> consumer23 = series::pointSize;
        this.pointSizeSeriesNameTodoubleArrayMap.runIfKeyExistsCast(consumer23, name);
        Consumer<Boolean> consumer24 = series::gradientVisible;
        this.gradientVisibleSeriesNameTobooleanMap.runIfKeyExistsCast(consumer24, name);
        Consumer<Paint> consumer25 = series::pointColor;
        this.pointColorSeriesNameToPaintMap.runIfKeyExistsCast(consumer25, name);
        Consumer<IndexableData> consumer26 = series::pointColorInteger;
        this.pointColorIntegerSeriesNameToIndexableDataMap.runIfKeyExistsCast(consumer26, name);
        Consumer<int[]> consumer27 = series::pointSize;
        this.pointSizeSeriesNameTointArrayMap.runIfKeyExistsCast(consumer27, name);
        Consumer<String[]> consumer28 = series::pointColor;
        this.pointColorSeriesNameToStringArrayMap.runIfKeyExistsCast(consumer28, name);
        Consumer<Number[]> consumer29 = (Consumer<Number[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, pointSize(java.lang.Number[] ), ([Ljava/lang/Number;)V)((OHLCDataSeriesInternal)series);
        this.pointSizeSeriesNameToTArrayMap.runIfKeyExistsCast(consumer29, name);
        Consumer<IndexableData> consumer30 = series::pointLabel;
        this.pointLabelSeriesNameToIndexableDataMap.runIfKeyExistsCast(consumer30, name);
        objectArray = this.pointShapeSeriesNameToTableStringMap.get(name);
        if (objectArray != null) {
            series.pointShape(((TableHandle)objectArray[0]).getTable(), (String)objectArray[1]);
        }
        Consumer<Number> consumer31 = series::pointSize;
        this.pointSizeSeriesNameToNumberMap.runIfKeyExistsCast(consumer31, name);
        Consumer<String> consumer32 = series::errorBarColor;
        this.errorBarColorSeriesNameToStringMap.runIfKeyExistsCast(consumer32, name);
        Consumer<Integer> consumer33 = series::pointColor;
        this.pointColorSeriesNameTointMap.runIfKeyExistsCast(consumer33, name);
        Consumer<IndexableData> consumer34 = series::pointSize;
        this.pointSizeSeriesNameToIndexableDataMap.runIfKeyExistsCast(consumer34, name);
        Consumer<String> consumer35 = series::xToolTipPattern;
        this.xToolTipPatternSeriesNameToStringMap.runIfKeyExistsCast(consumer35, name);
        Consumer<Integer> consumer36 = series::errorBarColor;
        this.errorBarColorSeriesNameTointMap.runIfKeyExistsCast(consumer36, name);
        Consumer<Paint[]> consumer37 = series::pointColor;
        this.pointColorSeriesNameToPaintArrayMap.runIfKeyExistsCast(consumer37, name);
        objectArray = this.pointSizeSeriesNameToTableStringMap.get(name);
        if (objectArray != null) {
            series.pointSize(((TableHandle)objectArray[0]).getTable(), (String)objectArray[1]);
        }
        Consumer<String> consumer38 = series::pointShape;
        this.pointShapeSeriesNameToStringMap.runIfKeyExistsCast(consumer38, name);
        Consumer<String> consumer39 = series::toolTipPattern;
        this.toolTipPatternSeriesNameToStringMap.runIfKeyExistsCast(consumer39, name);
    }

    @Override
    public MultiOHLCSeries copy(AxesImpl axes) {
        MultiOHLCSeries __s__ = new MultiOHLCSeries(this, axes);
        __s__.pointLabelSeriesNameToObjectArrayMap = this.pointLabelSeriesNameToObjectArrayMap.copy();
        __s__.pointLabelFormatSeriesNameToStringMap = this.pointLabelFormatSeriesNameToStringMap.copy();
        __s__.pointShapeSeriesNameToIndexableDataMap = this.pointShapeSeriesNameToIndexableDataMap.copy();
        __s__.pointShapeSeriesNameToStringArrayMap = this.pointShapeSeriesNameToStringArrayMap.copy();
        __s__.pointColorSeriesNameToTableStringMap = this.pointColorSeriesNameToTableStringMap.copy();
        __s__.pointSizeSeriesNameToSelectableDataSetStringMap = this.pointSizeSeriesNameToSelectableDataSetStringMap.copy();
        __s__.pointsVisibleSeriesNameToBooleanMap = this.pointsVisibleSeriesNameToBooleanMap.copy();
        __s__.pointColorSeriesNameToIndexableDataMap = this.pointColorSeriesNameToIndexableDataMap.copy();
        __s__.pointShapeSeriesNameToSelectableDataSetStringMap = this.pointShapeSeriesNameToSelectableDataSetStringMap.copy();
        __s__.pointLabelSeriesNameToTableStringMap = this.pointLabelSeriesNameToTableStringMap.copy();
        __s__.pointColorSeriesNameToStringMap = this.pointColorSeriesNameToStringMap.copy();
        __s__.pointShapeSeriesNameToShapeMap = this.pointShapeSeriesNameToShapeMap.copy();
        __s__.lineColorSeriesNameTointMap = this.lineColorSeriesNameTointMap.copy();
        __s__.linesVisibleSeriesNameToBooleanMap = this.linesVisibleSeriesNameToBooleanMap.copy();
        __s__.pointLabelSeriesNameToSelectableDataSetStringMap = this.pointLabelSeriesNameToSelectableDataSetStringMap.copy();
        __s__.lineColorSeriesNameToStringMap = this.lineColorSeriesNameToStringMap.copy();
        __s__.seriesColorSeriesNameToPaintMap = this.seriesColorSeriesNameToPaintMap.copy();
        __s__.pointSizeSeriesNameTolongArrayMap = this.pointSizeSeriesNameTolongArrayMap.copy();
        __s__.pointShapeSeriesNameToShapeArrayMap = this.pointShapeSeriesNameToShapeArrayMap.copy();
        __s__.yToolTipPatternSeriesNameToStringMap = this.yToolTipPatternSeriesNameToStringMap.copy();
        __s__.seriesColorSeriesNameTointMap = this.seriesColorSeriesNameTointMap.copy();
        __s__.pointColorSeriesNameTointArrayMap = this.pointColorSeriesNameTointArrayMap.copy();
        __s__.pointLabelSeriesNameToObjectMap = this.pointLabelSeriesNameToObjectMap.copy();
        __s__.errorBarColorSeriesNameToPaintMap = this.errorBarColorSeriesNameToPaintMap.copy();
        __s__.pointColorSeriesNameToSelectableDataSetStringMap = this.pointColorSeriesNameToSelectableDataSetStringMap.copy();
        __s__.lineColorSeriesNameToPaintMap = this.lineColorSeriesNameToPaintMap.copy();
        __s__.seriesColorSeriesNameToStringMap = this.seriesColorSeriesNameToStringMap.copy();
        __s__.pointColorSeriesNameToIntegerArrayMap = this.pointColorSeriesNameToIntegerArrayMap.copy();
        __s__.lineStyleSeriesNameToLineStyleMap = this.lineStyleSeriesNameToLineStyleMap.copy();
        __s__.pointSizeSeriesNameTodoubleArrayMap = this.pointSizeSeriesNameTodoubleArrayMap.copy();
        __s__.gradientVisibleSeriesNameTobooleanMap = this.gradientVisibleSeriesNameTobooleanMap.copy();
        __s__.pointColorSeriesNameToPaintMap = this.pointColorSeriesNameToPaintMap.copy();
        __s__.pointColorIntegerSeriesNameToIndexableDataMap = this.pointColorIntegerSeriesNameToIndexableDataMap.copy();
        __s__.pointSizeSeriesNameTointArrayMap = this.pointSizeSeriesNameTointArrayMap.copy();
        __s__.pointColorSeriesNameToStringArrayMap = this.pointColorSeriesNameToStringArrayMap.copy();
        __s__.pointSizeSeriesNameToTArrayMap = this.pointSizeSeriesNameToTArrayMap.copy();
        __s__.pointLabelSeriesNameToIndexableDataMap = this.pointLabelSeriesNameToIndexableDataMap.copy();
        __s__.pointShapeSeriesNameToTableStringMap = this.pointShapeSeriesNameToTableStringMap.copy();
        __s__.pointSizeSeriesNameToNumberMap = this.pointSizeSeriesNameToNumberMap.copy();
        __s__.errorBarColorSeriesNameToStringMap = this.errorBarColorSeriesNameToStringMap.copy();
        __s__.pointColorSeriesNameTointMap = this.pointColorSeriesNameTointMap.copy();
        __s__.pointSizeSeriesNameToIndexableDataMap = this.pointSizeSeriesNameToIndexableDataMap.copy();
        __s__.xToolTipPatternSeriesNameToStringMap = this.xToolTipPatternSeriesNameToStringMap.copy();
        __s__.errorBarColorSeriesNameTointMap = this.errorBarColorSeriesNameTointMap.copy();
        __s__.pointColorSeriesNameToPaintArrayMap = this.pointColorSeriesNameToPaintArrayMap.copy();
        __s__.pointSizeSeriesNameToTableStringMap = this.pointSizeSeriesNameToTableStringMap.copy();
        __s__.pointShapeSeriesNameToStringMap = this.pointShapeSeriesNameToStringMap.copy();
        __s__.toolTipPatternSeriesNameToStringMap = this.toolTipPatternSeriesNameToStringMap.copy();
        return __s__;
    }
}

