/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.ohlc;

import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.datasets.data.IndexableNumericData;
import io.deephaven.plot.datasets.ohlc.OHLCDataSeriesInternal;
import io.deephaven.plot.datasets.xy.AbstractXYDataSeries;
import io.deephaven.plot.util.ArgumentValidations;

public class OHLCDataSeriesArray
extends AbstractXYDataSeries
implements OHLCDataSeriesInternal {
    private static final long serialVersionUID = -8864867700289144828L;
    private final IndexableNumericData time;
    private final IndexableNumericData open;
    private final IndexableNumericData high;
    private final IndexableNumericData low;
    private final IndexableNumericData close;

    public OHLCDataSeriesArray(AxesImpl axes, int id, Comparable name, IndexableNumericData time, IndexableNumericData open, IndexableNumericData high, IndexableNumericData low, IndexableNumericData close) {
        this(axes, id, name, time, open, high, low, close, null);
    }

    public OHLCDataSeriesArray(AxesImpl axes, int id, Comparable name, IndexableNumericData time, IndexableNumericData open, IndexableNumericData high, IndexableNumericData low, IndexableNumericData close, AbstractXYDataSeries series) {
        super(axes, id, name, series);
        ArgumentValidations.assertNotNull(time, "Time", this.getPlotInfo());
        ArgumentValidations.assertNotNull(open, "Open", this.getPlotInfo());
        ArgumentValidations.assertNotNull(high, "High", this.getPlotInfo());
        ArgumentValidations.assertNotNull(low, "Low", this.getPlotInfo());
        ArgumentValidations.assertNotNull(close, "Close", this.getPlotInfo());
        this.time = time;
        this.open = open;
        this.high = high;
        this.low = low;
        this.close = close;
    }

    protected OHLCDataSeriesArray(OHLCDataSeriesArray series, AxesImpl axes) {
        super(series, axes);
        this.time = series.time;
        this.open = series.open;
        this.high = series.high;
        this.low = series.low;
        this.close = series.close;
    }

    @Override
    public OHLCDataSeriesArray copy(AxesImpl axes) {
        return new OHLCDataSeriesArray(this, axes);
    }

    @Override
    public double getOpen(int item) {
        return this.open.get(item);
    }

    @Override
    public double getHigh(int item) {
        return this.high.get(item);
    }

    @Override
    public double getLow(int item) {
        return this.low.get(item);
    }

    @Override
    public double getClose(int item) {
        return this.close.get(item);
    }

    @Override
    public int size() {
        return this.time.size();
    }

    @Override
    public double getX(int item) {
        return this.time.get(item);
    }

    @Override
    public double getY(int item) {
        return this.close.get(item);
    }

    public IndexableNumericData getTime() {
        return this.time;
    }

    public IndexableNumericData getOpen() {
        return this.open;
    }

    public IndexableNumericData getHigh() {
        return this.high;
    }

    public IndexableNumericData getLow() {
        return this.low;
    }

    public IndexableNumericData getClose() {
        return this.close;
    }
}

