/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.ohlc;

import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.TableSnapshotSeries;
import io.deephaven.plot.datasets.data.IndexableNumericDataTable;
import io.deephaven.plot.datasets.ohlc.OHLCDataSeriesArray;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.TableHandle;
import org.jetbrains.annotations.NotNull;

public class OHLCDataSeriesTableArray
extends OHLCDataSeriesArray
implements TableSnapshotSeries {
    private final TableHandle tableHandle;
    private final String timeCol;
    private final String openCol;
    private final String highCol;
    private final String lowCol;
    private final String closeCol;

    public OHLCDataSeriesTableArray(AxesImpl axes, int id, Comparable name, @NotNull TableHandle th, String timeCol, String openCol, String highCol, String lowCol, String closeCol) {
        super(axes, id, name, new IndexableNumericDataTable(th, timeCol, new PlotInfo(axes, name)), new IndexableNumericDataTable(th, openCol, new PlotInfo(axes, name)), new IndexableNumericDataTable(th, highCol, new PlotInfo(axes, name)), new IndexableNumericDataTable(th, lowCol, new PlotInfo(axes, name)), new IndexableNumericDataTable(th, closeCol, new PlotInfo(axes, name)));
        ArgumentValidations.assertNotNull(timeCol, "timeCol", this.getPlotInfo());
        ArgumentValidations.assertNotNull(openCol, "openCol", this.getPlotInfo());
        ArgumentValidations.assertNotNull(highCol, "highCol", this.getPlotInfo());
        ArgumentValidations.assertNotNull(lowCol, "lowCol", this.getPlotInfo());
        ArgumentValidations.assertNotNull(closeCol, "closeCol", this.getPlotInfo());
        this.tableHandle = th;
        this.timeCol = timeCol;
        this.openCol = openCol;
        this.highCol = highCol;
        this.lowCol = lowCol;
        this.closeCol = closeCol;
    }

    private OHLCDataSeriesTableArray(OHLCDataSeriesTableArray series, AxesImpl axes) {
        super(series, axes);
        this.tableHandle = series.tableHandle;
        this.timeCol = series.timeCol;
        this.openCol = series.openCol;
        this.highCol = series.highCol;
        this.lowCol = series.lowCol;
        this.closeCol = series.closeCol;
    }

    @Override
    public OHLCDataSeriesTableArray copy(AxesImpl axes) {
        return new OHLCDataSeriesTableArray(this, axes);
    }
}

