/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.xy;

import io.deephaven.engine.table.Table;
import io.deephaven.gui.color.Color;
import io.deephaven.gui.color.Paint;
import io.deephaven.gui.shape.NamedShape;
import io.deephaven.gui.shape.Shape;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.ChartImpl;
import io.deephaven.plot.LineStyle;
import io.deephaven.plot.datasets.AbstractDataSeries;
import io.deephaven.plot.datasets.DataSeries;
import io.deephaven.plot.datasets.data.IndexableData;
import io.deephaven.plot.datasets.data.IndexableDataArray;
import io.deephaven.plot.datasets.data.IndexableDataDouble;
import io.deephaven.plot.datasets.data.IndexableDataInteger;
import io.deephaven.plot.datasets.data.IndexableDataSwappableTable;
import io.deephaven.plot.datasets.data.IndexableDataSwappableTableDouble;
import io.deephaven.plot.datasets.data.IndexableDataTable;
import io.deephaven.plot.datasets.data.IndexableDataWithDefault;
import io.deephaven.plot.datasets.xy.XYDataSeries;
import io.deephaven.plot.datasets.xy.XYDataSeriesInternal;
import io.deephaven.plot.errors.PlotIllegalArgumentException;
import io.deephaven.plot.errors.PlotIllegalStateException;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.errors.PlotRuntimeException;
import io.deephaven.plot.errors.PlotUnsupportedOperationException;
import io.deephaven.plot.filters.SelectableDataSet;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.PlotUtils;
import io.deephaven.plot.util.tables.ColumnHandlerFactory;
import io.deephaven.plot.util.tables.SwappableTable;
import io.deephaven.plot.util.tables.TableHandle;
import java.io.Serializable;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractXYDataSeries
extends AbstractDataSeries
implements XYDataSeriesInternal {
    private static final long serialVersionUID = 5353144043894861970L;
    private final IndexableDataWithDefault<String> shapeLabels;
    private final IndexableDataWithDefault<Double> shapeSizes;
    private final IndexableDataWithDefault<Paint> shapeColors;
    private final IndexableDataWithDefault<Shape> pointShapes;

    public AbstractXYDataSeries(AxesImpl axes, int id, Comparable name, AbstractXYDataSeries series) {
        super(axes, id, name, series);
        this.shapeLabels = new IndexableDataWithDefault(this.getPlotInfo());
        this.shapeSizes = new IndexableDataWithDefault(this.getPlotInfo());
        this.shapeColors = new IndexableDataWithDefault(this.getPlotInfo());
        this.pointShapes = new IndexableDataWithDefault(this.getPlotInfo());
        if (series != null) {
            this.shapeLabels.set(series.shapeLabels);
            this.shapeSizes.set(series.shapeSizes);
            this.shapeColors.set(series.shapeColors);
            this.pointShapes.set(series.pointShapes);
        }
    }

    protected AbstractXYDataSeries(AbstractXYDataSeries series, AxesImpl axes) {
        super(series, axes);
        this.shapeLabels = new IndexableDataWithDefault(series.getPlotInfo());
        this.shapeSizes = new IndexableDataWithDefault(series.getPlotInfo());
        this.shapeColors = new IndexableDataWithDefault(series.getPlotInfo());
        this.pointShapes = new IndexableDataWithDefault(series.getPlotInfo());
        this.shapeLabels.set(series.shapeLabels);
        this.shapeSizes.set(series.shapeSizes);
        this.shapeColors.set(series.shapeColors);
        this.pointShapes.set(series.pointShapes);
    }

    protected void colorsSetSpecific(IndexableData<Paint> data) {
        this.shapeColors.setSpecific(data, true);
    }

    @Override
    public Paint getSeriesColor() {
        return this.shapeColors.getDefaultValue();
    }

    @Override
    public String getPointLabel(int i) {
        return this.shapeLabels.get(i);
    }

    @Override
    public Shape getPointShape(int i) {
        return this.pointShapes.get(i);
    }

    @Override
    public Double getPointSize(int i) {
        return this.shapeSizes.get(i);
    }

    @Override
    public Paint getPointColor(int i) {
        return this.shapeColors.get(i);
    }

    @Override
    public AbstractXYDataSeries linesVisible(Boolean visible) {
        this.setLinesVisible(visible);
        return this;
    }

    @Override
    public AbstractXYDataSeries pointsVisible(Boolean visible) {
        this.setPointsVisible(visible);
        return this;
    }

    @Override
    public AbstractXYDataSeries gradientVisible(boolean gradientVisible) {
        this.setGradientVisible(gradientVisible);
        return this;
    }

    @Override
    public AbstractXYDataSeries lineColor(Paint color) {
        this.setLineColor(color);
        return this;
    }

    @Override
    public AbstractXYDataSeries lineColor(int color) {
        this.setLineColor(color);
        return this;
    }

    @Override
    public AbstractXYDataSeries lineColor(String color) {
        this.setLineColor(color);
        return this;
    }

    @Override
    public AbstractXYDataSeries errorBarColor(Paint errorBarColor) {
        this.setErrorBarColor(errorBarColor);
        return this;
    }

    @Override
    public AbstractXYDataSeries errorBarColor(int errorBarColor) {
        this.setErrorBarColor(errorBarColor);
        return this;
    }

    @Override
    public AbstractXYDataSeries errorBarColor(String errorBarColor) {
        this.setErrorBarColor(errorBarColor);
        return this;
    }

    @Override
    public AbstractXYDataSeries lineStyle(LineStyle lineStyle) {
        this.setLineStyle(lineStyle);
        return this;
    }

    @Override
    public AbstractXYDataSeries seriesColor(Paint color) {
        this.lineColor(color);
        this.pointColor(color);
        return this;
    }

    @Override
    public AbstractXYDataSeries seriesColor(int color) {
        this.lineColor(color);
        this.pointColor(color);
        return this;
    }

    @Override
    public AbstractXYDataSeries seriesColor(String color) {
        this.lineColor(color);
        this.pointColor(color);
        return this;
    }

    @Override
    public XYDataSeriesInternal pointSize(int pointSize) {
        return this.pointSize(pointSize == Integer.MIN_VALUE ? null : Integer.valueOf(pointSize));
    }

    @Override
    public XYDataSeriesInternal pointSize(long pointSize) {
        return this.pointSize(pointSize == Long.MIN_VALUE ? null : Long.valueOf(pointSize));
    }

    @Override
    public XYDataSeriesInternal pointSize(double pointSize) {
        this.shapeSizes.setDefault(pointSize == -1.7976931348623157E308 || pointSize == Double.NaN ? null : Double.valueOf(pointSize));
        return this;
    }

    @Override
    public XYDataSeriesInternal pointSize(Number pointSize) {
        this.shapeSizes.setDefault(pointSize == null ? null : Double.valueOf(pointSize.doubleValue()));
        return this;
    }

    @Override
    public AbstractXYDataSeries pointSize(IndexableData<Double> pointSizes) {
        ArgumentValidations.assertNotNull(pointSizes, "factors", this.getPlotInfo());
        this.shapeSizes.setSpecific(pointSizes, true);
        return this;
    }

    @Override
    public AbstractXYDataSeries pointSize(int ... pointSizes) {
        return this.pointSize((IndexableData)new IndexableDataDouble(pointSizes, true, this.getPlotInfo()));
    }

    @Override
    public AbstractXYDataSeries pointSize(long ... pointSizes) {
        return this.pointSize((IndexableData)new IndexableDataDouble(pointSizes, true, this.getPlotInfo()));
    }

    @Override
    public AbstractXYDataSeries pointSize(double ... pointSizes) {
        return this.pointSize((IndexableData)new IndexableDataDouble(pointSizes, true, this.getPlotInfo()));
    }

    @Override
    public <T extends Number> AbstractXYDataSeries pointSize(T[] pointSizes) {
        return this.pointSize((IndexableData)new IndexableDataDouble(pointSizes, true, this.getPlotInfo()));
    }

    @Override
    public AbstractXYDataSeries pointSize(Table t, String pointSizes) {
        ArgumentValidations.assertNotNull(t, "table", this.getPlotInfo());
        ArgumentValidations.assertNotNull(pointSizes, "columnName", this.getPlotInfo());
        TableHandle tableHandle = new TableHandle(t, pointSizes);
        this.addTableHandle(tableHandle);
        ColumnHandlerFactory.ColumnHandler columnHandler = ColumnHandlerFactory.newNumericHandler(tableHandle, pointSizes, this.getPlotInfo());
        if (!columnHandler.typeClassification().isNumeric()) {
            throw new PlotUnsupportedOperationException("Column can not be converted into a size: column=" + pointSizes, this);
        }
        this.shapeSizes.setSpecific(new IndexableDataTable<Double>(columnHandler, this.getPlotInfo()){

            @Override
            public Double convert(Object v) {
                return PlotUtils.numberToDouble((Number)v);
            }
        }, true);
        return this;
    }

    @Override
    public AbstractXYDataSeries pointSize(SelectableDataSet sds, String pointSize) {
        ArgumentValidations.assertNotNull(sds, "sds", this.getPlotInfo());
        ArgumentValidations.assertNotNull(pointSize, "columnName", this.getPlotInfo());
        ArgumentValidations.assertColumnsInTable(sds, this.getPlotInfo(), pointSize);
        ArgumentValidations.assertIsNumericOrTime(sds, pointSize, this.getPlotInfo());
        SwappableTable t = sds.getSwappableTable(this.name(), this.chart(), pointSize);
        this.addSwappableTable(t);
        this.shapeSizes.setSpecific(new IndexableDataSwappableTableDouble(t, pointSize, this.getPlotInfo()), true);
        return this;
    }

    @Override
    public AbstractXYDataSeries pointColor(Paint pointColor) {
        this.shapeColors.setDefault(pointColor);
        return this;
    }

    @Override
    public AbstractXYDataSeries pointColor(int pointColor) {
        return this.pointColor(PlotUtils.intToColor(this.chart(), pointColor));
    }

    @Override
    public AbstractXYDataSeries pointColor(String pointColor) {
        return this.pointColor((Paint)Color.color((String)pointColor));
    }

    @Override
    public <T extends Paint> AbstractXYDataSeries pointColor(IndexableData<T> pointColor) {
        this.shapeColors.setSpecific(pointColor, true);
        return this;
    }

    @Override
    public AbstractXYDataSeries pointColor(Paint ... pointColor) {
        return this.pointColor((IndexableData)new IndexableDataArray<Paint>(pointColor, this.getPlotInfo()));
    }

    @Override
    public AbstractXYDataSeries pointColorInteger(IndexableData<Integer> colors) {
        return this.pointColor((IndexableData)new IndexableDataPaintInteger(colors, this.chart()));
    }

    @Override
    public AbstractXYDataSeries pointColor(int ... pointColors) {
        return this.pointColorInteger((IndexableData)new IndexableDataInteger(pointColors, this.getPlotInfo()));
    }

    @Override
    public AbstractXYDataSeries pointColor(Integer ... pointColors) {
        return this.pointColorInteger(new IndexableDataArray<Integer>(pointColors, this.getPlotInfo()));
    }

    @Override
    public AbstractXYDataSeries pointColor(String ... pointColors) {
        return this.pointColor((Paint[])Arrays.stream(pointColors).map(Color::color).toArray(Color[]::new));
    }

    @Override
    public AbstractXYDataSeries pointColor(Table t, String pointColors) {
        ArgumentValidations.assertNotNull(t, "table", this.getPlotInfo());
        TableHandle tableHandle = new TableHandle(t, pointColors);
        this.addTableHandle(tableHandle);
        ColumnHandlerFactory.ColumnHandler columnHandler = ColumnHandlerFactory.newNumericHandler(tableHandle, pointColors, this.getPlotInfo());
        if (columnHandler.typeClassification() == ColumnHandlerFactory.TypeClassification.INTEGER && (columnHandler.type() == Integer.TYPE || columnHandler.type() == Integer.class)) {
            return this.pointColor((IndexableData)new IndexableDataTablePaint(columnHandler, this.chart()));
        }
        if (columnHandler.typeClassification() == ColumnHandlerFactory.TypeClassification.PAINT) {
            return this.pointColor((IndexableData)new IndexableDataTable(columnHandler, this.getPlotInfo()));
        }
        throw new PlotUnsupportedOperationException("Column can not be converted into a color: column=" + pointColors + "\ttype=" + columnHandler.type(), this);
    }

    @Override
    public AbstractXYDataSeries pointColor(SelectableDataSet sds, String pointColors) {
        ArgumentValidations.assertColumnsInTable(sds, this.getPlotInfo(), pointColors);
        Class type = sds.getTableDefinition().getColumn(pointColors).getDataType();
        boolean isInt = type.equals(Integer.TYPE) || type.equals(Integer.class) || type.equals(Short.TYPE) || type.equals(Short.class);
        boolean isPaint = Paint.class.isAssignableFrom(type);
        if (!isInt && !isPaint) {
            throw new PlotUnsupportedOperationException("Column can not be converted into a color: column=" + pointColors + "\ttype=" + type, this);
        }
        SwappableTable t = sds.getSwappableTable(this.name(), this.chart(), pointColors);
        this.addSwappableTable(t);
        if (isInt) {
            return this.pointColor((IndexableData)new IndexableDataSwappableTablePaint(t, pointColors, this.chart()));
        }
        if (isPaint) {
            return this.pointColor((IndexableData)new IndexableDataSwappableTable(t, pointColors, this.getPlotInfo()));
        }
        throw new PlotIllegalStateException("Should never reach here", this);
    }

    @Override
    public AbstractXYDataSeries pointLabel(Object pointLabel) {
        this.shapeLabels.setDefault(pointLabel == null ? null : pointLabel.toString());
        return this;
    }

    @Override
    public AbstractXYDataSeries pointLabel(IndexableData<?> pointLabels) {
        this.shapeLabels.setSpecific(new IndexableDataString(pointLabels), true);
        return this;
    }

    @Override
    public AbstractXYDataSeries pointLabel(Object ... pointLabels) {
        return this.pointLabel(new IndexableDataArray<Object>(pointLabels, this.getPlotInfo()));
    }

    @Override
    public AbstractXYDataSeries pointLabel(@NotNull Table t, @NotNull String pointLabel) {
        TableHandle tableHandle = new TableHandle(t, pointLabel);
        this.addTableHandle(tableHandle);
        ColumnHandlerFactory.ColumnHandler columnHandler = ColumnHandlerFactory.newObjectHandler(tableHandle, pointLabel, this.getPlotInfo());
        return this.pointLabel((IndexableData)new IndexableDataTableString(columnHandler, this.getPlotInfo()));
    }

    @Override
    public AbstractXYDataSeries pointLabel(@NotNull SelectableDataSet sds, @NotNull String pointLabel) {
        ArgumentValidations.assertColumnsInTable(sds, this.getPlotInfo(), pointLabel);
        SwappableTable t = sds.getSwappableTable(this.name(), this.chart(), pointLabel);
        this.addSwappableTable(t);
        return this.pointLabel((IndexableData)new IndexableDataSwappableTableString(t, pointLabel, this.getPlotInfo()));
    }

    @Override
    public DataSeries pointShape(String pointShape) {
        return this.pointShape((Shape)NamedShape.getShape(pointShape));
    }

    @Override
    public DataSeries pointShape(Shape pointShape) {
        this.pointShapes.setDefault(pointShape);
        return this;
    }

    @Override
    public XYDataSeries pointShape(IndexableData<String> pointShapes) {
        ArgumentValidations.assertNotNull(pointShapes, "shapes", this.getPlotInfo());
        this.pointShapes.setSpecific(new IndexableDataPointShapeString(pointShapes), true);
        return this;
    }

    @Override
    public XYDataSeries pointShape(String ... pointShapes) {
        ArgumentValidations.assertNotNull(pointShapes, "shapes", this.getPlotInfo());
        int index = 0;
        for (String shape : pointShapes) {
            try {
                NamedShape.getShape(shape);
            }
            catch (IllegalArgumentException iae) {
                throw new PlotIllegalArgumentException("Not a valid shape: `" + shape + "` at index: " + index + "; valid shapes: " + Arrays.toString(NamedShape.values()), this);
            }
            ++index;
        }
        return this.pointShape(new IndexableDataArray<String>(pointShapes, this.getPlotInfo()));
    }

    @Override
    public XYDataSeries pointShape(Shape ... pointShapes) {
        ArgumentValidations.assertNotNull(pointShapes, "shapes", this.getPlotInfo());
        this.pointShapes.setSpecific(new IndexableDataPointShapeObject(new IndexableDataArray<Shape>(pointShapes, this.getPlotInfo())), true);
        return this;
    }

    @Override
    public XYDataSeries pointShape(Table t, String pointShape) {
        ArgumentValidations.assertNotNull(t, "t", this.getPlotInfo());
        ArgumentValidations.assertNotNull(pointShape, "columnName", this.getPlotInfo());
        Class columnType = ArgumentValidations.getColumnType(t, pointShape, this.getPlotInfo());
        if (String.class.isAssignableFrom(columnType)) {
            TableHandle tableHandle = new TableHandle(t, pointShape);
            this.addTableHandle(tableHandle);
            ColumnHandlerFactory.ColumnHandler columnHandler = ColumnHandlerFactory.newObjectHandler(tableHandle, pointShape, this.getPlotInfo());
            return this.pointShape(new IndexableDataTableString(columnHandler, this.getPlotInfo()));
        }
        if (Shape.class.isAssignableFrom(columnType)) {
            TableHandle tableHandle = new TableHandle(t, pointShape);
            this.addTableHandle(tableHandle);
            ColumnHandlerFactory.ColumnHandler columnHandler = ColumnHandlerFactory.newObjectHandler(tableHandle, pointShape, this.getPlotInfo());
            this.pointShapes.setSpecific(new IndexableDataTablePointShapeObject(columnHandler, this.getPlotInfo()), true);
            return this;
        }
        throw new PlotRuntimeException("column is not a supported type (String or Shape): columnName=" + pointShape, this);
    }

    @Override
    public XYDataSeries pointShape(SelectableDataSet sds, String pointShape) {
        ArgumentValidations.assertNotNull(sds, "sds", this.getPlotInfo());
        ArgumentValidations.assertNotNull(pointShape, "columnName", this.getPlotInfo());
        Class columnType = ArgumentValidations.getColumnType(sds, pointShape, this.getPlotInfo());
        if (String.class.isAssignableFrom(columnType)) {
            SwappableTable t = sds.getSwappableTable(this.name(), this.chart(), pointShape);
            this.addSwappableTable(t);
            return this.pointShape(new IndexableDataSwappableTableString(t, pointShape, this.getPlotInfo()));
        }
        if (Shape.class.isAssignableFrom(columnType)) {
            SwappableTable t = sds.getSwappableTable(this.name(), this.chart(), pointShape);
            this.addSwappableTable(t);
            this.pointShapes.setSpecific(new IndexableDataSwappableTablePointShapeObject(t, pointShape, this.getPlotInfo()), true);
            return this;
        }
        throw new PlotRuntimeException("column is not a supported type (String or Shape): columnName=" + pointShape, this);
    }

    @Override
    public AbstractXYDataSeries pointLabelFormat(String pointLabelFormat) {
        this.setPointLabelFormat(pointLabelFormat);
        return this;
    }

    @Override
    public AbstractXYDataSeries xToolTipPattern(String xToolTipPattern) {
        this.setXToolTipPattern(xToolTipPattern);
        return this;
    }

    @Override
    public AbstractXYDataSeries yToolTipPattern(String yToolTipPattern) {
        this.setYToolTipPattern(yToolTipPattern);
        return this;
    }

    @Override
    public AbstractXYDataSeries toolTipPattern(String toolTipPattern) {
        this.xToolTipPattern(toolTipPattern);
        this.yToolTipPattern(toolTipPattern);
        return this;
    }

    private static class IndexableDataPointShapeObject
    extends IndexableData<Shape> {
        private static final long serialVersionUID = 975960184959064132L;
        private final IndexableData<Shape> shapes;

        public IndexableDataPointShapeObject(IndexableData<Shape> shapes) {
            super(shapes.getPlotInfo());
            this.shapes = shapes;
        }

        @Override
        public int size() {
            return this.shapes.size();
        }

        @Override
        public Shape get(int index) {
            return this.shapes.get(index);
        }
    }

    private static class IndexableDataPointShapeString
    extends IndexableData<Shape> {
        private static final long serialVersionUID = 2933177669306019523L;
        private final IndexableData<String> shapes;

        public IndexableDataPointShapeString(IndexableData<String> shapes) {
            super(shapes.getPlotInfo());
            this.shapes = shapes;
        }

        @Override
        public int size() {
            return this.shapes.size();
        }

        @Override
        public Shape get(int index) {
            return NamedShape.getShape(this.shapes.get(index));
        }
    }

    private static class IndexableDataTablePaint
    extends IndexableDataTable<Paint>
    implements Serializable {
        private static final long serialVersionUID = 1809364632850960872L;
        private final ChartImpl chart;

        IndexableDataTablePaint(ColumnHandlerFactory.ColumnHandler columnHandler, ChartImpl chart) {
            super(columnHandler, chart.getPlotInfo());
            this.chart = chart;
        }

        @Override
        public Paint convert(Object v) {
            return PlotUtils.intToColor(this.chart, (Integer)v);
        }
    }

    private static class IndexableDataPaintInteger
    extends IndexableData<Paint>
    implements Serializable {
        private static final long serialVersionUID = 6258408120262796309L;
        private final IndexableData<Integer> colors;
        private final ChartImpl chart;

        IndexableDataPaintInteger(IndexableData<Integer> colors, ChartImpl chart) {
            super(chart.getPlotInfo());
            this.colors = colors;
            this.chart = chart;
        }

        @Override
        public int size() {
            return this.colors.size();
        }

        @Override
        public Paint get(int i) {
            return PlotUtils.intToColor(this.chart, this.colors.get(i));
        }
    }

    private static class IndexableDataSwappableTablePaint
    extends IndexableDataSwappableTable<Paint>
    implements Serializable {
        private static final long serialVersionUID = 1809364632850960872L;
        private final ChartImpl chart;

        IndexableDataSwappableTablePaint(SwappableTable t, String column, ChartImpl chart) {
            super(t, column, chart.getPlotInfo());
            this.chart = chart;
        }

        @Override
        public Paint convert(Object v) {
            return PlotUtils.intToColor(this.chart, (Integer)v);
        }
    }

    private static class IndexableDataSwappableTableString<T>
    extends IndexableDataSwappableTable<String>
    implements Serializable {
        private static final long serialVersionUID = 5039901915605865720L;

        IndexableDataSwappableTableString(SwappableTable t, String column, PlotInfo plotInfo) {
            super(t, column, plotInfo);
        }

        @Override
        public String convert(Object v) {
            return v == null ? null : v.toString();
        }
    }

    private static class IndexableDataSwappableTablePointShapeObject
    extends IndexableDataSwappableTable<Shape>
    implements Serializable {
        private static final long serialVersionUID = 5642048699432187943L;

        IndexableDataSwappableTablePointShapeObject(SwappableTable swappableTable, String column, PlotInfo plotInfo) {
            super(swappableTable, column, plotInfo);
        }

        @Override
        public Shape convert(Object v) {
            return v == null ? null : (Shape)v;
        }
    }

    private static class IndexableDataTablePointShapeObject
    extends IndexableDataTable<Shape>
    implements Serializable {
        private static final long serialVersionUID = -3933148551484191243L;

        IndexableDataTablePointShapeObject(ColumnHandlerFactory.ColumnHandler columnHandler, PlotInfo plotInfo) {
            super(columnHandler, plotInfo);
        }

        @Override
        public Shape convert(Object v) {
            return v == null ? null : (Shape)v;
        }
    }

    private static class IndexableDataTableString<T>
    extends IndexableDataTable<String>
    implements Serializable {
        private static final long serialVersionUID = 5039901915605865720L;
        private IndexableData<T> labels;

        IndexableDataTableString(ColumnHandlerFactory.ColumnHandler columnHandler, PlotInfo plotInfo) {
            super(columnHandler, plotInfo);
            this.labels = this.labels;
        }

        @Override
        public String convert(Object v) {
            return v == null ? null : v.toString();
        }
    }

    private static class IndexableDataString<T>
    extends IndexableData<String>
    implements Serializable {
        private static final long serialVersionUID = 4764967316583190069L;
        private IndexableData<T> labels;

        IndexableDataString(IndexableData<T> labels) {
            super(labels.getPlotInfo());
            this.labels = labels;
        }

        @Override
        public int size() {
            return this.labels.size();
        }

        @Override
        public String get(int i) {
            T v = this.labels.get(i);
            return v == null ? null : v.toString();
        }
    }
}

