/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.xy;

import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.datasets.data.IndexableNumericData;
import io.deephaven.plot.datasets.xy.AbstractXYDataSeries;
import io.deephaven.plot.util.ArgumentValidations;

public class XYDataSeriesArray
extends AbstractXYDataSeries {
    private static final long serialVersionUID = 7686441715908956603L;
    private final IndexableNumericData x;
    private final IndexableNumericData y;

    public XYDataSeriesArray(AxesImpl axes, int id, Comparable name, IndexableNumericData x, IndexableNumericData y) {
        this(axes, id, name, x, y, null);
    }

    public XYDataSeriesArray(AxesImpl axes, int id, Comparable name, IndexableNumericData x, IndexableNumericData y, AbstractXYDataSeries series) {
        super(axes, id, name, series);
        ArgumentValidations.assertNotNull(x, "x", this.getPlotInfo());
        ArgumentValidations.assertNotNull(y, "y", this.getPlotInfo());
        ArgumentValidations.assertSameSize(new IndexableNumericData[]{x, y}, new String[]{"x", "y"}, this.getPlotInfo());
        this.x = x;
        this.y = y;
    }

    protected XYDataSeriesArray(XYDataSeriesArray series, AxesImpl axes) {
        super(series, axes);
        this.x = series.x;
        this.y = series.y;
    }

    @Override
    public XYDataSeriesArray copy(AxesImpl axes) {
        return new XYDataSeriesArray(this, axes);
    }

    @Override
    public int size() {
        return this.x.size();
    }

    @Override
    public double getX(int i) {
        return this.x.get(i);
    }

    @Override
    public double getY(int i) {
        return this.y.get(i);
    }

    public IndexableNumericData getX() {
        return this.x;
    }

    public IndexableNumericData getY() {
        return this.y;
    }
}

