/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.xy;

import io.deephaven.function.Numeric;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.datasets.xy.AbstractXYDataSeries;
import io.deephaven.plot.datasets.xy.XYDataSeriesFunctionInternal;
import io.deephaven.plot.errors.PlotIllegalArgumentException;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.PlotUtils;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.DoubleUnaryOperator;

public class XYDataSeriesFunctionImpl
extends AbstractXYDataSeries
implements XYDataSeriesFunctionInternal {
    private static final long serialVersionUID = -2830236235998986828L;
    private static final Logger log = LoggerFactory.getLogger(XYDataSeriesFunctionImpl.class);
    private static final int MAX_BUFFER_LOAD = 10;
    private final transient DoubleUnaryOperator function;
    private double xmin = Double.NaN;
    private double xmax = Double.NaN;
    private double ymin = Double.NaN;
    private double ymax = Double.NaN;
    private int npoints = 200;
    private double[][] currentData;
    private double[][] nextData;
    private SortedMap<Double, Double> buffer;
    private boolean nPointsSet;
    private boolean rangeSet;

    public XYDataSeriesFunctionImpl(AxesImpl axes, int id, Comparable name, DoubleUnaryOperator function) {
        super(axes, id, name, null);
        this.function = function;
        ArgumentValidations.assertNotNull(function, "function", this.getPlotInfo());
    }

    private XYDataSeriesFunctionImpl(XYDataSeriesFunctionImpl series, AxesImpl axes) {
        super(series, axes);
        this.function = series.function;
        this.xmin = series.xmin;
        this.xmax = series.xmax;
        this.npoints = series.npoints;
        this.rangeSet = series.rangeSet;
        this.nPointsSet = series.nPointsSet;
        this.recompute(true);
    }

    @Override
    public XYDataSeriesFunctionImpl copy(AxesImpl axes) {
        return new XYDataSeriesFunctionImpl(this, axes);
    }

    private synchronized void recompute(boolean recomputeAll) {
        if (this.buffer == null) {
            this.buffer = new TreeMap<Double, Double>();
        }
        this.maybeClearBuffer();
        boolean changed = false;
        if (recomputeAll || this.buffer.isEmpty()) {
            this.recomputeRange(this.xmin, this.xmax, this.npoints);
            changed = true;
        }
        double dxmax = (this.xmax - this.xmin) / (double)(this.npoints - 1);
        if (!this.buffer.isEmpty()) {
            int n;
            double lowerBound = this.buffer.firstKey();
            double upperBound = this.buffer.lastKey();
            if (this.xmin < lowerBound) {
                n = (int)Math.ceil((lowerBound - this.xmin) / dxmax) + 1;
                this.recomputeRange(this.xmin, lowerBound, n);
                changed = true;
            }
            if (upperBound < this.xmax) {
                n = (int)Math.ceil((this.xmax - upperBound) / dxmax) + 1;
                this.recomputeRange(upperBound, this.xmax, n);
                changed = true;
            }
        }
        if (this.buffer.keySet().stream().filter(x -> x >= this.xmin && x <= this.xmax).count() < (long)this.npoints) {
            this.recomputeRange(this.xmin, this.xmax, this.npoints);
            changed = true;
        }
        if (changed) {
            this.nextData = new double[2][this.buffer.size()];
            int indx = 0;
            for (Map.Entry<Double, Double> e : this.buffer.entrySet()) {
                this.nextData[0][indx] = e.getKey();
                this.nextData[1][indx] = e.getValue();
                ++indx;
            }
            this.currentData = this.nextData;
        }
    }

    private void recomputeRange(double xmin, double xmax, int npoints) {
        double dx = (xmax - xmin) / (double)(npoints - 1);
        if (!(Numeric.isFinite((double)xmin) && Numeric.isFinite((double)xmax) && Numeric.isFinite((double)dx))) {
            log.info((Object)("XYDataSeriesFunction: abnormal range: xmin=" + xmin + " xmax=" + xmax + " dx=" + dx + " npoints=" + npoints));
            return;
        }
        for (int i = 0; i < npoints; ++i) {
            double x = xmin + (double)i * dx;
            this.computeY(x);
        }
    }

    private void computeY(double x) {
        if (Numeric.isFinite((double)x)) {
            this.buffer.computeIfAbsent(x, val -> {
                double y = this.function.applyAsDouble(x);
                if (!Numeric.isFinite((double)y)) {
                    log.info((Object)("XYDataSeriesFunction: abnormal y value: x=" + x + " y=" + y + " xmin=" + this.xmin + " xmax=" + this.xmax + " npoints=" + this.npoints));
                    y = Double.NaN;
                }
                this.ymin = PlotUtils.minIgnoreNaN(this.ymin, y);
                this.ymax = PlotUtils.maxIgnoreNaN(this.ymax, y);
                return y;
            });
        } else {
            log.info((Object)("XYDataSeriesFunction: abnormal x value: x=" + x + " xmin=" + this.xmin + " xmax=" + this.xmax + " npoints=" + this.npoints));
        }
    }

    private void maybeClearBuffer() {
        if (this.buffer.size() > 10 * this.npoints) {
            this.buffer.clear();
        }
    }

    @Override
    public int size() {
        if (this.currentData == null) {
            return 0;
        }
        return this.currentData[0].length;
    }

    @Override
    public double getX(int i) {
        if (i < 0 || i > this.size()) {
            throw new IndexOutOfBoundsException("Index out of bounds. index=" + i + " size=" + this.size());
        }
        return this.currentData[0][i];
    }

    @Override
    public double getY(int i) {
        if (i < 0 || i > this.size()) {
            throw new IndexOutOfBoundsException("Index out of bounds. index=" + i + " size=" + this.size());
        }
        return this.currentData[1][i];
    }

    @Override
    public XYDataSeriesFunctionImpl funcRange(double xmin, double xmax) {
        this.rangeSet = true;
        return this.funcRangeInternal(xmin, xmax, true);
    }

    @Override
    public XYDataSeriesFunctionImpl funcRange(double xmin, double xmax, int npoints) {
        this.rangeSet = true;
        this.nPointsSet = true;
        return this.funcRangeInternal(xmin, xmax, npoints, true);
    }

    @Override
    public XYDataSeriesFunctionImpl funcNPoints(int npoints) {
        this.nPointsSet = true;
        return this.funcNPointsInternal(npoints, true);
    }

    public void invokeRecompute(double xmin, double xmax, String name, int sessionId) {
        if (xmin == this.xmin && xmax == this.xmax) {
            return;
        }
        this.funcRangeInternal(xmin, xmax);
    }

    @Override
    public XYDataSeriesFunctionImpl funcRangeInternal(double xmin, double xmax) {
        return this.funcRangeInternal(xmin, xmax, false);
    }

    @Override
    public XYDataSeriesFunctionImpl funcRangeInternal(double xmin, double xmax, int npoints) {
        return this.funcRangeInternal(xmin, xmax, npoints, false);
    }

    @Override
    public XYDataSeriesFunctionImpl funcNPointsInternal(int npoints) {
        return this.funcNPointsInternal(npoints, false);
    }

    private XYDataSeriesFunctionImpl funcRangeInternal(double xmin, double xmax, boolean isUser) {
        return this.funcRangeInternal(xmin, xmax, this.npoints, isUser);
    }

    private XYDataSeriesFunctionImpl funcRangeInternal(double xmin, double xmax, int npoints, boolean isUser) {
        if (!Numeric.isFinite((double)xmin) || !Numeric.isFinite((double)xmax)) {
            throw new PlotIllegalArgumentException("Abnormal range value.  xmin=" + xmin + " xmax=" + xmax, this);
        }
        if (xmin > xmax) {
            throw new PlotIllegalArgumentException("xmax < xmin: xmin=" + xmin + " xmax=" + xmax, this);
        }
        if (npoints < 0) {
            throw new PlotIllegalArgumentException("npoints < 0", this);
        }
        if (!this.rangeSet || isUser) {
            boolean changeNumberOfPoints = !this.nPointsSet || isUser;
            boolean recompute = this.npoints != npoints && changeNumberOfPoints;
            boolean changed = this.xmin != xmin || this.xmax != xmax || recompute;
            this.xmin = xmin;
            this.xmax = xmax;
            this.npoints = npoints;
            if (changed) {
                this.recompute(recompute);
            }
        }
        return this;
    }

    private XYDataSeriesFunctionImpl funcNPointsInternal(int npoints, boolean isUser) {
        if (npoints < 0) {
            throw new PlotIllegalArgumentException("npoints < 0", this);
        }
        if (!this.nPointsSet || isUser) {
            boolean changed = this.npoints != npoints;
            this.npoints = npoints;
            if (changed) {
                this.recompute(true);
            }
        }
        return this;
    }
}

