/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.xy;

import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.context.QueryScope;
import io.deephaven.engine.table.Table;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.TableSnapshotSeries;
import io.deephaven.plot.datasets.data.IndexableNumericDataSwappableTable;
import io.deephaven.plot.datasets.xy.XYDataSeriesArray;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.SwappableTable;
import java.util.function.Function;

public class XYDataSeriesSwappableTableArray
extends XYDataSeriesArray
implements TableSnapshotSeries {
    private static final long serialVersionUID = 1L;
    private final SwappableTable swappableTable;
    private final String x;
    private final String y;
    private Table localTable;

    public XYDataSeriesSwappableTableArray(AxesImpl axes, int id, Comparable name, SwappableTable swappableTable, String x, String y) {
        super(axes, id, name, new IndexableNumericDataSwappableTable(swappableTable, x, new PlotInfo(axes, name)), new IndexableNumericDataSwappableTable(swappableTable, y, new PlotInfo(axes, name)));
        this.swappableTable = swappableTable;
        this.x = x;
        this.y = y;
    }

    @Override
    public XYDataSeriesArray copy(AxesImpl axes) {
        return new XYDataSeriesSwappableTableArray(this, axes);
    }

    private XYDataSeriesSwappableTableArray(XYDataSeriesSwappableTableArray series, AxesImpl axes) {
        super(series, axes);
        this.swappableTable = series.swappableTable;
        this.x = series.x;
        this.y = series.y;
    }

    private <S, T> Function<Table, Table> constructPartitionedTableFromFunction(Function<S, T> function, Class resultClass, String onColumn, String columnName) {
        ArgumentValidations.assertNotNull(function, "function", this.getPlotInfo());
        String queryFunction = columnName + "Function";
        return t -> {
            QueryScope.addParam((String)queryFunction, (Object)function);
            ExecutionContext.getContext().getQueryLibrary().importClass(resultClass);
            return (Table)t.update(new String[]{columnName + " = (" + resultClass.getSimpleName() + ") " + queryFunction + ".apply(" + onColumn + ")"});
        };
    }
}

