/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.xy;

import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.context.QueryScope;
import io.deephaven.engine.table.Table;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.SeriesInternal;
import io.deephaven.plot.datasets.data.IndexableNumericDataTable;
import io.deephaven.plot.datasets.xy.XYDataSeriesArray;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.TableHandle;
import java.util.function.Function;

public class XYDataSeriesTableArray
extends XYDataSeriesArray
implements SeriesInternal {
    private final TableHandle tableHandle;
    private final String x;
    private final String y;

    public XYDataSeriesTableArray(AxesImpl axes, int id, Comparable name, TableHandle tableHandle, String x, String y) {
        super(axes, id, name, new IndexableNumericDataTable(tableHandle, x, new PlotInfo(axes, name)), new IndexableNumericDataTable(tableHandle, y, new PlotInfo(axes, name)));
        this.tableHandle = tableHandle;
        this.x = x;
        this.y = y;
    }

    private XYDataSeriesTableArray(XYDataSeriesTableArray series, AxesImpl axes) {
        super(series, axes);
        this.tableHandle = series.tableHandle;
        this.x = series.x;
        this.y = series.y;
    }

    @Override
    public XYDataSeriesTableArray copy(AxesImpl axes) {
        return new XYDataSeriesTableArray(this, axes);
    }

    private <S, T> Table constructTableFromFunction(Table t, Function<S, T> function, Class resultClass, String onColumn, String columnName) {
        ArgumentValidations.assertNotNull(function, "function", this.getPlotInfo());
        String queryFunction = columnName + "Function";
        QueryScope.addParam((String)queryFunction, function);
        ExecutionContext.getContext().getQueryLibrary().importClass(resultClass);
        return (Table)t.update(new String[]{columnName + " = (" + resultClass.getSimpleName() + ") " + queryFunction + ".apply(" + onColumn + ")"});
    }
}

