/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.xyerrorbar;

import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.datasets.data.IndexableNumericData;
import io.deephaven.plot.datasets.xy.AbstractXYDataSeries;
import io.deephaven.plot.datasets.xy.XYDataSeriesArray;
import io.deephaven.plot.datasets.xyerrorbar.XYErrorBarDataSeriesInternal;
import io.deephaven.plot.util.ArgumentValidations;

public class XYErrorBarDataSeriesArray
extends XYDataSeriesArray
implements XYErrorBarDataSeriesInternal {
    private IndexableNumericData x;
    private IndexableNumericData xLow;
    private IndexableNumericData xHigh;
    private IndexableNumericData yLow;
    private IndexableNumericData y;
    private IndexableNumericData yHigh;
    private final boolean drawXError;
    private final boolean drawYError;

    public XYErrorBarDataSeriesArray(AxesImpl axes, int id, Comparable name, IndexableNumericData x, IndexableNumericData xLow, IndexableNumericData xHigh, IndexableNumericData y, IndexableNumericData yLow, IndexableNumericData yHigh, boolean drawXError, boolean drawYError) {
        this(axes, id, name, x, xLow, xHigh, y, yLow, yHigh, drawXError, drawYError, null);
    }

    public XYErrorBarDataSeriesArray(AxesImpl axes, int id, Comparable name, IndexableNumericData x, IndexableNumericData xLow, IndexableNumericData xHigh, IndexableNumericData y, IndexableNumericData yLow, IndexableNumericData yHigh, boolean drawXError, boolean drawYError, AbstractXYDataSeries series) {
        super(axes, id, name, x, y, series);
        ArgumentValidations.assertNotNull(x, "x", this.getPlotInfo());
        this.x = x;
        if (drawXError) {
            ArgumentValidations.assertNotNull(xLow, "xLow", this.getPlotInfo());
            ArgumentValidations.assertNotNull(xHigh, "xHigh", this.getPlotInfo());
            this.xLow = xLow;
            this.xHigh = xHigh;
        } else {
            this.xLow = x;
            this.xHigh = x;
        }
        ArgumentValidations.assertNotNull(y, "y", this.getPlotInfo());
        this.y = y;
        if (drawYError) {
            ArgumentValidations.assertNotNull(yLow, "yLow", this.getPlotInfo());
            ArgumentValidations.assertNotNull(yHigh, "yHigh", this.getPlotInfo());
            this.yLow = yLow;
            this.yHigh = yHigh;
        } else {
            this.yLow = y;
            this.yHigh = y;
        }
        this.drawXError = drawXError;
        this.drawYError = drawYError;
    }

    protected XYErrorBarDataSeriesArray(XYErrorBarDataSeriesArray series, AxesImpl axes) {
        super(series, axes);
        this.x = series.x;
        this.xLow = series.xLow;
        this.xHigh = series.xHigh;
        this.y = series.y;
        this.yLow = series.yLow;
        this.yHigh = series.yHigh;
        this.drawXError = series.drawXError;
        this.drawYError = series.drawYError;
    }

    @Override
    public XYErrorBarDataSeriesArray copy(AxesImpl axes) {
        return new XYErrorBarDataSeriesArray(this, axes);
    }

    @Override
    public double getStartX(int i) {
        return this.xLow.get(i);
    }

    @Override
    public double getEndX(int i) {
        return this.xHigh.get(i);
    }

    @Override
    public double getStartY(int i) {
        return this.yLow.get(i);
    }

    @Override
    public double getEndY(int i) {
        return this.yHigh.get(i);
    }

    @Override
    public boolean drawXError() {
        return this.drawXError;
    }

    @Override
    public boolean drawYError() {
        return this.drawYError;
    }

    public IndexableNumericData getXLow() {
        return this.xLow;
    }

    public IndexableNumericData getXHigh() {
        return this.xHigh;
    }

    public IndexableNumericData getYLow() {
        return this.yLow;
    }

    public IndexableNumericData getYHigh() {
        return this.yHigh;
    }
}

