/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.filters;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.table.PartitionedTable;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.engine.util.TableTools;
import io.deephaven.plot.BaseFigureImpl;
import io.deephaven.plot.ChartImpl;
import io.deephaven.plot.filters.SelectableDataSet;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.PartitionedTableBackedPartitionedTableHandle;
import io.deephaven.plot.util.tables.PartitionedTableHandle;
import io.deephaven.plot.util.tables.SwappableTable;
import io.deephaven.plot.util.tables.SwappableTableOneClickPartitioned;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SelectableDataSetOneClick
implements SelectableDataSet<String, Set<Object>> {
    private final PartitionedTable partitionedTable;
    private final boolean requireAllFiltersToDisplay;
    private final Map<Object, WeakReference<SelectableDataSet<String, Set<Object>>>> transformationCache = new HashMap<Object, WeakReference<SelectableDataSet<String, Set<Object>>>>();

    public SelectableDataSetOneClick(PartitionedTable partitionedTable) {
        this(partitionedTable, true);
    }

    public SelectableDataSetOneClick(PartitionedTable partitionedTable, boolean requireAllFiltersToDisplay) {
        Require.neqNull((Object)partitionedTable, (String)"partitionedTable");
        this.partitionedTable = partitionedTable;
        this.requireAllFiltersToDisplay = requireAllFiltersToDisplay;
    }

    @Override
    public TableDefinition getTableDefinition() {
        return this.partitionedTable.constituentDefinition();
    }

    public String[] getByColumns() {
        return this.partitionedTable.keyColumnNames().toArray(new String[0]);
    }

    @Override
    public SwappableTable getSwappableTable(Comparable seriesName, ChartImpl chart, Function<Table, Table> tableTransform, String ... cols) {
        ArgumentValidations.assertNotNull(chart, "chart", chart.getPlotInfo());
        ArgumentValidations.assertNotNull(cols, "cols", chart.getPlotInfo());
        BaseFigureImpl figure = chart.figure();
        TableDefinition updatedTableDef = this.transformTableDefinition(this.partitionedTable.constituentDefinition(), tableTransform);
        ArrayList<String> allCols = new ArrayList<String>(Arrays.asList(cols));
        allCols.addAll(this.partitionedTable.keyColumnNames());
        List missingColumns = allCols.stream().filter(col -> updatedTableDef.getColumn(col) == null).collect(Collectors.toList());
        if (!missingColumns.isEmpty()) {
            throw new IllegalStateException("The columns [" + String.join((CharSequence)", ", missingColumns) + "] do not exist in the resulting table. Available columns are [" + updatedTableDef.getColumnNamesAsString() + "]");
        }
        List<String> viewColumns = !updatedTableDef.equals((Object)this.partitionedTable.constituentDefinition()) ? allCols.stream().filter(col -> this.partitionedTable.constituentDefinition().getColumn(col) != null).collect(Collectors.toList()) : null;
        String[] byColumns = this.partitionedTable.keyColumnNames().toArray(new String[0]);
        PartitionedTableBackedPartitionedTableHandle partitionedTableHandle = new PartitionedTableBackedPartitionedTableHandle(this.partitionedTable, updatedTableDef, byColumns, chart.getPlotInfo(), allCols, viewColumns);
        partitionedTableHandle.setKeyColumnsOrdered(byColumns);
        partitionedTableHandle.setOneClickMap(true);
        return new SwappableTableOneClickPartitioned(seriesName, figure.getUpdateInterval(), (PartitionedTableHandle)partitionedTableHandle, tableTransform, this.requireAllFiltersToDisplay, byColumns);
    }

    private TableDefinition transformTableDefinition(TableDefinition toTransform, Function<Table, Table> transformation) {
        return transformation != null ? transformation.apply(TableTools.newTable((TableDefinition)toTransform)).getDefinition() : toTransform;
    }

    @Override
    public SelectableDataSet<String, Set<Object>> transform(@NotNull Object memoKey, @NotNull Function<Table, Table> transformation) {
        SelectableDataSet value = null;
        WeakReference<SelectableDataSet<String, Set<Object>>> reference = this.transformationCache.get(memoKey);
        if (reference != null) {
            value = (SelectableDataSet)reference.get();
        }
        if (value == null) {
            value = new SelectableDataSetOneClick(this.partitionedTable.transform(transformation::apply), this.requireAllFiltersToDisplay);
            this.transformationCache.put(memoKey, new WeakReference<SelectableDataSet>(value));
        }
        return value;
    }
}

