/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.util;

import io.deephaven.base.verify.Require;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.Arrays;

public class ShapeUtils
implements Serializable {
    private static final long serialVersionUID = -5894187331477897336L;

    private ShapeUtils() {
    }

    public static Shape resize(Shape s, double factor) {
        Require.neqNull((Object)s, (String)"shape");
        if (s instanceof RectangularShape) {
            return ShapeUtils.resizeRectangle((RectangularShape)s, factor);
        }
        if (s instanceof Polygon) {
            return ShapeUtils.resizePolygon((Polygon)s, factor);
        }
        throw new UnsupportedOperationException("Can't use that shape yet: " + s.getClass());
    }

    private static Shape resizePolygon(Polygon p, double factor) {
        double[] xPoints = new double[p.npoints];
        double[] yPoints = new double[p.npoints];
        int i = 0;
        while (i < p.npoints) {
            xPoints[i] = p.xpoints[i];
            int n = i;
            xPoints[n] = xPoints[n] * factor;
            yPoints[i] = p.ypoints[i];
            int n2 = i++;
            yPoints[n2] = yPoints[n2] * factor;
        }
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(xPoints[0], yPoints[0]);
        for (int i2 = 1; i2 < p.npoints; ++i2) {
            ((Path2D)path).lineTo(xPoints[i2], yPoints[i2]);
        }
        path.closePath();
        return path;
    }

    private static RectangularShape resizeRectangle(RectangularShape s, double factor) {
        RectangularShape n = (RectangularShape)s.clone();
        double w = s.getWidth() * factor;
        double h = s.getHeight() * factor;
        double newX = s.getCenterX() - w / 2.0;
        double newY = s.getCenterY() - h / 2.0;
        n.setFrame(newX, newY, w, h);
        return n;
    }

    public static Shape rotate(Shape s, double angle) {
        Require.neqNull((Object)s, (String)"shape");
        if (s instanceof RectangularShape) {
            return ShapeUtils.rotateRectangle((RectangularShape)s, angle);
        }
        if (s instanceof Polygon) {
            return ShapeUtils.rotatePolygon((Polygon)s, angle);
        }
        throw new UnsupportedOperationException("Can't use that shape yet: " + s.getClass());
    }

    private static Shape rotateRectangle(RectangularShape s, double angle) {
        double[] xPoints = new double[]{s.getX(), s.getX() + s.getWidth(), s.getX() + s.getWidth(), s.getX()};
        double[] yPoints = new double[]{s.getY(), s.getY() + s.getHeight(), s.getY() + s.getHeight(), s.getY()};
        double[] newXPoints = new double[4];
        double[] newYPoints = new double[4];
        for (int i = 0; i < 4; ++i) {
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            newXPoints[i] = s.getCenterX() + (xPoints[i] - s.getCenterX()) * cos - (xPoints[i] - s.getCenterY()) * sin;
            newYPoints[i] = s.getCenterY() + (yPoints[i] - s.getCenterY()) * cos - (yPoints[i] - s.getCenterX()) * sin;
        }
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(xPoints[0], yPoints[0]);
        for (int i = 1; i < 4; ++i) {
            ((Path2D)path).lineTo(newXPoints[i], newYPoints[i]);
        }
        path.closePath();
        return path;
    }

    private static Shape rotatePolygon(Polygon p, double angle) {
        double[] xPoints = new double[p.npoints];
        double[] yPoints = new double[p.npoints];
        double[] center = ShapeUtils.findCenter(p);
        for (int i = 0; i < p.npoints; ++i) {
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            xPoints[i] = center[0] + ((double)p.xpoints[i] - center[0]) * cos - ((double)p.ypoints[i] - center[1]) * sin;
            yPoints[i] = center[1] + ((double)p.ypoints[i] - center[1]) * cos - ((double)p.xpoints[i] - center[0]) * sin;
        }
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(xPoints[0], yPoints[0]);
        for (int i = 1; i < p.npoints; ++i) {
            ((Path2D)path).lineTo(xPoints[i], yPoints[i]);
        }
        path.closePath();
        return path;
    }

    private static double[] findCenter(Polygon p) {
        double xAvg = (double)Arrays.stream(p.xpoints).sum() / (double)p.npoints;
        double yAvg = (double)Arrays.stream(p.ypoints).sum() / (double)p.npoints;
        return new double[]{xAvg, yAvg};
    }
}

