/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.util.functions;

import groovy.lang.Closure;
import io.deephaven.base.classloaders.MapBackedClassLoader;
import io.deephaven.base.verify.Require;
import io.deephaven.engine.util.GroovyDeephavenSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;

public class SerializableClosure<T>
implements Serializable {
    private static final long serialVersionUID = -1438975554979636320L;
    private Closure<T> closure;

    public SerializableClosure(Closure<T> closure) {
        Require.neqNull(closure, (String)"closure");
        this.closure = closure.dehydrate();
        this.closure.setResolveStrategy(3);
    }

    public Closure<T> getClosure() {
        return this.closure;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        Class<?> c = this.closure.getClass();
        String closureClassName = c.getName();
        byte[] closureCode = GroovyDeephavenSession.getDynamicClass((String)closureClassName);
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
        objectStream.writeObject(this.closure);
        byte[] closureData = byteStream.toByteArray();
        oos.writeObject(closureClassName);
        oos.writeObject(closureCode);
        oos.writeObject(closureData);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        String closureClassName = (String)ois.readObject();
        byte[] closureCode = (byte[])ois.readObject();
        byte[] closureData = (byte[])ois.readObject();
        MapBackedClassLoader cl = new MapBackedClassLoader();
        cl.addClassData(closureClassName, closureCode);
        CustomClassLoaderObjectInputStream<MapBackedClassLoader> objectStream = new CustomClassLoaderObjectInputStream<MapBackedClassLoader>(new ByteArrayInputStream(closureData), cl);
        this.closure = (Closure)objectStream.readObject();
    }

    private static class CustomClassLoaderObjectInputStream<CLT extends ClassLoader>
    extends ObjectInputStream {
        private final CLT classLoader;

        public CustomClassLoaderObjectInputStream(InputStream inputStream, CLT classLoader) throws IOException {
            super(inputStream);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException, IOException {
            if (this.classLoader != null) {
                try {
                    return Class.forName(desc.getName(), false, this.classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return super.resolveClass(desc);
        }
    }
}

