/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.util.tables;

import io.deephaven.engine.table.DataColumn;
import io.deephaven.engine.table.Table;
import io.deephaven.gui.color.Paint;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.errors.PlotUnsupportedOperationException;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.TableHandle;
import io.deephaven.time.DateTime;
import java.io.Serializable;
import java.util.Date;

public class ColumnHandlerFactory
implements Serializable {
    private static final long serialVersionUID = -6737880834225877984L;

    private ColumnHandlerFactory() {
    }

    public static ColumnHandler newNumericHandler(TableHandle tableHandle, String columnName, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(tableHandle, "tableHandle", plotInfo);
        ArgumentValidations.assertNotNull(columnName, "columnName", plotInfo);
        ArgumentValidations.assertColumnsInTable(tableHandle.getTable(), plotInfo, columnName);
        Class type = tableHandle.getTable().getDefinition().getColumn(columnName).getDataType();
        if (type.equals(Short.TYPE)) {
            return new ColumnHandlerHandle(tableHandle, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.INTEGER;
                }

                @Override
                public double getDouble(int i) {
                    short value = this.getDataColumn().getShort((long)i);
                    return value == Short.MIN_VALUE ? Double.NaN : (double)value;
                }
            };
        }
        if (type.equals(Integer.TYPE)) {
            return new ColumnHandlerHandle(tableHandle, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.INTEGER;
                }

                @Override
                public double getDouble(int i) {
                    int value = this.getDataColumn().getInt((long)i);
                    return value == Integer.MIN_VALUE ? Double.NaN : (double)value;
                }
            };
        }
        if (type.equals(Long.TYPE)) {
            return new ColumnHandlerHandle(tableHandle, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.INTEGER;
                }

                @Override
                public double getDouble(int i) {
                    long value = this.getDataColumn().getLong((long)i);
                    return value == Long.MIN_VALUE ? Double.NaN : (double)value;
                }
            };
        }
        if (type.equals(Float.TYPE)) {
            return new ColumnHandlerHandle(tableHandle, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.FLOATINGPOINT;
                }

                @Override
                public double getDouble(int i) {
                    double value = this.getDataColumn().getFloat((long)i);
                    return value == -3.4028234663852886E38 ? Double.NaN : value;
                }
            };
        }
        if (type.equals(Double.TYPE)) {
            return new ColumnHandlerHandle(tableHandle, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.FLOATINGPOINT;
                }

                @Override
                public double getDouble(int i) {
                    double value = this.getDataColumn().getDouble((long)i);
                    return value == -1.7976931348623157E308 ? Double.NaN : value;
                }
            };
        }
        if (type.equals(Short.class)) {
            return new ColumnHandlerHandle(tableHandle, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.INTEGER;
                }

                @Override
                public double getDouble(int i) {
                    Number value = (Number)this.getDataColumn().get((long)i);
                    return value == null ? Double.NaN : value.doubleValue();
                }
            };
        }
        if (type.equals(Integer.class)) {
            return new ColumnHandlerHandle(tableHandle, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.INTEGER;
                }

                @Override
                public double getDouble(int i) {
                    Number value = (Number)this.getDataColumn().get((long)i);
                    return value == null ? Double.NaN : value.doubleValue();
                }
            };
        }
        if (type.equals(Long.class)) {
            return new ColumnHandlerHandle(tableHandle, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.INTEGER;
                }

                @Override
                public double getDouble(int i) {
                    Number value = (Number)this.getDataColumn().get((long)i);
                    return value == null ? Double.NaN : value.doubleValue();
                }
            };
        }
        if (type.equals(Float.class)) {
            return new ColumnHandlerHandle(tableHandle, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.FLOATINGPOINT;
                }

                @Override
                public double getDouble(int i) {
                    Number value = (Number)this.getDataColumn().get((long)i);
                    return value == null ? Double.NaN : value.doubleValue();
                }
            };
        }
        if (type.equals(Double.class)) {
            return new ColumnHandlerHandle(tableHandle, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.FLOATINGPOINT;
                }

                @Override
                public double getDouble(int i) {
                    Number value = (Number)this.getDataColumn().get((long)i);
                    return value == null ? Double.NaN : value.doubleValue();
                }
            };
        }
        if (type.equals(Number.class)) {
            return new ColumnHandlerHandle(tableHandle, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.FLOATINGPOINT;
                }

                @Override
                public double getDouble(int i) {
                    Number value = (Number)this.getDataColumn().get((long)i);
                    return value == null ? Double.NaN : value.doubleValue();
                }
            };
        }
        if (Date.class.isAssignableFrom(type)) {
            return new ColumnHandlerHandle(tableHandle, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.TIME;
                }

                @Override
                public double getDouble(int i) {
                    Date value = (Date)this.getDataColumn().get((long)i);
                    return value == null ? Double.NaN : (double)(value.getTime() * 1000000L);
                }
            };
        }
        if (type.equals(DateTime.class)) {
            return new ColumnHandlerHandle(tableHandle, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.TIME;
                }

                @Override
                public double getDouble(int i) {
                    DateTime value = (DateTime)this.getDataColumn().get((long)i);
                    return value == null ? Double.NaN : (double)value.getNanos();
                }
            };
        }
        if (Paint.class.isAssignableFrom(type)) {
            return new ColumnHandlerHandle(tableHandle, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.PAINT;
                }

                @Override
                public double getDouble(int i) {
                    throw new UnsupportedOperationException("Double conversion not supported for paints");
                }
            };
        }
        throw new UnsupportedOperationException("Unsupported numeric data type: columnName=" + columnName + " type=" + type);
    }

    public static ColumnHandler newNumericHandler(Table table, String columnName, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(table, "table", plotInfo);
        ArgumentValidations.assertNotNull(columnName, "columnName", plotInfo);
        Class type = table.getDefinition().getColumn(columnName).getDataType();
        if (type.equals(Short.TYPE)) {
            return new ColumnHandlerTable(table, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.INTEGER;
                }

                @Override
                public double getDouble(int i) {
                    short value = this.getDataColumn().getShort((long)i);
                    return value == Short.MIN_VALUE ? Double.NaN : (double)value;
                }
            };
        }
        if (type.equals(Integer.TYPE)) {
            return new ColumnHandlerTable(table, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.INTEGER;
                }

                @Override
                public double getDouble(int i) {
                    int value = this.getDataColumn().getInt((long)i);
                    return value == Integer.MIN_VALUE ? Double.NaN : (double)value;
                }
            };
        }
        if (type.equals(Long.TYPE)) {
            return new ColumnHandlerTable(table, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.INTEGER;
                }

                @Override
                public double getDouble(int i) {
                    long value = this.getDataColumn().getLong((long)i);
                    return value == Long.MIN_VALUE ? Double.NaN : (double)value;
                }
            };
        }
        if (type.equals(Float.TYPE)) {
            return new ColumnHandlerTable(table, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.FLOATINGPOINT;
                }

                @Override
                public double getDouble(int i) {
                    double value = this.getDataColumn().getFloat((long)i);
                    return value == -3.4028234663852886E38 ? Double.NaN : value;
                }
            };
        }
        if (type.equals(Double.TYPE)) {
            return new ColumnHandlerTable(table, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.FLOATINGPOINT;
                }

                @Override
                public double getDouble(int i) {
                    double value = this.getDataColumn().getDouble((long)i);
                    return value == -1.7976931348623157E308 ? Double.NaN : value;
                }
            };
        }
        if (type.equals(Short.class)) {
            return new ColumnHandlerTable(table, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.INTEGER;
                }

                @Override
                public double getDouble(int i) {
                    Number value = (Number)this.getDataColumn().get((long)i);
                    return value == null ? Double.NaN : value.doubleValue();
                }
            };
        }
        if (type.equals(Integer.class)) {
            return new ColumnHandlerTable(table, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.INTEGER;
                }

                @Override
                public double getDouble(int i) {
                    Number value = (Number)this.getDataColumn().get((long)i);
                    return value == null ? Double.NaN : value.doubleValue();
                }
            };
        }
        if (type.equals(Long.class)) {
            return new ColumnHandlerTable(table, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.INTEGER;
                }

                @Override
                public double getDouble(int i) {
                    Number value = (Number)this.getDataColumn().get((long)i);
                    return value == null ? Double.NaN : value.doubleValue();
                }
            };
        }
        if (type.equals(Float.class)) {
            return new ColumnHandlerTable(table, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.FLOATINGPOINT;
                }

                @Override
                public double getDouble(int i) {
                    Number value = (Number)this.getDataColumn().get((long)i);
                    return value == null ? Double.NaN : value.doubleValue();
                }
            };
        }
        if (type.equals(Double.class)) {
            return new ColumnHandlerTable(table, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.FLOATINGPOINT;
                }

                @Override
                public double getDouble(int i) {
                    Number value = (Number)this.getDataColumn().get((long)i);
                    return value == null ? Double.NaN : value.doubleValue();
                }
            };
        }
        if (type.equals(Number.class)) {
            return new ColumnHandlerTable(table, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.FLOATINGPOINT;
                }

                @Override
                public double getDouble(int i) {
                    Number value = (Number)this.getDataColumn().get((long)i);
                    return value == null ? Double.NaN : value.doubleValue();
                }
            };
        }
        if (type.equals(Date.class)) {
            return new ColumnHandlerTable(table, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.TIME;
                }

                @Override
                public double getDouble(int i) {
                    Date value = (Date)this.getDataColumn().get((long)i);
                    return value == null ? Double.NaN : (double)(value.getTime() * 1000000L);
                }
            };
        }
        if (type.equals(DateTime.class)) {
            return new ColumnHandlerTable(table, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.TIME;
                }

                @Override
                public double getDouble(int i) {
                    DateTime value = (DateTime)this.getDataColumn().get((long)i);
                    return value == null ? Double.NaN : (double)value.getNanos();
                }
            };
        }
        if (Paint.class.isAssignableFrom(type)) {
            return new ColumnHandlerTable(table, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.PAINT;
                }

                @Override
                public double getDouble(int i) {
                    throw new UnsupportedOperationException("Double conversion not supported for paints");
                }
            };
        }
        throw new UnsupportedOperationException("Unsupported numeric data type: columnName=" + columnName + " type=" + type);
    }

    public static ColumnHandler newComparableHandler(TableHandle tableHandle, String columnName, final PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(tableHandle, "tableHandle", plotInfo);
        ArgumentValidations.assertNotNull(columnName, "columnName", plotInfo);
        Class type = tableHandle.getTable().getDefinition().getColumn(columnName).getDataType();
        if (Comparable.class.isAssignableFrom(type)) {
            return new ColumnHandlerHandle(tableHandle, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.COMPARABLE;
                }

                @Override
                public double getDouble(int i) {
                    throw new PlotUnsupportedOperationException("Double conversion not supported for comparables", plotInfo);
                }
            };
        }
        throw new PlotUnsupportedOperationException("Unsupported data type: columnName=" + columnName + " type=" + type, plotInfo);
    }

    public static ColumnHandler newComparableHandler(Table table, String columnName, final PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(table, "table", plotInfo);
        ArgumentValidations.assertNotNull(columnName, "columnName", plotInfo);
        Class type = table.getDefinition().getColumn(columnName).getDataType();
        if (Comparable.class.isAssignableFrom(type)) {
            return new ColumnHandlerTable(table, columnName, type, plotInfo){

                @Override
                public TypeClassification typeClassification() {
                    return TypeClassification.COMPARABLE;
                }

                @Override
                public double getDouble(int i) {
                    throw new PlotUnsupportedOperationException("Double conversion not supported for comparables", plotInfo);
                }
            };
        }
        throw new PlotUnsupportedOperationException("Unsupported data type: columnName=" + columnName + " type=" + type, plotInfo);
    }

    public static ColumnHandler newObjectHandler(TableHandle tableHandle, String columnName, final PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(tableHandle, "tableHandle", plotInfo);
        ArgumentValidations.assertNotNull(columnName, "columnName", plotInfo);
        Class type = tableHandle.getTable().getDefinition().getColumn(columnName).getDataType();
        return new ColumnHandlerHandle(tableHandle, columnName, type, plotInfo){

            @Override
            public TypeClassification typeClassification() {
                return TypeClassification.OBJECT;
            }

            @Override
            public double getDouble(int i) {
                throw new PlotUnsupportedOperationException("Double conversion not supported for objects", plotInfo);
            }
        };
    }

    public static ColumnHandler newObjectHandler(Table table, String columnName, final PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(table, "table", plotInfo);
        ArgumentValidations.assertNotNull(columnName, "columnName", plotInfo);
        Class type = table.getDefinition().getColumn(columnName).getDataType();
        return new ColumnHandlerTable(table, columnName, type, plotInfo){

            @Override
            public TypeClassification typeClassification() {
                return TypeClassification.OBJECT;
            }

            @Override
            public double getDouble(int i) {
                throw new PlotUnsupportedOperationException("Double conversion not supported for objects", plotInfo);
            }
        };
    }

    private static abstract class ColumnHandlerHandle
    implements ColumnHandler,
    Serializable {
        private static final long serialVersionUID = -3633543948389633718L;
        private final TableHandle tableHandle;
        private final String columnName;
        private final Class type;
        private final PlotInfo plotInfo;
        private transient DataColumn dataColumn;

        private ColumnHandlerHandle(TableHandle tableHandle, String columnName, Class type, PlotInfo plotInfo) {
            this.type = type;
            ArgumentValidations.assertColumnsInTable(tableHandle, plotInfo, columnName);
            this.tableHandle = tableHandle;
            this.columnName = columnName;
            this.plotInfo = plotInfo;
        }

        protected DataColumn getDataColumn() {
            if (this.dataColumn == null) {
                this.dataColumn = this.tableHandle.getTable().getColumn(this.columnName);
            }
            return this.dataColumn;
        }

        @Override
        public TableHandle getTableHandle() {
            return this.tableHandle;
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }

        @Override
        public int size() {
            return this.getDataColumn().intSize();
        }

        @Override
        public Object get(int i) {
            return this.getDataColumn().get((long)i);
        }

        @Override
        public Class type() {
            return this.type;
        }

        @Override
        public abstract TypeClassification typeClassification();

        @Override
        public abstract double getDouble(int var1);
    }

    private static abstract class ColumnHandlerTable
    implements ColumnHandler {
        private Table table;
        private final String columnName;
        private final Class type;
        private transient DataColumn dataColumn;
        private final PlotInfo plotInfo;

        private ColumnHandlerTable(Table table, String columnName, Class type, PlotInfo plotInfo) {
            this.type = type;
            ArgumentValidations.assertColumnsInTable(table, plotInfo, columnName);
            this.table = table;
            this.columnName = columnName;
            this.plotInfo = plotInfo;
        }

        protected DataColumn getDataColumn() {
            if (this.dataColumn == null) {
                this.dataColumn = this.table.getColumn(this.columnName);
            }
            return this.dataColumn;
        }

        @Override
        public TableHandle getTableHandle() {
            throw new PlotUnsupportedOperationException("Local ColumnHandler does not support table handles", this.plotInfo);
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }

        @Override
        public int size() {
            return this.getDataColumn().intSize();
        }

        @Override
        public Object get(int i) {
            return this.getDataColumn().get((long)i);
        }

        @Override
        public Class type() {
            return this.type;
        }

        @Override
        public abstract TypeClassification typeClassification();

        @Override
        public abstract double getDouble(int var1);
    }

    public static interface ColumnHandler {
        public TableHandle getTableHandle();

        public String getColumnName();

        public int size();

        public Object get(int var1);

        public Class type();

        public TypeClassification typeClassification();

        public double getDouble(int var1);
    }

    public static enum TypeClassification {
        INTEGER(true),
        FLOATINGPOINT(true),
        TIME(true),
        PAINT(false),
        COMPARABLE(false),
        OBJECT(false);

        private boolean isNumeric;

        private TypeClassification(boolean isNumeric) {
            this.isNumeric = isNumeric;
        }

        public boolean isNumeric() {
            return this.isNumeric;
        }
    }
}

