/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.util.tables;

import io.deephaven.engine.table.PartitionedTable;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.engine.util.TableTools;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.PartitionedTableHandle;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartitionedTableBackedPartitionedTableHandle
extends PartitionedTableHandle {
    private static final long serialVersionUID = 4820388203519593898L;
    private TableDefinition tableDefinition;
    private transient Table tableDefinitionTable;
    private Set<String> viewColumns;

    public PartitionedTableBackedPartitionedTableHandle(PartitionedTable partitionedTable, TableDefinition tableDefinition, String[] keyColumns, PlotInfo plotInfo, Collection<String> columns) {
        this(partitionedTable, tableDefinition, keyColumns, plotInfo, columns, null);
    }

    public PartitionedTableBackedPartitionedTableHandle(@NotNull PartitionedTable partitionedTable, @NotNull TableDefinition tableDefinition, @NotNull String[] keyColumns, PlotInfo plotInfo, @NotNull Collection<String> columns, @Nullable Collection<String> viewColumns) {
        super(columns, keyColumns, plotInfo);
        ArgumentValidations.assertNotNull(partitionedTable, "partitionedTable", plotInfo);
        this.setPartitionedTable(partitionedTable);
        this.tableDefinition = tableDefinition;
        this.tableDefinitionTable = TableTools.newTable((TableDefinition)tableDefinition);
        this.viewColumns = viewColumns == null ? null : new HashSet<String>(viewColumns);
    }

    @Override
    public Set<String> getFetchViewColumns() {
        return this.viewColumns != null ? this.viewColumns : this.getColumns();
    }

    @Override
    public TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    @Override
    public void applyFunction(Function<Table, Table> function) {
        this.tableDefinitionTable = function.apply(this.tableDefinitionTable);
        this.tableDefinition = this.tableDefinitionTable.getDefinition();
    }
}

