/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.util.tables;

import io.deephaven.base.verify.Require;
import io.deephaven.plot.util.tables.PartitionedTableHandle;
import io.deephaven.plot.util.tables.SwappablePartitionedTable;
import io.deephaven.plot.util.tables.SwappableTable;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class SwappableTableOneClickAbstract
extends SwappableTable
implements SwappablePartitionedTable {
    private static final long serialVersionUID = 2L;
    protected final long updateInterval;
    protected final boolean requireAllFiltersToDisplay;
    protected final String[] byColumns;
    protected final PartitionedTableHandle partitionedTableHandle;
    private final Comparable seriesName;

    protected SwappableTableOneClickAbstract(@NotNull Comparable seriesName, long updateInterval, @NotNull PartitionedTableHandle partitionedTableHandle, boolean requireAllFiltersToDisplay, @NotNull String[] byColumns) {
        super(partitionedTableHandle);
        Require.neqNull((Object)byColumns, (String)"byColumns");
        this.partitionedTableHandle = partitionedTableHandle;
        this.seriesName = seriesName;
        this.updateInterval = updateInterval;
        this.requireAllFiltersToDisplay = requireAllFiltersToDisplay;
        this.byColumns = byColumns;
    }

    @Override
    public void addColumn(String column) {
        this.partitionedTableHandle.addColumn(column);
    }

    public Comparable getSeriesName() {
        return this.seriesName;
    }

    public abstract List<String> getByColumns();

    @Override
    public PartitionedTableHandle getPartitionedTableHandle() {
        return this.partitionedTableHandle;
    }

    public boolean isRequireAllFiltersToDisplay() {
        return this.requireAllFiltersToDisplay;
    }
}

