/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.util.tables;

import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class TableHandle
implements Serializable {
    private static final long serialVersionUID = 2390871455829249662L;
    private transient Table table;
    private final Set<String> columns;

    public TableHandle(@NotNull Table table, String ... columns) {
        this.table = table;
        this.columns = new TreeSet<String>(Arrays.asList((String[])Arrays.stream(columns).filter(Objects::nonNull).toArray(String[]::new)));
    }

    public void addColumn(String column) {
        this.columns.add(column);
    }

    public Set<String> getColumns() {
        return this.columns;
    }

    public boolean hasColumns(String ... cols) {
        return this.columns.containsAll(Arrays.asList(cols));
    }

    public Table getTable() {
        return this.table;
    }

    public TableDefinition getFinalTableDefinition() {
        return this.table.getDefinition();
    }

    public void setTable(Table table) {
        this.table = table;
    }
}

