/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.auth;

import com.google.rpc.Code;
import io.deephaven.auth.AuthContext;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.util.function.ThrowingRunnable;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;

public interface ServiceAuthWiring<ServiceImplBase> {
    public static void operationNotAllowed() {
        ServiceAuthWiring.operationNotAllowed("Operation not allowed");
    }

    public static void operationNotAllowed(String reason) {
        throw Exceptions.statusRuntimeException((Code)Code.PERMISSION_DENIED, (String)reason);
    }

    public ServerServiceDefinition intercept(ServiceImplBase var1);

    private static <ReqT, RespT> void quietlyCloseCall(ServerCall<ReqT, RespT> call, Status status, Metadata trailers) {
        try {
            call.close(status, trailers);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static <ReqT, RespT> ServerMethodDefinition<ReqT, RespT> intercept(ServerServiceDefinition service, String methodName, CallStartedCallback callStartedCallback, MessageReceivedCallback<ReqT> messageReceivedCallback) {
        String fullMethodName = service.getServiceDescriptor().getName() + "/" + methodName;
        ServerMethodDefinition method = service.getMethod(fullMethodName);
        if (method == null) {
            throw new IllegalStateException("No method found for name: " + fullMethodName);
        }
        ServerCallHandler delegate = method.getServerCallHandler();
        AuthorizingServerCallHandler authServerCallHandler = new AuthorizingServerCallHandler(delegate, method, callStartedCallback, messageReceivedCallback);
        return method.withServerCallHandler(authServerCallHandler);
    }

    public static class AuthorizingServerCallHandler<ReqT, RespT>
    implements ServerCallHandler<ReqT, RespT> {
        private static final Logger log = LoggerFactory.getLogger(AuthorizingServerCallHandler.class);
        private final ServerCallHandler<ReqT, RespT> delegate;
        private final CallStartedCallback callStartedCallback;
        private final MessageReceivedCallback<ReqT> messageReceivedCallback;
        private final boolean mustHaveRequest;
        private final String fullMethodName;

        public AuthorizingServerCallHandler(ServerCallHandler<ReqT, RespT> delegate, ServerMethodDefinition<ReqT, RespT> method, CallStartedCallback callStartedCallback, MessageReceivedCallback<ReqT> messageReceivedCallback) {
            this.delegate = delegate;
            this.callStartedCallback = callStartedCallback;
            this.messageReceivedCallback = messageReceivedCallback;
            this.mustHaveRequest = method.getMethodDescriptor().getType().clientSendsOneMessage();
            this.fullMethodName = method.getMethodDescriptor().getFullMethodName();
            if (!this.mustHaveRequest) {
                Assert.neqNull((Object)callStartedCallback, (String)"callStartedCallback");
            }
            Assert.neqNull(messageReceivedCallback, (String)"messageReceivedCallback");
        }

        public ServerCall.Listener<ReqT> startCall(final ServerCall<ReqT, RespT> call, Metadata headers) {
            final AuthContext authContext = ExecutionContext.getContext().getAuthContext();
            if (!this.mustHaveRequest && !this.validateAuth(call, (ThrowingRunnable<ReflectiveOperationException>)((ThrowingRunnable)() -> this.callStartedCallback.callStarted(authContext)))) {
                return new ServerCall.Listener<ReqT>(){};
            }
            ServerCall.Listener delegateCall = this.delegate.startCall(call, headers);
            return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(delegateCall){

                public void onMessage(ReqT message) {
                    if (!this.validateAuth(call, (ThrowingRunnable<ReflectiveOperationException>)((ThrowingRunnable)() -> messageReceivedCallback.messageReceived(authContext, message)))) {
                        return;
                    }
                    this.delegate().onMessage(message);
                }
            };
        }

        private boolean validateAuth(ServerCall<ReqT, RespT> call, ThrowingRunnable<ReflectiveOperationException> authRunner) {
            try {
                authRunner.run();
            }
            catch (ReflectiveOperationException | RuntimeException originalErr) {
                Throwable err = originalErr;
                if (!(err instanceof StatusRuntimeException) && err.getCause() != null) {
                    err = err.getCause();
                }
                if (err instanceof StatusRuntimeException) {
                    StatusRuntimeException sre = (StatusRuntimeException)err;
                    Status.Code status = sre.getStatus().getCode();
                    switch (status) {
                        case UNAUTHENTICATED: {
                            log.info().append((CharSequence)this.fullMethodName).append((CharSequence)": request unauthenticated").endl();
                            break;
                        }
                        case PERMISSION_DENIED: {
                            log.info().append((CharSequence)this.fullMethodName).append((CharSequence)": request unauthorized").endl();
                            break;
                        }
                        case RESOURCE_EXHAUSTED: {
                            log.info().append((CharSequence)this.fullMethodName).append((CharSequence)": request throttled").endl();
                            break;
                        }
                        default: {
                            log.error().append((CharSequence)this.fullMethodName).append((CharSequence)": authorization failed: ").append(err).endl();
                        }
                    }
                    ServiceAuthWiring.quietlyCloseCall(call, sre.getStatus(), sre.getTrailers());
                    return false;
                }
                log.error().append((CharSequence)"Failed to invoke auth method: ").append((Throwable)originalErr).endl();
                ServiceAuthWiring.quietlyCloseCall(call, Status.UNAUTHENTICATED, new Metadata());
                return false;
            }
            return true;
        }
    }

    @FunctionalInterface
    public static interface MessageReceivedCallback<T> {
        public void messageReceived(AuthContext var1, T var2);
    }

    @FunctionalInterface
    public static interface CallStartedCallback {
        public void callStarted(AuthContext var1);
    }
}

