/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.auth.codegen.impl;

import io.deephaven.auth.AuthContext;
import io.deephaven.auth.ServiceAuthWiring;
import io.deephaven.proto.backplane.script.grpc.AutoCompleteRequest;
import io.deephaven.proto.backplane.script.grpc.BindTableToVariableRequest;
import io.deephaven.proto.backplane.script.grpc.CancelAutoCompleteRequest;
import io.deephaven.proto.backplane.script.grpc.CancelCommandRequest;
import io.deephaven.proto.backplane.script.grpc.ConsoleServiceGrpc;
import io.deephaven.proto.backplane.script.grpc.ExecuteCommandRequest;
import io.deephaven.proto.backplane.script.grpc.GetConsoleTypesRequest;
import io.deephaven.proto.backplane.script.grpc.GetHeapInfoRequest;
import io.deephaven.proto.backplane.script.grpc.LogSubscriptionRequest;
import io.deephaven.proto.backplane.script.grpc.StartConsoleRequest;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;

public interface ConsoleServiceAuthWiring
extends ServiceAuthWiring<ConsoleServiceGrpc.ConsoleServiceImplBase> {
    @Override
    default public ServerServiceDefinition intercept(ConsoleServiceGrpc.ConsoleServiceImplBase delegate) {
        ServerServiceDefinition service = delegate.bindService();
        ServerServiceDefinition.Builder serviceBuilder = ServerServiceDefinition.builder((ServiceDescriptor)service.getServiceDescriptor());
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "GetConsoleTypes", null, this::onMessageReceivedGetConsoleTypes));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "StartConsole", null, this::onMessageReceivedStartConsole));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "GetHeapInfo", null, this::onMessageReceivedGetHeapInfo));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "SubscribeToLogs", null, this::onMessageReceivedSubscribeToLogs));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "ExecuteCommand", null, this::onMessageReceivedExecuteCommand));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "CancelCommand", null, this::onMessageReceivedCancelCommand));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "BindTableToVariable", null, this::onMessageReceivedBindTableToVariable));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "AutoCompleteStream", this::onCallStartedAutoCompleteStream, this::onMessageReceivedAutoCompleteStream));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "CancelAutoComplete", null, this::onMessageReceivedCancelAutoComplete));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "OpenAutoCompleteStream", null, this::onMessageReceivedOpenAutoCompleteStream));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "NextAutoCompleteStream", null, this::onMessageReceivedNextAutoCompleteStream));
        return serviceBuilder.build();
    }

    public void onMessageReceivedGetConsoleTypes(AuthContext var1, GetConsoleTypesRequest var2);

    public void onMessageReceivedStartConsole(AuthContext var1, StartConsoleRequest var2);

    public void onMessageReceivedGetHeapInfo(AuthContext var1, GetHeapInfoRequest var2);

    public void onMessageReceivedSubscribeToLogs(AuthContext var1, LogSubscriptionRequest var2);

    public void onMessageReceivedExecuteCommand(AuthContext var1, ExecuteCommandRequest var2);

    public void onMessageReceivedCancelCommand(AuthContext var1, CancelCommandRequest var2);

    public void onMessageReceivedBindTableToVariable(AuthContext var1, BindTableToVariableRequest var2);

    public void onCallStartedAutoCompleteStream(AuthContext var1);

    public void onMessageReceivedAutoCompleteStream(AuthContext var1, AutoCompleteRequest var2);

    public void onMessageReceivedCancelAutoComplete(AuthContext var1, CancelAutoCompleteRequest var2);

    public void onMessageReceivedOpenAutoCompleteStream(AuthContext var1, AutoCompleteRequest var2);

    public void onMessageReceivedNextAutoCompleteStream(AuthContext var1, AutoCompleteRequest var2);

    public static class TestUseOnly
    implements ConsoleServiceAuthWiring {
        public ConsoleServiceAuthWiring delegate;

        @Override
        public void onMessageReceivedGetConsoleTypes(AuthContext authContext, GetConsoleTypesRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedGetConsoleTypes(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedStartConsole(AuthContext authContext, StartConsoleRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedStartConsole(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedGetHeapInfo(AuthContext authContext, GetHeapInfoRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedGetHeapInfo(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedSubscribeToLogs(AuthContext authContext, LogSubscriptionRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedSubscribeToLogs(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedExecuteCommand(AuthContext authContext, ExecuteCommandRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedExecuteCommand(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedCancelCommand(AuthContext authContext, CancelCommandRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedCancelCommand(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedBindTableToVariable(AuthContext authContext, BindTableToVariableRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedBindTableToVariable(authContext, request);
            }
        }

        @Override
        public void onCallStartedAutoCompleteStream(AuthContext authContext) {
            if (this.delegate != null) {
                this.delegate.onCallStartedAutoCompleteStream(authContext);
            }
        }

        @Override
        public void onMessageReceivedAutoCompleteStream(AuthContext authContext, AutoCompleteRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedAutoCompleteStream(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedCancelAutoComplete(AuthContext authContext, CancelAutoCompleteRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedCancelAutoComplete(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedOpenAutoCompleteStream(AuthContext authContext, AutoCompleteRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedOpenAutoCompleteStream(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedNextAutoCompleteStream(AuthContext authContext, AutoCompleteRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedNextAutoCompleteStream(authContext, request);
            }
        }
    }

    public static class DenyAll
    implements ConsoleServiceAuthWiring {
        @Override
        public void onMessageReceivedGetConsoleTypes(AuthContext authContext, GetConsoleTypesRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedStartConsole(AuthContext authContext, StartConsoleRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedGetHeapInfo(AuthContext authContext, GetHeapInfoRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedSubscribeToLogs(AuthContext authContext, LogSubscriptionRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedExecuteCommand(AuthContext authContext, ExecuteCommandRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedCancelCommand(AuthContext authContext, CancelCommandRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedBindTableToVariable(AuthContext authContext, BindTableToVariableRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onCallStartedAutoCompleteStream(AuthContext authContext) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedAutoCompleteStream(AuthContext authContext, AutoCompleteRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedCancelAutoComplete(AuthContext authContext, CancelAutoCompleteRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedOpenAutoCompleteStream(AuthContext authContext, AutoCompleteRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedNextAutoCompleteStream(AuthContext authContext, AutoCompleteRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }
    }

    public static class AllowAll
    implements ConsoleServiceAuthWiring {
        @Override
        public void onMessageReceivedGetConsoleTypes(AuthContext authContext, GetConsoleTypesRequest request) {
        }

        @Override
        public void onMessageReceivedStartConsole(AuthContext authContext, StartConsoleRequest request) {
        }

        @Override
        public void onMessageReceivedGetHeapInfo(AuthContext authContext, GetHeapInfoRequest request) {
        }

        @Override
        public void onMessageReceivedSubscribeToLogs(AuthContext authContext, LogSubscriptionRequest request) {
        }

        @Override
        public void onMessageReceivedExecuteCommand(AuthContext authContext, ExecuteCommandRequest request) {
        }

        @Override
        public void onMessageReceivedCancelCommand(AuthContext authContext, CancelCommandRequest request) {
        }

        @Override
        public void onMessageReceivedBindTableToVariable(AuthContext authContext, BindTableToVariableRequest request) {
        }

        @Override
        public void onCallStartedAutoCompleteStream(AuthContext authContext) {
        }

        @Override
        public void onMessageReceivedAutoCompleteStream(AuthContext authContext, AutoCompleteRequest request) {
        }

        @Override
        public void onMessageReceivedCancelAutoComplete(AuthContext authContext, CancelAutoCompleteRequest request) {
        }

        @Override
        public void onMessageReceivedOpenAutoCompleteStream(AuthContext authContext, AutoCompleteRequest request) {
        }

        @Override
        public void onMessageReceivedNextAutoCompleteStream(AuthContext authContext, AutoCompleteRequest request) {
        }
    }
}

