/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.auth.codegen.impl;

import io.deephaven.auth.AuthContext;
import io.deephaven.auth.ServiceAuthWiring;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.health.v1.HealthCheckRequest;
import io.grpc.health.v1.HealthGrpc;

public interface HealthAuthWiring
extends ServiceAuthWiring<HealthGrpc.HealthImplBase> {
    @Override
    default public ServerServiceDefinition intercept(HealthGrpc.HealthImplBase delegate) {
        ServerServiceDefinition service = delegate.bindService();
        ServerServiceDefinition.Builder serviceBuilder = ServerServiceDefinition.builder((ServiceDescriptor)service.getServiceDescriptor());
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "Check", null, this::onMessageReceivedCheck));
        serviceBuilder.addMethod(ServiceAuthWiring.intercept(service, "Watch", null, this::onMessageReceivedWatch));
        return serviceBuilder.build();
    }

    public void onMessageReceivedCheck(AuthContext var1, HealthCheckRequest var2);

    public void onMessageReceivedWatch(AuthContext var1, HealthCheckRequest var2);

    public static class TestUseOnly
    implements HealthAuthWiring {
        public HealthAuthWiring delegate;

        @Override
        public void onMessageReceivedCheck(AuthContext authContext, HealthCheckRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedCheck(authContext, request);
            }
        }

        @Override
        public void onMessageReceivedWatch(AuthContext authContext, HealthCheckRequest request) {
            if (this.delegate != null) {
                this.delegate.onMessageReceivedWatch(authContext, request);
            }
        }
    }

    public static class DenyAll
    implements HealthAuthWiring {
        @Override
        public void onMessageReceivedCheck(AuthContext authContext, HealthCheckRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }

        @Override
        public void onMessageReceivedWatch(AuthContext authContext, HealthCheckRequest request) {
            ServiceAuthWiring.operationNotAllowed();
        }
    }

    public static class AllowAll
    implements HealthAuthWiring {
        @Override
        public void onMessageReceivedCheck(AuthContext authContext, HealthCheckRequest request) {
        }

        @Override
        public void onMessageReceivedWatch(AuthContext authContext, HealthCheckRequest request) {
        }
    }
}

