/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.auth.codegen.impl;

import io.deephaven.auth.AuthContext;
import io.deephaven.auth.ServiceAuthWiring;
import io.deephaven.engine.table.Table;
import io.deephaven.proto.backplane.grpc.HierarchicalTableApplyRequest;
import io.deephaven.proto.backplane.grpc.HierarchicalTableSourceExportRequest;
import io.deephaven.proto.backplane.grpc.HierarchicalTableViewRequest;
import io.deephaven.proto.backplane.grpc.RollupRequest;
import io.deephaven.proto.backplane.grpc.TreeRequest;
import java.util.List;

public interface HierarchicalTableServiceContextualAuthWiring {
    public void checkPermissionRollup(AuthContext var1, RollupRequest var2, List<Table> var3);

    public void checkPermissionTree(AuthContext var1, TreeRequest var2, List<Table> var3);

    public void checkPermissionApply(AuthContext var1, HierarchicalTableApplyRequest var2, List<Table> var3);

    public void checkPermissionView(AuthContext var1, HierarchicalTableViewRequest var2, List<Table> var3);

    public void checkPermissionExportSource(AuthContext var1, HierarchicalTableSourceExportRequest var2, List<Table> var3);

    public static class TestUseOnly
    implements HierarchicalTableServiceContextualAuthWiring {
        public HierarchicalTableServiceContextualAuthWiring delegate;

        @Override
        public void checkPermissionRollup(AuthContext authContext, RollupRequest request, List<Table> sourceTables) {
            if (this.delegate != null) {
                this.delegate.checkPermissionRollup(authContext, request, sourceTables);
            }
        }

        @Override
        public void checkPermissionTree(AuthContext authContext, TreeRequest request, List<Table> sourceTables) {
            if (this.delegate != null) {
                this.delegate.checkPermissionTree(authContext, request, sourceTables);
            }
        }

        @Override
        public void checkPermissionApply(AuthContext authContext, HierarchicalTableApplyRequest request, List<Table> sourceTables) {
            if (this.delegate != null) {
                this.delegate.checkPermissionApply(authContext, request, sourceTables);
            }
        }

        @Override
        public void checkPermissionView(AuthContext authContext, HierarchicalTableViewRequest request, List<Table> sourceTables) {
            if (this.delegate != null) {
                this.delegate.checkPermissionView(authContext, request, sourceTables);
            }
        }

        @Override
        public void checkPermissionExportSource(AuthContext authContext, HierarchicalTableSourceExportRequest request, List<Table> sourceTables) {
            if (this.delegate != null) {
                this.delegate.checkPermissionExportSource(authContext, request, sourceTables);
            }
        }
    }

    public static class DenyAll
    extends DelegateAll {
        @Override
        protected void checkPermission(AuthContext authContext, List<Table> sourceTables) {
            ServiceAuthWiring.operationNotAllowed();
        }
    }

    public static class AllowAll
    extends DelegateAll {
        @Override
        protected void checkPermission(AuthContext authContext, List<Table> sourceTables) {
        }
    }

    public static abstract class DelegateAll
    implements HierarchicalTableServiceContextualAuthWiring {
        protected abstract void checkPermission(AuthContext var1, List<Table> var2);

        @Override
        public void checkPermissionRollup(AuthContext authContext, RollupRequest request, List<Table> sourceTables) {
            this.checkPermission(authContext, sourceTables);
        }

        @Override
        public void checkPermissionTree(AuthContext authContext, TreeRequest request, List<Table> sourceTables) {
            this.checkPermission(authContext, sourceTables);
        }

        @Override
        public void checkPermissionApply(AuthContext authContext, HierarchicalTableApplyRequest request, List<Table> sourceTables) {
            this.checkPermission(authContext, sourceTables);
        }

        @Override
        public void checkPermissionView(AuthContext authContext, HierarchicalTableViewRequest request, List<Table> sourceTables) {
            this.checkPermission(authContext, sourceTables);
        }

        @Override
        public void checkPermissionExportSource(AuthContext authContext, HierarchicalTableSourceExportRequest request, List<Table> sourceTables) {
            this.checkPermission(authContext, sourceTables);
        }
    }
}

